/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.w3validators.css;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.w3validators.W3ValidatorsBundle;
import org.jetbrains.w3validators.css.W3CssExternalAnnotator;

public class W3CssValidatorInspection
extends CssApiBaseInspection {
    @NonNls
    public static final String SHORT_NAME = "W3CssValidation";
    public String myCssVersion = "css3svg";
    public boolean myIgnoreVendorSpecificProperties = false;
    private static final @NonNls Map<@NlsSafe String, String> myVersionToProfile = new TreeMap<String, String>();

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myCssVersion", (String)W3ValidatorsBundle.message("css.version.panel.title", new Object[0]), myVersionToProfile.entrySet(), Map.Entry::getValue, Map.Entry::getKey), OptPane.checkbox((String)"myIgnoreVendorSpecificProperties", (String)W3ValidatorsBundle.message("ignore.vendor.specific.properties", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            W3CssValidatorInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            W3CssValidatorInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            W3CssValidatorInspection.$$$reportNull$$$0(2);
        }
        if (isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        W3CssExternalAnnotator annotator = new W3CssExternalAnnotator();
        W3CssExternalAnnotator.MyVisitor info = annotator.collectInformation(file);
        if (info != null) {
            W3CssExternalAnnotator.MyVisitor annotationResult = annotator.doAnnotate(info);
            return W3CssExternalAnnotator.applyToToProblemDescriptors(file, annotationResult, manager, isOnTheFly).toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static {
        myVersionToProfile.put("CSS Level 1", "css1");
        myVersionToProfile.put("CSS Level 2", "css2");
        myVersionToProfile.put("CSS Level 2.1", "css21");
        myVersionToProfile.put("CSS Level 3", "css3");
        myVersionToProfile.put("CSS Level 3 + SVG", "css3svg");
        myVersionToProfile.put("SVG", "svg");
        myVersionToProfile.put("SVG Basic", "svgbasic");
        myVersionToProfile.put("SVG tiny", "svgtiny");
        myVersionToProfile.put("Mobile", "mobile");
        myVersionToProfile.put("ATSC TV", "atsc-tv");
        myVersionToProfile.put("TV", "tv");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/w3validators/css/W3CssValidatorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/w3validators/css/W3CssValidatorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

