/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.w3validators.css;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBackedByIntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.css.inspections.suppress.CssSuppressionUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.w3validators.W3ValidatorsBundle;
import org.jetbrains.w3validators.css.W3CssValidatorInspection;
import org.jetbrains.w3validators.css.W3DisableInspectionFix;
import org.jetbrains.w3validators.css.W3IgnoreVendorPropertiesFix;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.Token;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public class W3CssExternalAnnotator
extends ExternalAnnotator<MyVisitor, MyVisitor> {
    private static final Logger LOG = Logger.getInstance(W3CssExternalAnnotator.class);

    public MyVisitor collectInformation(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof XmlFile) && !(psiFile instanceof CssFile)) {
            return null;
        }
        W3CssValidatorInspection inspection = W3CssExternalAnnotator.getInspection((PsiElement)psiFile);
        if (inspection == null) {
            return null;
        }
        MyVisitor visitor = new MyVisitor(inspection.myCssVersion, inspection.myIgnoreVendorSpecificProperties);
        psiFile.accept((PsiElementVisitor)visitor);
        return visitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyVisitor doAnnotate(MyVisitor visitor) {
        ApplContext context = new ApplContext("css/text");
        context.setCssVersionAndProfile(visitor.myCssVersion);
        context.setTreatVendorExtensionsAsWarnings(visitor.myIgnoreVendorSpecificProperties);
        for (MyInfo info : visitor.myInfos) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(info.myStylesheetText.getBytes(StandardCharsets.UTF_8));
            try {
                context.setCharsetForURL(info.myUrl, info.myCharset);
                StyleSheetParser parser = new StyleSheetParser(context);
                parser.parseStyleElement(context, (InputStream)inputStream, null, "all", info.myUrl, 0);
                StyleSheet styleSheet = parser.getStyleSheet();
                styleSheet.findConflicts(context);
                info.myErrors = styleSheet.getErrors();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return visitor;
    }

    public void apply(@NotNull PsiFile psiFile, MyVisitor visitor, @NotNull AnnotationHolder holder) {
        if (psiFile == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(2);
        }
        ProblemSink problemSink = (selectorList, message, fixes) -> {
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.WARNING, message).range(selectorList);
            for (IntentionAction fix : fixes) {
                builder = builder.withFix(fix);
            }
            builder.create();
        };
        W3CssExternalAnnotator.apply(psiFile, visitor, problemSink);
    }

    private static void apply(@NotNull PsiFile file, @NotNull MyVisitor visitor, @NotNull ProblemSink problemSink) {
        if (file == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (visitor == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (problemSink == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (!file.isValid()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        for (MyInfo info : visitor.myInfos) {
            PsiElement element;
            if (info.myErrors == null || !((element = info.myStylesheetAnchor.retrieve()) instanceof CssStylesheet)) continue;
            W3CssExternalAnnotator.reportErrors((CssStylesheet)element, document, info.myErrors, problemSink);
        }
    }

    @NotNull
    static List<ProblemDescriptor> applyToToProblemDescriptors(@NotNull PsiFile file, @NotNull MyVisitor visitor, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (visitor == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(8);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        W3CssExternalAnnotator.apply(file, visitor, (selectorList, message, actions) -> {
            LocalQuickFix[] fixes = (LocalQuickFix[])ContainerUtil.map2Array((Collection)actions, LocalQuickFix.class, i -> new LocalQuickFixBackedByIntentionAction(i));
            ProblemDescriptor descriptor = manager.createProblemDescriptor(selectorList, message, isOnTheFly, fixes, ProblemHighlightType.WARNING);
            result.add(descriptor);
        });
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static W3CssValidatorInspection getInspection(@NotNull PsiElement context) {
        if (context == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(10);
        }
        String shortName = "W3CssValidation";
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"W3CssValidation");
        if (key == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context)) {
            return null;
        }
        return (W3CssValidatorInspection)profile.getUnwrappedTool("W3CssValidation", context);
    }

    private static void reportErrors(CssStylesheet stylesheet, Document document, Errors errors, @NotNull ProblemSink problemSink) {
        if (problemSink == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(11);
        }
        ProgressManager.checkCanceled();
        int startLine = document.getLineNumber(stylesheet.getTextRange().getStartOffset());
        PsiFile psiFile = stylesheet.getContainingFile();
        W3CssValidatorInspection inspection = W3CssExternalAnnotator.getInspection((PsiElement)stylesheet);
        for (CssError error : errors.getErrors()) {
            PsiElement selectorList;
            PsiElement parent;
            String message;
            ProgressManager.checkCanceled();
            int line = error.getLine() - 1;
            if (line <= 0) continue;
            int startOffset = document.getLineStartOffset(line + startLine);
            Throwable exception = error.getException();
            if (!(exception instanceof ParseException)) continue;
            ParseException parseException = (ParseException)exception;
            if (parseException instanceof CssParseException) {
                CssParseException cssParseException = (CssParseException)parseException;
                String message2 = parseException.getMessage();
                message2 = message2 == null ? W3ValidatorsBundle.message("inspection.message.parse.error", new Object[0]) : message2;
                String property = cssParseException.getProperty();
                if (property != null) {
                    PsiElement element;
                    PsiElement psiElement = psiFile.findElementAt(startOffset);
                    if (psiElement instanceof PsiWhiteSpace) {
                        psiElement = psiFile.findElementAt(psiElement.getTextRange().getEndOffset());
                    }
                    if (psiElement == null || !((element = psiElement.getParent()) instanceof CssDeclaration)) continue;
                    CssDeclaration firstDecl = (CssDeclaration)element;
                    int endOffset = document.getLineEndOffset(line + startLine);
                    CssDeclaration decl = W3CssExternalAnnotator.findCssDeclaration(property, firstDecl, new TextRange(startOffset, endOffset));
                    W3CssExternalAnnotator.registerProblem((PsiElement)(decl != null ? decl : firstDecl), W3ValidatorsBundle.message("inspection.message.w3c", message2), inspection, problemSink);
                    continue;
                }
                Exception innerParseException = cssParseException.getException();
                if (!(innerParseException instanceof ParseException)) continue;
                ParseException parseException1 = (ParseException)innerParseException;
                message2 = W3ValidatorsBundle.message("inspection.message.w3c.parse.error", cssParseException.getSkippedString());
                Token token = parseException1.currentToken;
                if (token == null) continue;
                int tokenLine = token.beginLine - 1;
                int tokenColumn = token.beginColumn;
                int lineStartOffset = document.getLineStartOffset(tokenLine + startLine);
                PsiElement psiElement = psiFile.findElementAt(lineStartOffset + tokenColumn);
                if (psiElement == null) continue;
                W3CssExternalAnnotator.registerProblem(psiElement, message2, inspection, problemSink);
                continue;
            }
            if (!(parseException instanceof InvalidParamException)) continue;
            PsiElement psiElement = psiFile.findElementAt(startOffset);
            if (psiElement instanceof PsiWhiteSpace) {
                psiElement = psiFile.findElementAt(psiElement.getTextRange().getEndOffset());
            }
            if ((message = parseException.getMessage()) == null || psiElement == null) continue;
            PsiElement element = psiElement.getParent();
            if (element instanceof CssDeclaration) {
                CssDeclaration declaration = (CssDeclaration)element;
                W3CssExternalAnnotator.registerProblem((PsiElement)declaration, W3ValidatorsBundle.message("inspection.message.w3c", message), inspection, problemSink);
                continue;
            }
            if (!(element instanceof CssSimpleSelector) || !((parent = element.getParent()) instanceof CssSelector) || (selectorList = parent.getParent()) == null) continue;
            W3CssExternalAnnotator.registerProblem(selectorList, W3ValidatorsBundle.message("inspection.message.w3c", message), inspection, problemSink);
        }
    }

    private static void registerProblem(@NotNull PsiElement selectorList, @InspectionMessage String message, @Nullable W3CssValidatorInspection inspection, @NotNull ProblemSink problemSink) {
        CssTermList value;
        if (selectorList == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(12);
        }
        if (problemSink == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(13);
        }
        if (inspection == null || CssSuppressionUtil.isSuppressedFor((PsiElement)selectorList, (String)inspection.getID())) {
            return;
        }
        if (selectorList instanceof CssDeclaration && (value = ((CssDeclaration)selectorList).getValue()) != null) {
            for (PsiElement child : value.getChildren()) {
                PsiElement[] children;
                if (!(child instanceof CssTerm)) continue;
                for (PsiElement element : children = child.getChildren()) {
                    if (!(element instanceof CssUri) || !InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) continue;
                    return;
                }
            }
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (!inspection.myIgnoreVendorSpecificProperties && selectorList instanceof CssDeclaration && StringUtil.startsWithChar((CharSequence)((CssDeclaration)selectorList).getPropertyName(), (char)'-')) {
            fixes.add(new W3IgnoreVendorPropertiesFix(inspection));
        }
        fixes.add(new W3DisableInspectionFix(inspection));
        problemSink.registerProblem(selectorList, message, fixes);
    }

    @Nullable
    private static CssDeclaration findCssDeclaration(@NotNull String propertyName, @NotNull CssDeclaration first, @NotNull TextRange lineRange) {
        if (propertyName == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(14);
        }
        if (first == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(15);
        }
        if (lineRange == null) {
            W3CssExternalAnnotator.$$$reportNull$$$0(16);
        }
        for (CssDeclaration element = first; element != null && (element == first || lineRange.contains(element.getTextRange())); element = element.getNextSibling()) {
            CssDeclaration decl;
            if (!(element instanceof CssDeclaration) || !propertyName.equalsIgnoreCase((decl = element).getPropertyName())) continue;
            return decl;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/w3validators/css/W3CssExternalAnnotator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/w3validators/css/W3CssExternalAnnotator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToToProblemDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyToToProblemDescriptors";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInspection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportErrors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCssDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static class MyVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private final List<MyInfo> myInfos = new ArrayList<MyInfo>();
        private final String myCssVersion;
        private final boolean myIgnoreVendorSpecificProperties;

        public MyVisitor(String cssVersion, boolean ignoreVendorSpecificProperties) {
            this.myIgnoreVendorSpecificProperties = ignoreVendorSpecificProperties;
            this.myCssVersion = cssVersion;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super.visitElement(element);
            if (element instanceof CssStylesheet) {
                CssStylesheet stylesheet = (CssStylesheet)element;
                this.stopWalking();
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)stylesheet);
                if (descriptorProvider == null || !descriptorProvider.providesClassicCss()) {
                    return;
                }
                if (!stylesheet.isValid()) {
                    return;
                }
                if (PsiUtilCore.getTemplateLanguageFile((PsiElement)stylesheet) != stylesheet.getContainingFile()) {
                    return;
                }
                String s = stylesheet.getText();
                try {
                    String url;
                    String protocol;
                    VirtualFile virtualFile;
                    PsiFile psiFile = stylesheet.getContainingFile();
                    if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && ("file".equals(protocol = VirtualFileManager.extractProtocol((String)(url = virtualFile.getUrl()))) || "temp".equals(protocol))) {
                        Charset charset = MyVisitor.getCharset(stylesheet);
                        URL urlObj = new URL(null, url, new MyHandler());
                        this.myInfos.add(new MyInfo(urlObj, PsiAnchor.create((PsiElement)stylesheet), s, charset));
                    }
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static Charset getCharset(CssStylesheet stylesheet) {
            String charsetName;
            CssCharset charsetElement = stylesheet.getCharset();
            if (charsetElement != null && (charsetName = charsetElement.getValue()) != null) {
                try {
                    return Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                    LOG.info((Throwable)e);
                }
            }
            return Charset.defaultCharset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/w3validators/css/W3CssExternalAnnotator$MyVisitor", "visitElement"));
        }
    }

    private static final class MyInfo {
        private final URL myUrl;
        private final String myStylesheetText;
        private final PsiAnchor myStylesheetAnchor;
        private final Charset myCharset;
        public volatile Errors myErrors;

        private MyInfo(URL url, PsiAnchor stylesheetAnchor, String stylesheetText, Charset charset) {
            this.myUrl = url;
            this.myStylesheetAnchor = stylesheetAnchor;
            this.myStylesheetText = stylesheetText;
            this.myCharset = charset;
        }
    }

    static interface ProblemSink {
        public void registerProblem(@NotNull PsiElement var1, @InspectionMessage @NotNull String var2, @NotNull List<? extends IntentionAction> var3);
    }

    private static class MyHandler
    extends URLStreamHandler {
        private MyHandler() {
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        protected void parseURL(URL url, String s, int i, int j) {
            super.parseURL(url, s.replace(File.separatorChar, '/'), i, j);
        }

        @Override
        protected boolean hostsEqual(URL url1, URL url2) {
            String host1 = url1.getHost();
            String host2 = url2.getHost();
            if ("localhost".equalsIgnoreCase(host1) && StringUtil.isEmpty((String)host2)) {
                return true;
            }
            if ("localhost".equalsIgnoreCase(host2) && StringUtil.isEmpty((String)host1)) {
                return true;
            }
            return StringUtil.equals((CharSequence)host1, (CharSequence)host2);
        }
    }
}

