/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.wizard;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.startup.importSettings.transfer.backend.LegacySettingsTransferWizard;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.plugins.appender.wizard.WizardStartupUtil;
import com.jetbrains.rider.plugins.appender.wizard.steps.transferSettings.RiderTransferSettingsWizardStepController;
import com.jetbrains.rider.plugins.appender.wizard.themes.RiderThemeWizardStepController;
import com.jetbrains.rider.wizard.RiderStartupWizardSupport;
import com.jetbrains.rider.wizard.RiderWizardDialog;
import com.jetbrains.rider.wizard.core.model.RiderWizardContext;
import com.jetbrains.rider.wizard.core.stat.RiderWizardStat;
import com.jetbrains.rider.wizard.core.stat.RiderWizardVariant;
import com.jetbrains.rider.wizard.steps.base.RiderWizardStepController;
import com.jetbrains.rider.wizard.steps.featuredPlugins.RiderFeaturedPluginsWizardStepController;
import com.jetbrains.rider.wizard.steps.keymap.RiderKeymapWizardStepController;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/wizard/RiderWizardStartupListener;", "Lcom/intellij/ide/AppLifecycleListener;", "<init>", "()V", "appFrameCreated", "", "commandLineArgs", "", "", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderWizardStartupListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWizardStartupListener.kt\ncom/jetbrains/rider/plugins/appender/wizard/RiderWizardStartupListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n23#2:69\n*S KotlinDebug\n*F\n+ 1 RiderWizardStartupListener.kt\ncom/jetbrains/rider/plugins/appender/wizard/RiderWizardStartupListener\n*L\n28#1:69\n*E\n"})
final class RiderWizardStartupListener
implements AppLifecycleListener {
    public void appFrameCreated(@NotNull List<String> commandLineArgs) {
        Intrinsics.checkNotNullParameter(commandLineArgs, (String)"commandLineArgs");
        if (!InitialConfigImportState.isNewUser() || AppMode.isRemoteDevHost() || RiderStartupWizardSupport.INSTANCE.isNewWizardEnabled()) {
            return;
        }
        ApplicationKt.getApplication().invokeLater(() -> RiderWizardStartupListener.appFrameCreated$lambda$0(this));
    }

    private static final void appFrameCreated$lambda$0(RiderWizardStartupListener this$0) {
        RiderWizardStartupListener $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RiderWizardStartupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        logger2.info("Waiting for the initial start.");
        CompletableDeferred<Boolean> isInitialStart = WizardStartupUtil.isInitialStart();
        if (isInitialStart != null && isInitialStart.isCompleted()) {
            boolean isStartSuccessful;
            boolean bl = isStartSuccessful = isInitialStart.isCancelled() || (Boolean)isInitialStart.getCompleted() != false;
            if (isInitialStart.isCancelled()) {
                logger2.warn("Initial start flag cancelled. Proceeding with the wizard.");
            }
            if (!isStartSuccessful) {
                return;
            }
        }
        logger2.info("Starting welcome wizard on ui thread");
        LegacySettingsTransferWizard.INSTANCE.withRelaxedThreading(RiderWizardStartupListener::appFrameCreated$lambda$0$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit appFrameCreated$lambda$0$0() {
        RiderWizardDialog riderWizardDialog;
        RiderWizardDialog $this$appFrameCreated_u24lambda_u240_u240_u241 = riderWizardDialog = new RiderWizardDialog(RiderWizardStartupListener::appFrameCreated$lambda$0$0$0);
        boolean bl = false;
        try {
            RiderWizardStat.INSTANCE.onShown(RiderWizardVariant.OldWizard);
            PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
            Window window = $this$appFrameCreated_u24lambda_u240_u240_u241.getPeer().getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            Component component2 = window;
            Disposable disposable = $this$appFrameCreated_u24lambda_u240_u240_u241.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            permittedModalitiesImpl.allowPumpProtocolForComponent(component2, disposable);
            $this$appFrameCreated_u24lambda_u240_u240_u241.showAndGet();
        }
        finally {
            RiderWizardStat.INSTANCE.onFinished((List)$this$appFrameCreated_u24lambda_u240_u240_u241.getModel().getStepModels());
        }
        return Unit.INSTANCE;
    }

    private static final List appFrameCreated$lambda$0$0$0(Lifetime lifetime, RiderWizardContext ctx) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new RiderWizardStepController[]{new RiderTransferSettingsWizardStepController(lifetime, ctx), new RiderThemeWizardStepController(lifetime), new RiderKeymapWizardStepController(), new RiderFeaturedPluginsWizardStepController(lifetime, ctx)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

