/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.settingsSync.core.SettingsProvider;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.plugins.appender.settingsSync.Diff;
import com.jetbrains.rider.plugins.appender.settingsSync.RiderBackendSettingsProviderKt;
import com.jetbrains.rider.plugins.appender.settingsSync.SyncedBackendSettings;
import com.jetbrains.rider.settings.ReSharperSettings;
import com.jetbrains.rider.settings.ReSharperSettingsImpl;
import com.jetbrains.rider.settings.sync.MachineDependentBackendSetting;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002'(B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB\t\b\u0016\u00a2\u0006\u0004\b\r\u0010\u000fJ\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\fH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0017H\u0016J\"\u0010#\u001a\u00020\u00022\b\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/plugins/appender/settingsSync/RiderBackendSettingsProvider;", "Lcom/intellij/settingsSync/core/SettingsProvider;", "Lcom/jetbrains/rider/plugins/appender/settingsSync/SyncedBackendSettings;", "Lcom/intellij/openapi/Disposable;", "reSharperSettings", "Lcom/jetbrains/rider/settings/ReSharperSettings;", "getMachineDependentBackendSettings", "Lkotlin/Function0;", "", "Lcom/jetbrains/rider/settings/sync/MachineDependentBackendSetting;", "onSettingChangeListener", "Lkotlin/Function1;", "", "<init>", "(Lcom/jetbrains/rider/settings/ReSharperSettings;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "()V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "dispose", "watcherActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initializeSettingFileWatcher", "id", "", "getId", "()Ljava/lang/String;", "fileName", "getFileName", "collectCurrentSettings", "applyNewSettings", "newSettings", "serialize", "settings", "deserialize", "text", "mergeStates", "base", "older", "newer", "Util", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderBackendSettingsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendSettingsProvider.kt\ncom/jetbrains/rider/plugins/appender/settingsSync/RiderBackendSettingsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n1617#2,9:218\n1869#2:227\n1870#2:229\n1626#2:230\n1617#2,9:243\n1869#2:252\n1870#2:254\n1626#2:255\n1#3:228\n1#3:253\n67#4,4:231\n67#4,4:235\n67#4,4:239\n67#4,4:256\n67#4,4:260\n67#4,4:264\n67#4,4:268\n13#4:272\n*S KotlinDebug\n*F\n+ 1 RiderBackendSettingsProvider.kt\ncom/jetbrains/rider/plugins/appender/settingsSync/RiderBackendSettingsProvider\n*L\n87#1:218,9\n87#1:227\n87#1:229\n87#1:230\n113#1:243,9\n113#1:252\n113#1:254\n113#1:255\n87#1:228\n113#1:253\n101#1:231,4\n107#1:235,4\n111#1:239,4\n115#1:256,4\n138#1:260,4\n154#1:264,4\n165#1:268,4\n41#1:272\n*E\n"})
public final class RiderBackendSettingsProvider
implements SettingsProvider<SyncedBackendSettings>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReSharperSettings reSharperSettings;
    @NotNull
    private final Function0<List<MachineDependentBackendSetting>> getMachineDependentBackendSettings;
    @NotNull
    private final Function1<SyncedBackendSettings, Unit> onSettingChangeListener;
    @NotNull
    private final LifetimeDefinition lifetime;
    @NotNull
    private final AtomicBoolean watcherActive;
    @NotNull
    private final String id;
    @NotNull
    private final String fileName;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String PROVIDER_ID = "riderBackend";

    public RiderBackendSettingsProvider(@NotNull ReSharperSettings reSharperSettings, @NotNull Function0<? extends List<MachineDependentBackendSetting>> getMachineDependentBackendSettings, @NotNull Function1<? super SyncedBackendSettings, Unit> onSettingChangeListener) {
        Intrinsics.checkNotNullParameter((Object)reSharperSettings, (String)"reSharperSettings");
        Intrinsics.checkNotNullParameter(getMachineDependentBackendSettings, (String)"getMachineDependentBackendSettings");
        Intrinsics.checkNotNullParameter(onSettingChangeListener, (String)"onSettingChangeListener");
        this.reSharperSettings = reSharperSettings;
        this.getMachineDependentBackendSettings = getMachineDependentBackendSettings;
        this.onSettingChangeListener = onSettingChangeListener;
        this.lifetime = new LifetimeDefinition();
        this.watcherActive = new AtomicBoolean();
        this.id = PROVIDER_ID;
        this.fileName = "v1.xml";
    }

    public RiderBackendSettingsProvider() {
        this((ReSharperSettings)ReSharperSettingsImpl.INSTANCE, (Function0<? extends List<MachineDependentBackendSetting>>)((Function0)RiderBackendSettingsProvider::_init_$lambda$0), (Function1<? super SyncedBackendSettings, Unit>)((Function1)new Function1<SyncedBackendSettings, Unit>((Object)Util.INSTANCE){

            public final void invoke(SyncedBackendSettings p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((Util)this.receiver).settingChangeHandler(p0);
            }
        }));
    }

    public void dispose() {
        this.lifetime.terminate(true);
    }

    private final void initializeSettingFileWatcher() {
        if (this.watcherActive.compareAndSet(false, true)) {
            logger.info("Activating file watcher on path \"" + this.reSharperSettings.getThisComputerSettingsFilePath() + "\".");
            this.reSharperSettings.listenSettingFileChange((Lifetime)this.lifetime, () -> RiderBackendSettingsProvider.initializeSettingFileWatcher$lambda$0(this));
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SyncedBackendSettings collectCurrentSettings() {
        void $this$mapNotNullTo$iv$iv;
        logger.info("Asked to collect current settings.");
        this.initializeSettingFileWatcher();
        String content = this.reSharperSettings.readThisComputerSettings();
        logger.info("Settings read from \"" + this.reSharperSettings.getThisComputerSettingsFilePath() + "\": " + content.length() + " characters.");
        if (((CharSequence)content).length() == 0) {
            logger.info("No settings, returning null.");
            return null;
        }
        Iterable $this$mapNotNull$iv = (Iterable)this.getMachineDependentBackendSettings.invoke();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MachineDependentBackendSetting it = (MachineDependentBackendSetting)element$iv$iv;
            boolean bl2 = false;
            if (it.getPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List machineDependentSettingPaths = (List)destination$iv$iv;
        logger.info("Removing the machine-dependent settings, " + machineDependentSettingPaths.size() + " items.");
        Document document = ReSharperSettings.Companion.removeSettingsByPaths(content, machineDependentSettingPaths);
        if (document == null) {
            RiderBackendSettingsProvider $this$collectCurrentSettings_u24lambda_u241 = this;
            boolean bl = false;
            logger.warn("Malformed XML encountered during filtering, exiting.");
            return null;
        }
        Document processedDocument = document;
        if (!SequencesKt.any((Sequence)ReSharperSettings.Companion.getSettingEntries(processedDocument))) {
            logger.info("No setting entries after filtering the machine-dependent settings, exiting.");
            return null;
        }
        String processed = ReSharperSettings.Companion.documentToString(processedDocument);
        logger.info("Returning the processed settings, " + processed.length() + " characters.");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Collected settings content:\n" + processed);
        }
        return new SyncedBackendSettings(processed);
    }

    /*
     * WARNING - void declaration
     */
    public void applyNewSettings(@NotNull SyncedBackendSettings newSettings) {
        Document document;
        void $this$mapNotNullTo$iv$iv;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        RiderBackendSettingsProvider.logger.info("Asked to apply the new settings, " + newSettings.getContent().length() + " characters.");
        Logger $this$trace$iv = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("New settings content:\n" + newSettings.getContent());
        }
        String oldContent = this.reSharperSettings.readThisComputerSettings();
        RiderBackendSettingsProvider.logger.info("Old settings read from \"" + this.reSharperSettings.getThisComputerSettingsFilePath() + "\": " + oldContent.length() + " characters.");
        Logger $this$trace$iv2 = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("Old settings content:\n" + oldContent);
        }
        Iterable $this$mapNotNull$iv = (Iterable)this.getMachineDependentBackendSettings.invoke();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MachineDependentBackendSetting it = (MachineDependentBackendSetting)element$iv$iv;
            boolean bl2 = false;
            if (it.getPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List machineDependentSettingPaths = (List)destination$iv$iv;
        RiderBackendSettingsProvider.logger.info("Processing the machine-dependent settings, " + machineDependentSettingPaths.size() + " items.");
        Logger $this$trace$iv3 = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace("Machine-dependent settings' paths: " + CollectionsKt.joinToString$default((Iterable)machineDependentSettingPaths, null, null, null, (int)0, null, null, (int)63, null) + ".");
        }
        if (StringsKt.isBlank((CharSequence)newSettings.getContent())) {
            RiderBackendSettingsProvider.logger.info("Empty settings content received, proceeding with local setting cleanup.");
            document = ReSharperSettings.Companion.emptySettingsDocument();
        } else {
            document = ReSharperSettings.Companion.removeSettingsByPaths(newSettings.getContent(), machineDependentSettingPaths);
            if (document == null) {
                RiderBackendSettingsProvider $this$applyNewSettings_u24lambda_u244 = this;
                boolean bl = false;
                RiderBackendSettingsProvider.logger.warn("Unable to parse remote document during machine-dependent setting removal. Exiting.");
                return;
            }
        }
        Document newSettingsDocument = document;
        RiderBackendSettingsProvider.logger.info("Processed and parsed the new settings document, removed any machine-dependent settings.");
        ReSharperSettings.Companion.addMachineDependentSettings(oldContent, newSettingsDocument, machineDependentSettingPaths);
        RiderBackendSettingsProvider.logger.info("Added local machine-dependent settings to the document.");
        Path settingsLocation = this.reSharperSettings.getThisComputerSettingsFilePath();
        String resultingSettings = ReSharperSettings.Companion.documentToString(newSettingsDocument);
        RiderBackendSettingsProvider.logger.info("Saving the resulting settings to \"" + settingsLocation + "\", " + resultingSettings.length() + " characters.");
        Logger $this$trace$iv4 = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace4 = false;
        if ($this$trace$iv4.isTraceEnabled()) {
            logger = $this$trace$iv4;
            boolean bl = false;
            logger.trace("Resulting settings:\n" + resultingSettings);
        }
        this.reSharperSettings.writeThisComputerSettings(resultingSettings);
        RiderBackendSettingsProvider.logger.info("Saved successfully");
    }

    @NotNull
    public String serialize(@NotNull SyncedBackendSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getContent();
    }

    @NotNull
    public SyncedBackendSettings deserialize(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new SyncedBackendSettings(text);
    }

    @NotNull
    public SyncedBackendSettings mergeStates(@Nullable SyncedBackendSettings base, @NotNull SyncedBackendSettings older, @NotNull SyncedBackendSettings newer) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)older, (String)"older");
        Intrinsics.checkNotNullParameter((Object)newer, (String)"newer");
        Object object = base;
        RiderBackendSettingsProvider.logger.info("Merging settings. Base: " + (object != null && (object = ((SyncedBackendSettings)object).getContent()) != null ? Integer.valueOf(((String)object).length()) : "null") + " characters, older: " + older.getContent().length() + " characters, newer: " + newer.getContent().length() + " characters.");
        Logger $this$trace$iv = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            SyncedBackendSettings syncedBackendSettings = base;
            logger.trace("Base content:\n" + (syncedBackendSettings != null ? syncedBackendSettings.getContent() : null) + "\nOlder content:\n" + older.getContent() + "\nNewer content:\n" + newer.getContent());
        }
        Map baseSettings = RiderBackendSettingsProviderKt.access$getSettingMap(base);
        Map olderSettings = RiderBackendSettingsProviderKt.access$getSettingMap(older);
        Map newerSettings = RiderBackendSettingsProviderKt.access$getSettingMap(newer);
        Diff olderPatch = RiderBackendSettingsProviderKt.access$calculateDiff(baseSettings, olderSettings);
        Diff newerPatch = RiderBackendSettingsProviderKt.access$calculateDiff(baseSettings, newerSettings);
        Map resultSettings = RiderBackendSettingsProviderKt.access$applyPatch(RiderBackendSettingsProviderKt.access$applyPatch(baseSettings, olderPatch), newerPatch);
        SyncedBackendSettings result2 = RiderBackendSettingsProviderKt.access$wrap(resultSettings);
        RiderBackendSettingsProvider.logger.info("Merge result: " + result2.getContent().length() + " characters.");
        Logger $this$trace$iv2 = RiderBackendSettingsProvider.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("Merge result:\n" + result2.getContent());
        }
        return result2;
    }

    private static final List _init_$lambda$0() {
        return MachineDependentBackendSetting.Companion.getSettings().getExtensionList();
    }

    private static final Unit initializeSettingFileWatcher$lambda$0(RiderBackendSettingsProvider this$0) {
        logger.info("Change detected on path \"" + this$0.reSharperSettings.getThisComputerSettingsFilePath() + "\", notifying the sync subsystem.");
        RdCoroutinesUtilKt.launchBackground$default((Lifetime)((Lifetime)this$0.lifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ RiderBackendSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RdCoroutinesUtilKt.withSyncIOBackgroundContext$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.jetbrains.rider.plugins.appender.settingsSync.RiderBackendSettingsProvider ), ()Lcom/jetbrains/rider/plugins/appender/settingsSync/SyncedBackendSettings;)((RiderBackendSettingsProvider)this.this$0), (Continuation)((Continuation)this), (int)1, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (SyncedBackendSettings)v0) == null) {
                            v1 = new SyncedBackendSettings("");
                        }
                        settings = v1;
                        RiderBackendSettingsProvider.access$getOnSettingChangeListener$p(this.this$0).invoke((Object)settings);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final SyncedBackendSettings invokeSuspend$lambda$0(RiderBackendSettingsProvider this$0) {
                return this$0.collectCurrentSettings();
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$getOnSettingChangeListener$p(RiderBackendSettingsProvider $this) {
        return $this.onSettingChangeListener;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderBackendSettingsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderBackendSettingsProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/appender/settingsSync/RiderBackendSettingsProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "PROVIDER_ID", "", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/appender/settingsSync/RiderBackendSettingsProvider$Util;", "", "<init>", "()V", "settingChangeHandler", "", "settings", "Lcom/jetbrains/rider/plugins/appender/settingsSync/SyncedBackendSettings;", "intellij.rider.plugins.appender"})
    private static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final void settingChangeHandler(@NotNull SyncedBackendSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            SyncSettingsEvent.IdeChange change = new SyncSettingsEvent.IdeChange(new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.emptySet(), null, MapsKt.mapOf((Pair)TuplesKt.to((Object)RiderBackendSettingsProvider.PROVIDER_ID, (Object)settings)), SetsKt.emptySet()));
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged((SyncSettingsEvent)change);
        }
    }
}

