/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.qodanaDotnet.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00029:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ!\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0013H\u0082\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J%\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u001fH\u0002J0\u0010%\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\tH\u0002J \u0010)\u001a\u0004\u0018\u00010'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010,\u001a\u00020#H\u0002J\u0018\u0010-\u001a\u0004\u0018\u00010#2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0\u000bH\u0002J&\u0010/\u001a\u00020#2\f\u00100\u001a\b\u0012\u0004\u0012\u00020#0\u000b2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0002J\"\u00104\u001a\u0004\u0018\u00010#2\u0006\u00105\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_LINE_NUMBER", "", "loadCoberturaData", "Lcom/intellij/rt/coverage/data/ProjectData;", "files", "", "Ljava/io/File;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "forEachElement", "", "Lorg/w3c/dom/NodeList;", "block", "Lkotlin/Function1;", "Lorg/w3c/dom/Element;", "secureDocumentBuilderFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "mergeAndSetLines", "classData", "Lcom/intellij/rt/coverage/data/ClassData;", "incoming", "", "Lcom/intellij/rt/coverage/data/LineData;", "(Lcom/intellij/rt/coverage/data/ClassData;[Lcom/intellij/rt/coverage/data/LineData;)V", "parseDocument", "Lorg/w3c/dom/Document;", "file", "extractSourcePaths", "", "", "doc", "processCoverageData", "pathMapping", "Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader$PathMapping;", "projectData", "findValidPathMapping", "sourcePaths", "stripPrefixFromSourcePaths", "sourcePrefix", "findCommonPrefix", "paths", "buildPrefix", "prefixParts", "upToIndex", "linuxAbsolute", "", "resolveFilePath", "filename", "extractCoverageTestData", "Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader$CoverageTestData;", "coberturaCoverageFiles", "PathMapping", "CoverageTestData", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nCoberturaDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoberturaDataLoader.kt\ncom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,376:1\n69#1,5:378\n69#1,3:383\n69#1,3:386\n69#1,5:389\n73#1:394\n73#1:395\n1#2:377\n774#3:396\n865#3,2:397\n1563#3:399\n1634#3,3:400\n216#4:403\n217#4:407\n13870#5,3:404\n13#6:408\n13#7:409\n*S KotlinDebug\n*F\n+ 1 CoberturaDataLoader.kt\ncom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader\n*L\n130#1:378,5\n147#1:383,3\n149#1:386,3\n158#1:389,5\n149#1:394\n147#1:395\n205#1:396\n205#1:397,2\n250#1:399\n250#1:400,3\n357#1:403\n357#1:407\n361#1:404,3\n18#1:408\n18#1:409\n*E\n"})
public final class CoberturaDataLoader {
    @NotNull
    public static final CoberturaDataLoader INSTANCE = new CoberturaDataLoader();
    @NotNull
    private static final Logger logger;
    private static final int MAX_LINE_NUMBER = 1000000;

    private CoberturaDataLoader() {
    }

    @Nullable
    public final ProjectData loadCoberturaData(@NotNull List<? extends File> files, @NotNull VirtualFile projectDir) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        ProjectData projectData = new ProjectData();
        int successfulFiles = 0;
        try {
            for (File file : files) {
                try {
                    logger.info("Processing Cobertura coverage file independently: " + file.getPath());
                    Document doc = this.parseDocument(file);
                    if (doc == null) {
                        logger.error("Failed to parse XML document: " + file.getPath() + ", continuing with remaining files");
                        continue;
                    }
                    Set<String> sourcePaths = this.extractSourcePaths(doc);
                    logger.info("Found " + sourcePaths.size() + " source paths in " + file.getName());
                    PathMapping pathMapping = this.findValidPathMapping(sourcePaths, projectDir);
                    if (pathMapping == null) {
                        logger.warn("No valid path mapping found for Cobertura coverage file: " + file.getName() + ", continuing with remaining files");
                        continue;
                    }
                    logger.info("Path mapping for " + file.getName() + ": " + pathMapping + ".");
                    this.processCoverageData(file, doc, pathMapping, projectDir, projectData);
                    ++successfulFiles;
                }
                catch (Exception e) {
                    logger.error("Failed to process Cobertura coverage file: " + file.getPath() + ", continuing with remaining files", (Throwable)e);
                }
            }
            logger.info("Successfully processed " + successfulFiles + " out of " + files.size() + " Cobertura coverage files");
            logger.info("Loaded Cobertura coverage data with " + projectData.getClassesNumber() + " classes");
            return projectData.getClassesNumber() > 0 ? projectData : null;
        }
        catch (Exception exception) {
            ProjectData projectData2;
            logger.error("Critical error during Cobertura coverage processing", (Throwable)exception);
            if (projectData.getClassesNumber() > 0) {
                logger.warn("Returning partial coverage data due to critical error");
                projectData2 = projectData;
            } else {
                projectData2 = null;
            }
            return projectData2;
        }
    }

    private final void forEachElement(NodeList $this$forEachElement, Function1<? super Element, Unit> block) {
        boolean $i$f$forEachElement = false;
        int n = $this$forEachElement.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = $this$forEachElement.item(i);
            if (!(node instanceof Element)) continue;
            block.invoke((Object)node);
        }
    }

    private final DocumentBuilderFactory secureDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        DocumentBuilderFactory $this$secureDocumentBuilderFactory_u24lambda_u240 = documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        $this$secureDocumentBuilderFactory_u24lambda_u240.setNamespaceAware(true);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setXIncludeAware(false);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setFeature("http://xml.org/sax/features/external-general-entities", false);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        $this$secureDocumentBuilderFactory_u24lambda_u240.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        $this$secureDocumentBuilderFactory_u24lambda_u240.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilderFactory documentBuilderFactory2 = documentBuilderFactory;
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory2, (String)"apply(...)");
        return documentBuilderFactory2;
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeAndSetLines(ClassData classData, LineData[] incoming) {
        Unit unit;
        LineData[] lineDataArray;
        int n;
        Object object;
        Object[] objectArray = classData.getLines();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] existingAny = objectArray;
        Integer n2 = RangesKt.lastOrNull((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])incoming)));
        int maxIdx = n2 != null ? n2 : 0;
        int n3 = existingAny.length;
        for (int i = 0; i < n3; ++i) {
            LineData e;
            object = existingAny[i];
            LineData lineData = object instanceof LineData ? (LineData)object : null;
            if (lineData == null || (e = lineData).getLineNumber() <= maxIdx) continue;
            maxIdx = e.getLineNumber();
        }
        LineData[] merged = new LineData[maxIdx + 1];
        for (Object object2 : existingAny) {
            void it;
            LineData e;
            if ((object2 instanceof LineData ? (LineData)object2 : null) == null) continue;
            e = e;
            object2 = object = new LineData(e.getLineNumber(), null);
            n = e.getLineNumber();
            lineDataArray = merged;
            boolean bl = false;
            it.setHits(e.getHits());
            unit = Unit.INSTANCE;
            lineDataArray[n] = object;
        }
        int n4 = incoming.length;
        for (int i = 0; i < n4; ++i) {
            LineData inc;
            if (incoming[i] == null) continue;
            LineData cur = merged[inc.getLineNumber()];
            if (cur == null) {
                void it;
                Object object2;
                Object bl = object2 = new LineData(inc.getLineNumber(), null);
                n = inc.getLineNumber();
                lineDataArray = merged;
                boolean bl2 = false;
                it.setHits(inc.getHits());
                unit = Unit.INSTANCE;
                lineDataArray[n] = object2;
                continue;
            }
            cur.setHits(Math.max(cur.getHits(), inc.getHits()));
        }
        classData.setLines(merged);
    }

    private final Document parseDocument(File file) {
        Document document;
        try {
            Document it = document = this.secureDocumentBuilderFactory().newDocumentBuilder().parse(file);
            boolean bl = false;
            it.getDocumentElement().normalize();
        }
        catch (Exception e) {
            logger.error("Failed to parse XML document from " + file.getPath(), (Throwable)e);
            document = null;
        }
        return document;
    }

    private final Set<String> extractSourcePaths(Document doc) {
        Set sourcePaths = new LinkedHashSet();
        try {
            NodeList nodeList = doc.getElementsByTagName("source");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
            NodeList sources = nodeList;
            CoberturaDataLoader coberturaDataLoader = this;
            NodeList $this$forEachElement$iv = sources;
            boolean $i$f$forEachElement = false;
            int n = $this$forEachElement$iv.getLength();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                String sourcePath;
                Node node$iv = $this$forEachElement$iv.item(i$iv);
                if (!(node$iv instanceof Element)) continue;
                Element it = (Element)node$iv;
                boolean bl = false;
                String string = it.getTextContent();
                String string2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                if (string2 == null) {
                    string2 = "";
                }
                if (!(((CharSequence)(sourcePath = string2)).length() > 0)) continue;
                sourcePaths.add(StringsKt.replace$default((String)sourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
            logger.debug("Extracted " + sourcePaths.size() + " source paths: " + sourcePaths);
        }
        catch (Exception e) {
            logger.error("Failed to extract source paths from document", (Throwable)e);
        }
        return sourcePaths;
    }

    private final void processCoverageData(File file, Document doc, PathMapping pathMapping, VirtualFile projectDir, ProjectData projectData) {
        try {
            NodeList nodeList = doc.getElementsByTagName("package");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
            NodeList packages = nodeList;
            CoberturaDataLoader coberturaDataLoader = this;
            NodeList $this$forEachElement$iv = packages;
            boolean $i$f$forEachElement = false;
            int n = $this$forEachElement$iv.getLength();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                NodeList classes;
                Node node$iv = $this$forEachElement$iv.item(i$iv);
                if (!(node$iv instanceof Element)) continue;
                Element packageNode = (Element)node$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)packageNode.getElementsByTagName("class"), (String)"getElementsByTagName(...)");
                CoberturaDataLoader coberturaDataLoader2 = INSTANCE;
                NodeList $this$forEachElement$iv2 = classes;
                boolean $i$f$forEachElement2 = false;
                int n2 = $this$forEachElement$iv2.getLength();
                for (int i$iv2 = 0; i$iv2 < n2; ++i$iv2) {
                    Node node$iv2 = $this$forEachElement$iv2.item(i$iv2);
                    if (!(node$iv2 instanceof Element)) continue;
                    Element classNode = (Element)node$iv2;
                    boolean bl2 = false;
                    String string = classNode.getAttribute("filename");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
                    String filename = StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
                    String resolvedPath = INSTANCE.resolveFilePath(filename, pathMapping, projectDir);
                    if (resolvedPath != null) {
                        NodeList lines;
                        ClassData classData = projectData.getOrCreateClassData(UtilsKt.normalizeFilePath((String)resolvedPath));
                        Intrinsics.checkNotNullExpressionValue((Object)classNode.getElementsByTagName("line"), (String)"getElementsByTagName(...)");
                        List lineDataList = new ArrayList();
                        CoberturaDataLoader coberturaDataLoader3 = INSTANCE;
                        NodeList $this$forEachElement$iv3 = lines;
                        boolean $i$f$forEachElement222 = false;
                        int n3 = $this$forEachElement$iv3.getLength();
                        for (int i$iv3 = 0; i$iv3 < n3; ++i$iv3) {
                            Node node$iv3 = $this$forEachElement$iv3.item(i$iv3);
                            if (!(node$iv3 instanceof Element)) continue;
                            Element lineNode = (Element)node$iv3;
                            boolean bl3 = false;
                            String string2 = lineNode.getAttribute("number");
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
                            Integer n4 = StringsKt.toIntOrNull((String)string2);
                            if (n4 == null) {
                                continue;
                            }
                            int lineNumber = n4;
                            String string3 = lineNode.getAttribute("hits");
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(...)");
                            Long l = StringsKt.toLongOrNull((String)string3);
                            int hits = (int)RangesKt.coerceAtMost((long)(l != null ? l : 0L), (long)Integer.MAX_VALUE);
                            LineData lineData = new LineData(lineNumber, null);
                            lineData.setHits(hits);
                            lineDataList.add(lineData);
                        }
                        if (!(!((Collection)lineDataList).isEmpty())) continue;
                        Iterator $i$f$forEachElement222 = ((Iterable)lineDataList).iterator();
                        if (!$i$f$forEachElement222.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        LineData it = (LineData)$i$f$forEachElement222.next();
                        boolean bl4 = false;
                        int n5 = it.getLineNumber();
                        while ($i$f$forEachElement222.hasNext()) {
                            LineData it22 = (LineData)$i$f$forEachElement222.next();
                            $i$a$-maxOf-CoberturaDataLoader$processCoverageData$1$1$maxLineNumber$1 = false;
                            int it22 = it22.getLineNumber();
                            if (n5 >= it22) continue;
                            n5 = it22;
                        }
                        int maxLineNumber = n5;
                        if (maxLineNumber > 1000000) {
                            logger.warn("Suspicious max line number " + maxLineNumber + " in " + file.getName() + ", capping to 1000000");
                        }
                        int cap = Math.min(maxLineNumber, 1000000);
                        LineData[] linesArray = new LineData[cap + 1];
                        for (LineData lineData : lineDataList) {
                            if (lineData.getLineNumber() > cap) continue;
                            linesArray[lineData.getLineNumber()] = lineData;
                        }
                        Intrinsics.checkNotNull((Object)classData);
                        INSTANCE.mergeAndSetLines(classData, linesArray);
                        continue;
                    }
                    logger.debug("Could not resolve path for filename: " + filename + " in " + file.getName());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to process coverage data from document", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PathMapping findValidPathMapping(Set<String> sourcePaths, VirtualFile projectDir) {
        void $this$filterTo$iv$iv;
        if (sourcePaths.isEmpty()) {
            return null;
        }
        String commonPrefix = this.findCommonPrefix(CollectionsKt.toList((Iterable)sourcePaths));
        if (commonPrefix == null) {
            logger.error("No common prefix found in source paths: " + sourcePaths);
            return null;
        }
        logger.info("Most common prefix: '" + commonPrefix + "'");
        char[] cArray = new char[]{'/'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)commonPrefix, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List prefixParts = (List)destination$iv$iv;
        boolean linuxAbsolute = StringsKt.startsWith$default((CharSequence)commonPrefix, (char)'/', (boolean)false, (int)2, null);
        int n = ((Collection)prefixParts).size();
        for (int i = 0; i < n; ++i) {
            String candidate = this.buildPrefix(prefixParts, i, linuxAbsolute);
            logger.debug("Testing candidate: '" + candidate + "'");
            if (i + 1 < prefixParts.size()) {
                VirtualFile candidateFolder = projectDir.findChild((String)prefixParts.get(i + 1));
                if (candidateFolder == null || !candidateFolder.isDirectory()) continue;
                logger.debug("Found candidate folder '" + prefixParts.get(i + 1) + "' in project");
                if (i + 2 < prefixParts.size()) {
                    String remainingPath = CollectionsKt.joinToString$default((Iterable)prefixParts.subList(i + 2, prefixParts.size()), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    VirtualFile subPath = candidateFolder.findFileByRelativePath(remainingPath);
                    if (subPath != null && subPath.isDirectory()) {
                        logger.info("Valid mapping found: '" + candidate + "' -> '" + projectDir.getPath() + "'");
                        return new PathMapping(candidate, this.stripPrefixFromSourcePaths(sourcePaths, candidate));
                    }
                    logger.debug("Candidate folder '" + prefixParts.get(i + 1) + "' doesn't contain remaining path: '" + remainingPath + "'");
                    continue;
                }
                logger.info("Valid mapping found: '" + candidate + "' -> '" + projectDir.getPath() + "'");
                return new PathMapping(candidate, this.stripPrefixFromSourcePaths(sourcePaths, candidate));
            }
            logger.info("Accepting final candidate: '" + candidate + "' -> '" + projectDir.getPath() + "'");
            return new PathMapping(candidate, this.stripPrefixFromSourcePaths(sourcePaths, candidate));
        }
        logger.warn("No valid path mapping found for prefix: '" + commonPrefix + "'");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> stripPrefixFromSourcePaths(Set<String> sourcePaths, String sourcePrefix) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = sourcePaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.substring(sourcePrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            char[] cArray = new char[]{'/'};
            collection.add(StringsKt.trimStart((String)string2, (char[])cArray));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String findCommonPrefix(List<String> paths) {
        int lastBoundary;
        if (paths.isEmpty()) {
            return null;
        }
        if (paths.size() == 1) {
            return paths.get(0);
        }
        Iterator iterator = ((Iterable)paths).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it22 = (String)iterator.next();
        boolean bl = false;
        int it22 = it22.length();
        while (iterator.hasNext()) {
            String it32 = (String)iterator.next();
            $i$a$-minOf-CoberturaDataLoader$findCommonPrefix$minLength$1 = false;
            int it32 = it32.length();
            if (it22 <= it32) continue;
            it22 = it32;
        }
        int minLength = it22;
        int commonLength = 0;
        for (int i = 0; i < minLength; ++i) {
            char currentChar = paths.get(0).charAt(i);
            boolean allMatch = true;
            int n = paths.size();
            for (int j = 1; j < n; ++j) {
                if (paths.get(j).charAt(i) == currentChar) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            ++commonLength;
        }
        String string = paths.get(0).substring(0, commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String commonPrefix = string;
        return commonLength < minLength ? ((lastBoundary = StringsKt.lastIndexOf$default((CharSequence)commonPrefix, (char)'/', (int)0, (boolean)false, (int)6, null)) > 0 ? StringsKt.take((String)commonPrefix, (int)(lastBoundary + 1)) : commonPrefix) : commonPrefix;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String buildPrefix(List<String> prefixParts, int upToIndex, boolean linuxAbsolute) {
        Object object;
        List<String> parts = prefixParts.subList(0, upToIndex + 1);
        if (linuxAbsolute) {
            String string = (String)CollectionsKt.getOrNull(parts, (int)0);
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null) : false)) {
                object = "/" + CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                return object;
            }
        }
        object = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        return object;
    }

    private final String resolveFilePath(String filename, PathMapping pathMapping, VirtualFile projectDir) {
        if (((CharSequence)filename).length() == 0) {
            return null;
        }
        if (StringsKt.startsWith$default((String)filename, (String)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)filename, (CharSequence)":/", (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)filename, (String)pathMapping.getSourcePrefix(), (boolean)false, (int)2, null)) {
                VirtualFile resolvedFile;
                String string = filename.substring(pathMapping.getSourcePrefix().length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                char[] cArray = new char[]{'/'};
                String relativePart = StringsKt.trimStart((String)string, (char[])cArray);
                VirtualFile virtualFile2 = resolvedFile = projectDir.findFileByRelativePath(relativePart);
                return virtualFile2 != null ? virtualFile2.getPath() : null;
            }
            logger.warn("Dropping absolute path that doesn't start with prefix: " + filename);
        } else {
            for (String sourcePath : pathMapping.getSourcePaths()) {
                VirtualFile resolvedFile = projectDir.findFileByRelativePath(sourcePath + "/" + filename);
                if (resolvedFile == null || !resolvedFile.exists()) continue;
                return resolvedFile.getPath();
            }
            logger.warn("Could not resolve path for filename: " + filename);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final CoverageTestData extractCoverageTestData(@NotNull List<? extends File> coberturaCoverageFiles, @NotNull VirtualFile projectDir) {
        Intrinsics.checkNotNullParameter(coberturaCoverageFiles, (String)"coberturaCoverageFiles");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        ProjectData projectData = this.loadCoberturaData(coberturaCoverageFiles, projectDir);
        if (projectData == null) {
            return new CoverageTestData(0, CollectionsKt.emptyList(), MapsKt.emptyMap());
        }
        List classNames = new ArrayList();
        Map lineDataMap = new LinkedHashMap();
        Map map2 = projectData.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String className = (String)entry.getKey();
            ClassData classData = (ClassData)entry.getValue();
            Intrinsics.checkNotNull((Object)className);
            classNames.add(className);
            Map lineMap = new LinkedHashMap();
            if (classData.getLines() != null) {
                Object[] $this$forEachIndexed$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void lineData;
                    int n = index$iv++;
                    Object object = item$iv;
                    int lineNumber = n;
                    boolean bl2 = false;
                    if (lineData == null || lineNumber <= 0) continue;
                    Map map3 = lineMap;
                    Integer n2 = lineNumber;
                    Integer n3 = ((LineData)lineData).getHits();
                    map3.put(n2, n3);
                }
            }
            lineDataMap.put(className, lineMap);
        }
        return new CoverageTestData(projectData.getClassesNumber(), classNames, lineDataMap);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CoberturaDataLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CoberturaDataLoader.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J!\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\bH\u00c6\u0003JE\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader$CoverageTestData;", "", "classCount", "", "classNames", "", "", "lineDataMap", "", "<init>", "(ILjava/util/List;Ljava/util/Map;)V", "getClassCount", "()I", "getClassNames", "()Ljava/util/List;", "getLineDataMap", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rider.plugins.appender"})
    public static final class CoverageTestData {
        private final int classCount;
        @NotNull
        private final List<String> classNames;
        @NotNull
        private final Map<String, Map<Integer, Integer>> lineDataMap;

        public CoverageTestData(int classCount, @NotNull List<String> classNames, @NotNull Map<String, ? extends Map<Integer, Integer>> lineDataMap) {
            Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
            Intrinsics.checkNotNullParameter(lineDataMap, (String)"lineDataMap");
            this.classCount = classCount;
            this.classNames = classNames;
            this.lineDataMap = lineDataMap;
        }

        public final int getClassCount() {
            return this.classCount;
        }

        @NotNull
        public final List<String> getClassNames() {
            return this.classNames;
        }

        @NotNull
        public final Map<String, Map<Integer, Integer>> getLineDataMap() {
            return this.lineDataMap;
        }

        public final int component1() {
            return this.classCount;
        }

        @NotNull
        public final List<String> component2() {
            return this.classNames;
        }

        @NotNull
        public final Map<String, Map<Integer, Integer>> component3() {
            return this.lineDataMap;
        }

        @NotNull
        public final CoverageTestData copy(int classCount, @NotNull List<String> classNames, @NotNull Map<String, ? extends Map<Integer, Integer>> lineDataMap) {
            Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
            Intrinsics.checkNotNullParameter(lineDataMap, (String)"lineDataMap");
            return new CoverageTestData(classCount, classNames, lineDataMap);
        }

        public static /* synthetic */ CoverageTestData copy$default(CoverageTestData coverageTestData, int n, List list, Map map2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = coverageTestData.classCount;
            }
            if ((n2 & 2) != 0) {
                list = coverageTestData.classNames;
            }
            if ((n2 & 4) != 0) {
                map2 = coverageTestData.lineDataMap;
            }
            return coverageTestData.copy(n, list, map2);
        }

        @NotNull
        public String toString() {
            return "CoverageTestData(classCount=" + this.classCount + ", classNames=" + this.classNames + ", lineDataMap=" + this.lineDataMap + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.classCount);
            result2 = result2 * 31 + ((Object)this.classNames).hashCode();
            result2 = result2 * 31 + ((Object)this.lineDataMap).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoverageTestData)) {
                return false;
            }
            CoverageTestData coverageTestData = (CoverageTestData)other;
            if (this.classCount != coverageTestData.classCount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.classNames, coverageTestData.classNames)) {
                return false;
            }
            return Intrinsics.areEqual(this.lineDataMap, coverageTestData.lineDataMap);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/CoberturaDataLoader$PathMapping;", "", "sourcePrefix", "", "sourcePaths", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getSourcePrefix", "()Ljava/lang/String;", "getSourcePaths", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.appender"})
    private static final class PathMapping {
        @NotNull
        private final String sourcePrefix;
        @NotNull
        private final Set<String> sourcePaths;

        public PathMapping(@NotNull String sourcePrefix, @NotNull Set<String> sourcePaths) {
            Intrinsics.checkNotNullParameter((Object)sourcePrefix, (String)"sourcePrefix");
            Intrinsics.checkNotNullParameter(sourcePaths, (String)"sourcePaths");
            this.sourcePrefix = sourcePrefix;
            this.sourcePaths = sourcePaths;
        }

        @NotNull
        public final String getSourcePrefix() {
            return this.sourcePrefix;
        }

        @NotNull
        public final Set<String> getSourcePaths() {
            return this.sourcePaths;
        }

        @NotNull
        public final String component1() {
            return this.sourcePrefix;
        }

        @NotNull
        public final Set<String> component2() {
            return this.sourcePaths;
        }

        @NotNull
        public final PathMapping copy(@NotNull String sourcePrefix, @NotNull Set<String> sourcePaths) {
            Intrinsics.checkNotNullParameter((Object)sourcePrefix, (String)"sourcePrefix");
            Intrinsics.checkNotNullParameter(sourcePaths, (String)"sourcePaths");
            return new PathMapping(sourcePrefix, sourcePaths);
        }

        public static /* synthetic */ PathMapping copy$default(PathMapping pathMapping, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathMapping.sourcePrefix;
            }
            if ((n & 2) != 0) {
                set = pathMapping.sourcePaths;
            }
            return pathMapping.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "PathMapping(sourcePrefix=" + this.sourcePrefix + ", sourcePaths=" + this.sourcePaths + ")";
        }

        public int hashCode() {
            int result2 = this.sourcePrefix.hashCode();
            result2 = result2 * 31 + ((Object)this.sourcePaths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathMapping)) {
                return false;
            }
            PathMapping pathMapping = (PathMapping)other;
            if (!Intrinsics.areEqual((Object)this.sourcePrefix, (Object)pathMapping.sourcePrefix)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourcePaths, pathMapping.sourcePaths);
        }
    }
}

