/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.llmInstaller;

import com.intellij.ide.Prefs;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.BuildNumber;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/appender/llmInstaller/LicenseAiNonCommercialUtil;", "", "<init>", "()V", "isNonCommercialAiLicenseAvailable", "", "()Z", "storeAiNonCommercialTermsAcceptedState", "", "isAccepted", "(Ljava/lang/Boolean;)V", "AI_TERMS_ACCEPTED_PROPERTY_SUFFIX", "", "aiTermsAcceptedKey", "getAiTermsAcceptedKey", "()Ljava/lang/String;", "getPerApplicationKey", "keySuffix", "intellij.rider.plugins.appender.llmInstaller"})
final class LicenseAiNonCommercialUtil {
    @NotNull
    public static final LicenseAiNonCommercialUtil INSTANCE = new LicenseAiNonCommercialUtil();
    @NotNull
    private static final String AI_TERMS_ACCEPTED_PROPERTY_SUFFIX = "NonCommercialLicense.AiTermsAccepted";

    private LicenseAiNonCommercialUtil() {
    }

    public final boolean isNonCommercialAiLicenseAvailable() {
        return Intrinsics.areEqual((Object)"true", (Object)System.getProperty("enable.non.commercial.ai.license"));
    }

    public final void storeAiNonCommercialTermsAcceptedState(@Nullable Boolean isAccepted) {
        if (isAccepted == null) {
            Prefs.remove((String)INSTANCE.getAiTermsAcceptedKey());
            return;
        }
        Prefs.putBoolean((String)INSTANCE.getAiTermsAcceptedKey(), (boolean)isAccepted);
    }

    @NotNull
    public final String getAiTermsAcceptedKey() {
        return this.getPerApplicationKey(AI_TERMS_ACCEPTED_PROPERTY_SUFFIX);
    }

    private final String getPerApplicationKey(String keySuffix) {
        BuildNumber buildNumber = ApplicationInfoImpl.getShadowInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build2 = buildNumber;
        String string = "Jetbrains.%s.%d.%s";
        Object[] objectArray = new Object[]{build2.getProductCode(), build2.getBaselineVersion(), keySuffix};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

