/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.javascript.nodejs;

import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ThreeState;
import com.jetbrains.rider.plugins.appender.javascript.RiderProjectModelWebFilesCollector;
import com.jetbrains.rider.plugins.appender.javascript.nodejs.RiderPackageJsonConfiguratorHandler;
import com.jetbrains.rider.plugins.appender.javascript.nodejs.RiderPackageJsonConfiguratorKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.workspaceModel.WorkspaceUserModelUpdater;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096@\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator;", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "detectPackageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findInDirectory", "file", "Ljava/io/File;", "findInProject", "projectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isEssential", "", "packageJson", "isNpmPackageJson", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderPackageJsonConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1#2:78\n1761#3,3:79\n*S KotlinDebug\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n*L\n65#1:79,3\n*E\n"})
final class RiderPackageJsonConfigurator
implements PackageJsonNotifierConfiguration {
    @NotNull
    private final Project project;

    public RiderPackageJsonConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public Object detectPackageJsonFiles(@NotNull Continuation<? super List<? extends VirtualFile>> $completion) {
        if (this.project.isDefault()) {
            return CollectionsKt.emptyList();
        }
        WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this.project);
        RiderProjectModelWebFilesCollector visitor2 = new RiderProjectModelWebFilesCollector(this.project, store);
        return visitor2.collectAllFiles((Function1<? super File, ? extends VirtualFile>)((Function1)new Function1<File, VirtualFile>((Object)this){

            public final VirtualFile invoke(File p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RiderPackageJsonConfigurator.access$findInDirectory((RiderPackageJsonConfigurator)this.receiver, p0);
            }
        }), (Function1<? super ProjectModelEntity, ? extends VirtualFile>)((Function1)new Function1<ProjectModelEntity, VirtualFile>((Object)this){

            public final VirtualFile invoke(ProjectModelEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RiderPackageJsonConfigurator.access$findInProject((RiderPackageJsonConfigurator)this.receiver, p0);
            }
        }), $completion);
    }

    private final VirtualFile findInDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile directory = virtualFile2;
        while (!directory.is(VFileProperty.SYMLINK)) {
            VirtualFile[] virtualFileArray = directory.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            VirtualFile virtualFile3 = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
            boolean bl = virtualFile3 != null ? virtualFile3.isDirectory() : false;
            if (!bl) break;
            Intrinsics.checkNotNullExpressionValue((Object)directory.getChildren()[0], (String)"get(...)");
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
    }

    private final VirtualFile findInProject(ProjectModelEntity projectEntity) {
        VirtualFile packageJsonInProject;
        boolean bl = ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectEntity);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = false;
            String $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = "Entity should be a project entity";
            throw new AssertionError((Object)$i$a$-assert-RiderPackageJsonConfigurator$findInProject$22);
        }
        VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectEntity);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile directory = virtualFile2;
        VirtualFile virtualFile3 = packageJsonInProject = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
        if (virtualFile3 != null) {
            return virtualFile3;
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory.findChild("ClientApp"));
    }

    public boolean isEssential(@NotNull VirtualFile packageJson) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
            if (this.project.isDefault()) {
                return false;
            }
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (VirtualFile)packageJson, (Project)this.project));
            if (projectModelEntity == null) {
                return false;
            }
            ProjectModelEntity fileNode = projectModelEntity;
            ProjectModelEntity projectNode = ProjectModelEntityExtensionsKt.findParent((ProjectModelEntity)fileNode, RiderPackageJsonConfigurator::isEssential$lambda$0);
            if (projectNode != null && Intrinsics.areEqual((Object)this.findInProject(projectNode), (Object)packageJson)) {
                return true;
            }
            WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this.project);
            Iterable $this$any$iv = (Iterable)store.getExplicitIncludes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)packageJson, (Object)this.findInDirectory(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNpmPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        if (this.project.isDefault()) {
            return false;
        }
        for (RiderPackageJsonConfiguratorHandler handler : RiderPackageJsonConfiguratorKt.access$getEP_NAME$p().getExtensionList((AreaInstance)this.project)) {
            ThreeState isPackageNpmJson = handler.isNpmPackageJson(packageJson);
            if (isPackageNpmJson == ThreeState.UNSURE) continue;
            return isPackageNpmJson.toBoolean();
        }
        return true;
    }

    private static final Boolean isEssential$lambda$0(ProjectModelEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)it);
    }

    public static final /* synthetic */ VirtualFile access$findInDirectory(RiderPackageJsonConfigurator $this, File file) {
        return $this.findInDirectory(file);
    }

    public static final /* synthetic */ VirtualFile access$findInProject(RiderPackageJsonConfigurator $this, ProjectModelEntity projectEntity) {
        return $this.findInProject(projectEntity);
    }
}

