/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.util.text.UniqueNameGenerator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0002\u001a\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"isLocalOrWslDockerServer", "", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "isLocalTcpServer", "getOrCreateLocalOrWslDockerServer", "getLocalOrWslDockerServer", "createDefaultDockerServer", "generateUniqueDockerServerName", "", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerServerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerServerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n295#2,2:70\n295#2,2:72\n295#2,2:74\n*S KotlinDebug\n*F\n+ 1 DockerServerUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerServerUtilsKt\n*L\n44#1:70,2\n45#1:72,2\n46#1:74,2\n*E\n"})
public final class DockerServerUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLocalOrWslDockerServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        ServerConfiguration serverConfiguration = server.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
        if (DockerCloudConfiguration.Companion.hasLocalConnectionConfig((DockerCloudConfiguration)serverConfiguration)) return true;
        ServerConfiguration serverConfiguration2 = server.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration2, (String)"getConfiguration(...)");
        if (DockerCloudConfiguration.Companion.isWsl((DockerCloudConfiguration)serverConfiguration2)) return true;
        if (!DockerServerUtilsKt.isLocalTcpServer(server)) return false;
        return true;
    }

    public static final boolean isLocalTcpServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        if (!Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerTcpConnectionConfigurator")) {
            return false;
        }
        if (StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"unix", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"npipe", (boolean)false, (int)2, null)) {
            return true;
        }
        try {
            URI uri = new URI(((DockerCloudConfiguration)server.getConfiguration()).getApiUrl());
            if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"localhost") || Intrinsics.areEqual((Object)uri.getHost(), (Object)"127.0.0.1")) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return false;
    }

    @NotNull
    public static final RemoteServer<DockerCloudConfiguration> getOrCreateLocalOrWslDockerServer() {
        RemoteServer<DockerCloudConfiguration> existingServer = DockerServerUtilsKt.getLocalOrWslDockerServer();
        if (existingServer != null) {
            return existingServer;
        }
        return DockerServerUtilsKt.createDefaultDockerServer();
    }

    private static final RemoteServer<DockerCloudConfiguration> getLocalOrWslDockerServer() {
        RemoteServer remoteServer;
        Object v1;
        List servers;
        block6: {
            servers = DockerUtils.getDockerServers();
            if (servers.isEmpty()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = servers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RemoteServer it = (RemoteServer)element$iv;
                boolean bl = false;
                ServerConfiguration serverConfiguration = it.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                if (!DockerCloudConfiguration.Companion.hasLocalConnectionConfig((DockerCloudConfiguration)serverConfiguration)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        if ((remoteServer = (RemoteServer)v1) == null) {
            Object v4;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block7: {
                $this$firstOrNull$iv = servers;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RemoteServer it = (RemoteServer)element$iv;
                    boolean bl = false;
                    ServerConfiguration serverConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                    if (!DockerCloudConfiguration.Companion.isWsl((DockerCloudConfiguration)serverConfiguration)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            if ((remoteServer = (RemoteServer)v4) == null) {
                Object v5;
                block8: {
                    $this$firstOrNull$iv = servers;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        RemoteServer it = (RemoteServer)element$iv;
                        boolean bl = false;
                        if (!DockerServerUtilsKt.isLocalTcpServer((RemoteServer<DockerCloudConfiguration>)it)) continue;
                        v5 = element$iv;
                        break block8;
                    }
                    v5 = null;
                }
                remoteServer = v5;
            }
        }
        return remoteServer;
    }

    private static final RemoteServer<DockerCloudConfiguration> createDefaultDockerServer() {
        RemoteServer server = DockerUtils.createDefaultDockerServer(null);
        RemoteServersManager.getInstance().addServer(server);
        return server;
    }

    @NotNull
    public static final String generateUniqueDockerServerName() {
        DockerCloudType type = DockerCloudType.getInstance();
        List list = RemoteServersManager.getInstance().getServers((ServerType)type);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServers(...)");
        Set servers = CollectionsKt.toSet((Iterable)list);
        String string = UniqueNameGenerator.generateUniqueName((String)type.getPresentableName(), arg_0 -> DockerServerUtilsKt.generateUniqueDockerServerName$lambda$1(arg_0 -> DockerServerUtilsKt.generateUniqueDockerServerName$lambda$0(servers, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    private static final boolean generateUniqueDockerServerName$lambda$0(Set $servers, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        for (RemoteServer server : $servers) {
            if (!Intrinsics.areEqual((Object)server.getName(), (Object)s)) continue;
            return false;
        }
        return true;
    }

    private static final boolean generateUniqueDockerServerName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

