/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.plugins.appender.docker.utils.WslUtilsKt;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/utils/ComposeBuildInfo;", "", "context", "", "dockerFile", "arguments", "", "buildTarget", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getContext", "()Ljava/lang/String;", "getArguments", "()Ljava/util/Map;", "getBuildTarget", "getDockerfile", "Ljava/nio/file/Path;", "composeFilePath", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.appender"})
public final class ComposeBuildInfo {
    @NotNull
    private final String context;
    @Nullable
    private final String dockerFile;
    @NotNull
    private final Map<String, String> arguments;
    @Nullable
    private final String buildTarget;

    public ComposeBuildInfo(@NotNull String context, @Nullable String dockerFile, @NotNull Map<String, String> arguments, @Nullable String buildTarget) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.context = context;
        this.dockerFile = dockerFile;
        this.arguments = arguments;
        this.buildTarget = buildTarget;
    }

    @NotNull
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final Map<String, String> getArguments() {
        return this.arguments;
    }

    @Nullable
    public final String getBuildTarget() {
        return this.buildTarget;
    }

    @Nullable
    public final Path getDockerfile(@NotNull Path composeFilePath) {
        Path dockerfilePath;
        Intrinsics.checkNotNullParameter((Object)composeFilePath, (String)"composeFilePath");
        String string = this.dockerFile;
        if (string == null) {
            string = "Dockerfile";
        }
        if ((dockerfilePath = Path.of(string, new String[0])).isAbsolute()) {
            return dockerfilePath;
        }
        if (SystemInfo.isWindows && dockerfilePath.startsWith("/mnt/")) {
            Intrinsics.checkNotNull((Object)dockerfilePath);
            return WslUtilsKt.convertToWindowsPath(dockerfilePath);
        }
        Path dockerfileWithContextPath = Path.of(this.context, new String[0]).resolve(dockerfilePath);
        if (dockerfileWithContextPath.isAbsolute()) {
            return dockerfileWithContextPath;
        }
        if (SystemInfo.isWindows && dockerfileWithContextPath.startsWith("/mnt/")) {
            Intrinsics.checkNotNull((Object)dockerfileWithContextPath);
            return WslUtilsKt.convertToWindowsPath(dockerfileWithContextPath);
        }
        return composeFilePath.resolve(dockerfileWithContextPath);
    }

    @NotNull
    public final String component1() {
        return this.context;
    }

    private final String component2() {
        return this.dockerFile;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.arguments;
    }

    @Nullable
    public final String component4() {
        return this.buildTarget;
    }

    @NotNull
    public final ComposeBuildInfo copy(@NotNull String context, @Nullable String dockerFile, @NotNull Map<String, String> arguments, @Nullable String buildTarget) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return new ComposeBuildInfo(context, dockerFile, arguments, buildTarget);
    }

    public static /* synthetic */ ComposeBuildInfo copy$default(ComposeBuildInfo composeBuildInfo, String string, String string2, Map map2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = composeBuildInfo.context;
        }
        if ((n & 2) != 0) {
            string2 = composeBuildInfo.dockerFile;
        }
        if ((n & 4) != 0) {
            map2 = composeBuildInfo.arguments;
        }
        if ((n & 8) != 0) {
            string3 = composeBuildInfo.buildTarget;
        }
        return composeBuildInfo.copy(string, string2, map2, string3);
    }

    @NotNull
    public String toString() {
        return "ComposeBuildInfo(context=" + this.context + ", dockerFile=" + this.dockerFile + ", arguments=" + this.arguments + ", buildTarget=" + this.buildTarget + ")";
    }

    public int hashCode() {
        int result2 = this.context.hashCode();
        result2 = result2 * 31 + (this.dockerFile == null ? 0 : this.dockerFile.hashCode());
        result2 = result2 * 31 + ((Object)this.arguments).hashCode();
        result2 = result2 * 31 + (this.buildTarget == null ? 0 : this.buildTarget.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComposeBuildInfo)) {
            return false;
        }
        ComposeBuildInfo composeBuildInfo = (ComposeBuildInfo)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)composeBuildInfo.context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dockerFile, (Object)composeBuildInfo.dockerFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.arguments, composeBuildInfo.arguments)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildTarget, (Object)composeBuildInfo.buildTarget);
    }
}

