/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.deployment;

import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.deployment.RiderDockerDeploymentModel;
import com.jetbrains.rider.plugins.appender.docker.image.RiderDockerImageProperties;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerExecutableUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0019\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u001c\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentFromImageModel;", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentModel;", "imageProperties", "Lcom/jetbrains/rider/plugins/appender/docker/image/RiderDockerImageProperties;", "configEntrypoint", "", "", "configCmd", "configWorkingDir", "configUser", "configEnvVars", "", "configContainerPorts", "", "", "configExposedPorts", "configContainerVolumes", "<init>", "(Lcom/jetbrains/rider/plugins/appender/docker/image/RiderDockerImageProperties;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "[Ljava/lang/String;", "getCpuKind", "Lcom/jetbrains/rider/CPUKind;", "stage", "getContainerOs", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerContainerType;", "getImageProperties", "isRootless", "", "getWorkingDir", "getEnvironmentVariables", "getContainerPorts", "getContainerVolumes", "getExecutionCommand", "", "intellij.rider.plugins.appender"})
public final class RiderDockerDeploymentFromImageModel
implements RiderDockerDeploymentModel {
    @NotNull
    private final RiderDockerImageProperties imageProperties;
    @Nullable
    private final String[] configEntrypoint;
    @Nullable
    private final String[] configCmd;
    @Nullable
    private final String configWorkingDir;
    @Nullable
    private final String configUser;
    @NotNull
    private final Map<String, String> configEnvVars;
    @NotNull
    private final Set<Integer> configContainerPorts;
    @NotNull
    private final Set<Integer> configExposedPorts;
    @NotNull
    private final Set<String> configContainerVolumes;

    public RiderDockerDeploymentFromImageModel(@NotNull RiderDockerImageProperties imageProperties, @Nullable String[] configEntrypoint, @Nullable String[] configCmd, @Nullable String configWorkingDir, @Nullable String configUser, @NotNull Map<String, String> configEnvVars, @NotNull Set<Integer> configContainerPorts, @NotNull Set<Integer> configExposedPorts, @NotNull Set<String> configContainerVolumes) {
        Intrinsics.checkNotNullParameter((Object)imageProperties, (String)"imageProperties");
        Intrinsics.checkNotNullParameter(configEnvVars, (String)"configEnvVars");
        Intrinsics.checkNotNullParameter(configContainerPorts, (String)"configContainerPorts");
        Intrinsics.checkNotNullParameter(configExposedPorts, (String)"configExposedPorts");
        Intrinsics.checkNotNullParameter(configContainerVolumes, (String)"configContainerVolumes");
        this.imageProperties = imageProperties;
        this.configEntrypoint = configEntrypoint;
        this.configCmd = configCmd;
        this.configWorkingDir = configWorkingDir;
        this.configUser = configUser;
        this.configEnvVars = configEnvVars;
        this.configContainerPorts = configContainerPorts;
        this.configExposedPorts = configExposedPorts;
        this.configContainerVolumes = configContainerVolumes;
    }

    @Override
    @NotNull
    public CPUKind getCpuKind(@Nullable String stage) {
        return this.imageProperties.getCpuKind();
    }

    @Override
    @NotNull
    public DockerContainerType getContainerOs(@Nullable String stage) {
        return this.imageProperties.getOs();
    }

    @Override
    @NotNull
    public RiderDockerImageProperties getImageProperties(@Nullable String stage) {
        return this.imageProperties;
    }

    @Override
    public boolean isRootless(@Nullable String stage) {
        if (this.configUser != null) {
            return !StringsKt.equals((String)this.configUser, (String)"root", (boolean)true);
        }
        return this.imageProperties.getUser() != null && !StringsKt.equals((String)this.imageProperties.getUser(), (String)"root", (boolean)true);
    }

    @Override
    @NotNull
    public String getWorkingDir(@Nullable String stage) {
        if (this.configWorkingDir != null) {
            return this.configWorkingDir;
        }
        String imageWorkingDir = this.imageProperties.getWorkDir();
        if (imageWorkingDir != null) {
            return imageWorkingDir;
        }
        return this.imageProperties.getOs() == DockerContainerType.Windows ? "c:/" : "/";
    }

    @Override
    @NotNull
    public Map<String, String> getEnvironmentVariables(@Nullable String stage) {
        return MapsKt.plus(this.imageProperties.getEnvs(), this.configEnvVars);
    }

    @Override
    @NotNull
    public Set<Integer> getContainerPorts(@Nullable String stage) {
        Set set;
        Set $this$getContainerPorts_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getContainerPorts_u24lambda_u240.addAll((Collection)this.configContainerPorts);
        $this$getContainerPorts_u24lambda_u240.addAll((Collection)this.configExposedPorts);
        return SetsKt.build((Set)set);
    }

    @Override
    @NotNull
    public Set<String> getContainerVolumes(@Nullable String stage) {
        return this.configContainerVolumes;
    }

    @Override
    @NotNull
    public List<String> getExecutionCommand(@Nullable String stage) {
        List list;
        if (this.configEntrypoint != null) {
            List list2;
            List $this$getExecutionCommand_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u240, (Object[])this.configEntrypoint);
            if (this.configCmd != null) {
                CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u240, (Object[])this.configCmd);
            }
            return CollectionsKt.build((List)list2);
        }
        List<String> imageEntrypoint = this.imageProperties.getStringEntrypoint();
        if (imageEntrypoint != null && DockerExecutableUtilsKt.isInstructionInShellForm(imageEntrypoint, this.imageProperties.getOs())) {
            return imageEntrypoint;
        }
        if (this.configCmd != null) {
            List $this$getExecutionCommand_u24lambda_u240;
            List $this$getExecutionCommand_u24lambda_u241 = $this$getExecutionCommand_u24lambda_u240 = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (imageEntrypoint != null) {
                $this$getExecutionCommand_u24lambda_u241.addAll((Collection)imageEntrypoint);
            }
            CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u241, (Object[])this.configCmd);
            return CollectionsKt.build((List)$this$getExecutionCommand_u24lambda_u240);
        }
        List<String> imageCmd = this.imageProperties.getStringCmd();
        List $this$getExecutionCommand_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (imageEntrypoint != null) {
            $this$getExecutionCommand_u24lambda_u242.addAll((Collection)imageEntrypoint);
        }
        if (imageCmd != null) {
            $this$getExecutionCommand_u24lambda_u242.addAll((Collection)imageCmd);
        }
        return CollectionsKt.build((List)list);
    }
}

