/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.deployment;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationBuilder;
import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBuilder;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeBuildV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2Builder;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.docker.deployment.ServicePatchedParameters;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JH\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010\u001d\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer;", "", "<init>", "()V", "overrideFileHashes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getOverrideFile", "Ljava/nio/file/Path;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "composeFiles", "", "patchedServices", "Lkotlin/Pair;", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/ServicePatchedParameters;", "dockerCloudConfiguration", "Lcom/intellij/docker/DockerCloudConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "getOverrideFilePath", "sourceFilePath", "createNewOverrideFile", "", "overrideFilePath", "writeToOverrideFile", "configuration", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "addServiceConfiguration", "builder", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfigurationBuilder;", "serviceName", "patchedParams", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nComposeOverrideFileProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeOverrideFileProducer.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n67#2,4:138\n67#2,4:142\n67#2,4:146\n67#2,4:150\n13#2:161\n37#3,2:154\n37#3,2:157\n37#3,2:159\n1#4:156\n*S KotlinDebug\n*F\n+ 1 ComposeOverrideFileProducer.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer\n*L\n62#1:138,4\n74#1:142,4\n77#1:146,4\n88#1:150,4\n36#1:161\n125#1:154,2\n134#1:157,2\n135#1:159,2\n*E\n"})
public final class ComposeOverrideFileProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Integer> overrideFileHashes = new ConcurrentHashMap();
    @NotNull
    private static final String COMPOSE_GENERATED_OVERRIDE_SUFFIX = ".generated.override.yml";
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final Path getOverrideFile(@NotNull DockerRunConfig.Wrapper dockerRunConfig, @NotNull List<? extends Path> composeFiles, @NotNull List<Pair<String, ServicePatchedParameters>> patchedServices, @NotNull DockerCloudConfiguration dockerCloudConfiguration, @NotNull Project project) {
        Path overrideFilePath;
        block7: {
            int currentHash;
            block6: {
                Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
                Intrinsics.checkNotNullParameter(composeFiles, (String)"composeFiles");
                Intrinsics.checkNotNullParameter(patchedServices, (String)"patchedServices");
                Intrinsics.checkNotNullParameter((Object)dockerCloudConfiguration, (String)"dockerCloudConfiguration");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                LOG.trace("Preparing compose override file");
                if (patchedServices.isEmpty()) {
                    return null;
                }
                String sourceFilePath = dockerRunConfig.getDeploymentConfiguration().getSourceFilePath();
                if (sourceFilePath == null) {
                    LOG.warn("Source file path is null");
                    return null;
                }
                currentHash = ((Object)patchedServices).hashCode();
                overrideFilePath = this.getOverrideFilePath(sourceFilePath, project);
                Integer overrideFileHash = this.overrideFileHashes.get(((Object)overrideFilePath.toAbsolutePath()).toString());
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Compose override file hash for the file path " + overrideFilePath + " is: " + overrideFileHash);
                }
                if (overrideFileHash == null || currentHash != overrideFileHash) break block6;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(overrideFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            }
            ((Map)this.overrideFileHashes).put(((Object)overrideFilePath.toAbsolutePath()).toString(), currentHash);
            this.createNewOverrideFile(overrideFilePath, dockerRunConfig, dockerCloudConfiguration, composeFiles, patchedServices);
        }
        return overrideFilePath;
    }

    private final Path getOverrideFilePath(String sourceFilePath, Project project) {
        Logger logger;
        Path path = Paths.get(sourceFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String sourceFileName = PathsKt.getNameWithoutExtension((Path)path);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Source file name: " + sourceFileName);
        }
        Path folder = SolutionHostExtensionsKt.getSolutionDirectoryPath((Project)project).resolve(".idea").resolve(".idea." + SolutionHostExtensionsKt.getSolutionName((Project)project)).resolve("Docker");
        Path overrideFilePath = folder.resolve(sourceFileName + COMPOSE_GENERATED_OVERRIDE_SUFFIX);
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)overrideFilePath);
            logger.trace("Compose override file path: " + ((Object)overrideFilePath).toString());
        }
        Intrinsics.checkNotNull((Object)overrideFilePath);
        return overrideFilePath;
    }

    private final void createNewOverrideFile(Path overrideFilePath, DockerRunConfig.Wrapper dockerRunConfig, DockerCloudConfiguration dockerCloudConfiguration, List<? extends Path> composeFiles, List<Pair<String, ServicePatchedParameters>> patchedServices) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Creating new override file for the run configuration " + dockerRunConfig.getSettings().getName());
        }
        DockerComposeConfigurationBuilder dockerComposeConfigurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(composeFiles, (Collection)CollectionsKt.emptyList(), (DockerCloudConfiguration)dockerCloudConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeConfigurationBuilder, (String)"createConfigurationBuilder(...)");
        DockerComposeConfigurationBuilder builder = dockerComposeConfigurationBuilder;
        for (Pair<String, ServicePatchedParameters> patchedService : patchedServices) {
            this.addServiceConfiguration(builder, (String)patchedService.getFirst(), (ServicePatchedParameters)patchedService.getSecond());
        }
        DockerComposeConfiguration dockerComposeConfiguration = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeConfiguration, (String)"build(...)");
        this.writeToOverrideFile(overrideFilePath, dockerComposeConfiguration);
    }

    private final void writeToOverrideFile(Path overrideFilePath, DockerComposeConfiguration configuration) {
        StringWriter writer = new StringWriter();
        writer.write("# " + DockerBundle.message((String)"GeneratedComposeFile.header", (Object[])new Object[0]) + System.lineSeparator());
        DockerComposeConfigurationSerializer.newInstance().serialize((Writer)writer, configuration);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String content = string;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(overrideFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(overrideFilePath.getParent(), new FileAttribute[0]);
            Files.createFile(overrideFilePath, new FileAttribute[0]);
        }
        PathsKt.writeText$default((Path)overrideFilePath, (CharSequence)content, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void addServiceConfiguration(DockerComposeConfigurationBuilder<?, ?, ?> builder, String serviceName, ServicePatchedParameters patchedParams) {
        String[] stringArray;
        Collection thisCollection$iv;
        boolean $i$f$toTypedArray;
        Collection $this$toTypedArray$iv;
        Collection $this$toTypedArray$iv2 = patchedParams.getVolumeBindings();
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        DockerComposeServiceBuilder dockerComposeServiceBuilder = builder.addService(serviceName).withPorts(patchedParams.getPortBindings()).withBindVolumes((DockerVolumeBinding[])thisCollection$iv2.toArray(new DockerVolumeBindingImpl[0])).withEnvironment(patchedParams.getEnvironmentVariables());
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceBuilder, (String)"withEnvironment(...)");
        DockerComposeServiceBuilder serviceBuilder = dockerComposeServiceBuilder;
        if (serviceBuilder instanceof DockerComposeServiceV2Builder) {
            String string = patchedParams.getImageName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                DockerComposeServiceV2Builder cfr_ignored_0 = (DockerComposeServiceV2Builder)((DockerComposeServiceV2Builder)serviceBuilder).withImage(it);
            }
            DockerComposeBuildV2 dockerComposeBuildV2 = patchedParams.getBuild();
            if (dockerComposeBuildV2 != null) {
                DockerComposeBuildV2 it = dockerComposeBuildV2;
                boolean bl = false;
                ((DockerComposeServiceV2Builder)serviceBuilder).withBuild(it);
            }
        }
        String string = patchedParams.getWorkingDir();
        if (string != null) {
            String it = string;
            boolean bl = false;
            DockerComposeServiceBuilder dockerComposeServiceBuilder2 = serviceBuilder.withWorkingDir(it);
            v5 = dockerComposeServiceBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceBuilder2, (String)"withWorkingDir(...)");
        } else {
            v5 = null;
        }
        List<String> list = patchedParams.getCmd();
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            $this$toTypedArray$iv = it;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            DockerComposeServiceBuilder dockerComposeServiceBuilder3 = serviceBuilder.withCommand(Arrays.copyOf(stringArray, stringArray.length));
            v8 = dockerComposeServiceBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceBuilder3, (String)"withCommand(...)");
        } else {
            v8 = null;
        }
        List<String> list2 = patchedParams.getEntrypoint();
        if (list2 != null) {
            List<String> it = list2;
            boolean bl = false;
            $this$toTypedArray$iv = it;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            DockerComposeServiceBuilder dockerComposeServiceBuilder4 = serviceBuilder.withEntrypoint(Arrays.copyOf(stringArray, stringArray.length));
            v11 = dockerComposeServiceBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceBuilder4, (String)"withEntrypoint(...)");
        } else {
            v11 = null;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComposeOverrideFileProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer$Companion;", "", "<init>", "()V", "COMPOSE_GENERATED_OVERRIDE_SUFFIX", "", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nComposeOverrideFileProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeOverrideFileProducer.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,137:1\n42#2,3:138\n*S KotlinDebug\n*F\n+ 1 ComposeOverrideFileProducer.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/ComposeOverrideFileProducer$Companion\n*L\n35#1:138,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComposeOverrideFileProducer getInstance() {
            boolean $i$f$service = false;
            Class<ComposeOverrideFileProducer> serviceClass$iv = ComposeOverrideFileProducer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ComposeOverrideFileProducer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

