/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.debug.providers;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.model.DotNetFrameworkType;
import com.jetbrains.rider.model.RdProjectDebugModePropertiesResponse;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DotNetClrExeStartInfo;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.RiderDockerDebugProvider;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.RiderDockerDebugTargetType;
import com.jetbrains.rider.plugins.appender.docker.deployment.RiderDockerDeploymentModel;
import com.jetbrains.rider.plugins.appender.docker.image.ImageDotNetProperties;
import com.jetbrains.rider.plugins.appender.docker.image.RiderDockerImageProperties;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerExecutableUtilsKt;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J2\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetFrameworkDockerDebugProvider;", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugProvider;", "<init>", "()V", "priority", "", "getPriority", "()I", "debuggerKey", "", "getDebuggerKey", "()Ljava/lang/String;", "debuggerTargetType", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugTargetType;", "getDebuggerTargetType", "()Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugTargetType;", "isApplicable", "", "deploymentModel", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentModel;", "projectProperties", "Lcom/jetbrains/rider/model/RdProjectDebugModePropertiesResponse;", "getDebuggerStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "executionCommand", "", "workingDir", "dotnetVersion", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDotNetFrameworkDockerDebugProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetFrameworkDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetFrameworkDockerDebugProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n67#2,4:73\n67#2,4:84\n13#2:88\n360#3,7:77\n*S KotlinDebug\n*F\n+ 1 DotNetFrameworkDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetFrameworkDockerDebugProvider\n*L\n45#1:73,4\n60#1:84,4\n17#1:88\n47#1:77,7\n*E\n"})
public final class DotNetFrameworkDockerDebugProvider
implements RiderDockerDebugProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int priority;
    @NotNull
    private final String debuggerKey;
    @NotNull
    private final RiderDockerDebugTargetType debuggerTargetType = RiderDockerDebugTargetType.FULL_FRAMEWORK;
    @NotNull
    private static final Logger LOG;

    public DotNetFrameworkDockerDebugProvider() {
        this.priority = 1;
        this.debuggerKey = "netframework";
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public String getDebuggerKey() {
        return this.debuggerKey;
    }

    @Override
    @NotNull
    public RiderDockerDebugTargetType getDebuggerTargetType() {
        return this.debuggerTargetType;
    }

    @Override
    public boolean isApplicable(@NotNull RiderDockerDeploymentModel deploymentModel, @Nullable RdProjectDebugModePropertiesResponse projectProperties2) {
        Intrinsics.checkNotNullParameter((Object)deploymentModel, (String)"deploymentModel");
        if (RiderDockerDeploymentModel.getContainerOs$default(deploymentModel, null, 1, null) != DockerContainerType.Windows) {
            return false;
        }
        if (projectProperties2 != null && projectProperties2.getDotnetAssemblyDetails().getDotNetFrameworkType() == DotNetFrameworkType.FullFramework) {
            return true;
        }
        RiderDockerImageProperties imageProperties = RiderDockerDeploymentModel.getImageProperties$default(deploymentModel, null, 1, null);
        Object object = imageProperties;
        boolean bl = object != null && (object = ((RiderDockerImageProperties)object).getDotnetProperties()) != null ? ((ImageDotNetProperties)object).getHasDotNetFramework() : false;
        if (bl) {
            return true;
        }
        Path path = DockerExecutableUtilsKt.getPossibleExecutable(deploymentModel);
        if (path == null) {
            return false;
        }
        Path executable = path;
        return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)executable), (Object)"exe");
    }

    @Override
    @Nullable
    public DebuggerStartInfoBase getDebuggerStartInfo(@NotNull List<String> executionCommand, @NotNull String workingDir, @Nullable String dotnetVersion2, @NotNull ExecutionEnvironment environment) {
        int exeIndex;
        Logger logger;
        block6: {
            int n;
            Intrinsics.checkNotNullParameter(executionCommand, (String)"executionCommand");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Getting appropriate debugger start info for a command: " + CollectionsKt.joinToString$default((Iterable)executionCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            List<String> $this$indexOfFirst$iv = executionCommand;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv;
                String it = item$iv = iterator.next();
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)".exe", (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = exeIndex = -1;
        }
        if (exeIndex == -1) {
            LOG.warn("Unable to find any executable from the execution command");
            return null;
        }
        Object pathToRun = null;
        pathToRun = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)executionCommand, (int)(exeIndex + 1)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (!StringsKt.startsWith$default((String)pathToRun, (String)workingDir, (boolean)false, (int)2, null)) {
            pathToRun = workingDir + "\\" + pathToRun;
        }
        String arguments = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)executionCommand, (int)(exeIndex + 1)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Found executable: " + pathToRun + "; arguments: " + arguments + "; working directory: " + workingDir);
        }
        return (DebuggerStartInfoBase)new DotNetClrExeStartInfo((String)pathToRun, workingDir, arguments, CollectionsKt.emptyList(), null, true, false);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DotNetFrameworkDockerDebugProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetFrameworkDockerDebugProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

