/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.debug.providers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import com.jetbrains.rider.model.DotNetFrameworkType;
import com.jetbrains.rider.model.RdProjectDebugModePropertiesResponse;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.model.RdVersionInfo;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DotNetCoreExeStartInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetCoreInfo;
import com.jetbrains.rider.model.debuggerWorker.EncInfo;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.RiderDockerDebugProvider;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.RiderDockerDebugTargetType;
import com.jetbrains.rider.plugins.appender.docker.deployment.RiderDockerDeploymentModel;
import com.jetbrains.rider.plugins.appender.docker.image.ImageDotNetProperties;
import com.jetbrains.rider.plugins.appender.docker.image.RiderDockerImageProperties;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerExecutableUtilsKt;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J2\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider;", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugProvider;", "<init>", "()V", "priority", "", "getPriority", "()I", "debuggerKey", "", "getDebuggerKey", "()Ljava/lang/String;", "debuggerTargetType", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugTargetType;", "getDebuggerTargetType", "()Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugTargetType;", "isApplicable", "", "deploymentModel", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentModel;", "projectProperties", "Lcom/jetbrains/rider/model/RdProjectDebugModePropertiesResponse;", "getDebuggerStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "executionCommand", "", "workingDir", "dotnetVersion", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getTargetFrameworkId", "Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDotNetCoreDockerDebugProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetCoreDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n67#2,4:150\n67#2,4:164\n13#2:168\n774#3:154\n865#3,2:155\n360#3,7:157\n*S KotlinDebug\n*F\n+ 1 DotNetCoreDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider\n*L\n64#1:150,4\n123#1:164,4\n28#1:168\n77#1:154\n77#1:155,2\n87#1:157,7\n*E\n"})
public final class DotNetCoreDockerDebugProvider
implements RiderDockerDebugProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int priority;
    @NotNull
    private final String debuggerKey;
    @NotNull
    private final RiderDockerDebugTargetType debuggerTargetType = RiderDockerDebugTargetType.NET_CORE;
    @NotNull
    private static final Logger LOG;

    public DotNetCoreDockerDebugProvider() {
        this.debuggerKey = "netcore";
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public String getDebuggerKey() {
        return this.debuggerKey;
    }

    @Override
    @NotNull
    public RiderDockerDebugTargetType getDebuggerTargetType() {
        return this.debuggerTargetType;
    }

    @Override
    public boolean isApplicable(@NotNull RiderDockerDeploymentModel deploymentModel, @Nullable RdProjectDebugModePropertiesResponse projectProperties2) {
        Intrinsics.checkNotNullParameter((Object)deploymentModel, (String)"deploymentModel");
        if (projectProperties2 != null && projectProperties2.getDotnetAssemblyDetails().getDotNetFrameworkType() == DotNetFrameworkType.CoreClr) {
            return true;
        }
        RiderDockerImageProperties imageProperties = RiderDockerDeploymentModel.getImageProperties$default(deploymentModel, null, 1, null);
        Object object = imageProperties;
        boolean bl = object != null && (object = ((RiderDockerImageProperties)object).getDotnetProperties()) != null ? ((ImageDotNetProperties)object).getHasDotNet() : false;
        if (bl) {
            return true;
        }
        Path path = DockerExecutableUtilsKt.getPossibleExecutable(deploymentModel);
        if (path == null) {
            return false;
        }
        Path executable = path;
        if (DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables().contains(PathsKt.getNameWithoutExtension((Path)executable))) {
            return true;
        }
        RiderDockerImageProperties riderDockerImageProperties = imageProperties;
        if ((riderDockerImageProperties != null ? riderDockerImageProperties.getOs() : null) == DockerContainerType.Windows) {
            return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)executable), (Object)"exe");
        }
        RiderDockerImageProperties riderDockerImageProperties2 = imageProperties;
        if ((riderDockerImageProperties2 != null ? riderDockerImageProperties2.getOs() : null) == DockerContainerType.Linux) {
            return ((CharSequence)PathsKt.getExtension((Path)executable)).length() == 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DebuggerStartInfoBase getDebuggerStartInfo(@NotNull List<String> executionCommand, @NotNull String workingDir, @Nullable String dotnetVersion2, @NotNull ExecutionEnvironment environment) {
        EncInfo encInfo;
        boolean bl;
        Logger logger;
        Intrinsics.checkNotNullParameter(executionCommand, (String)"executionCommand");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Getting appropriate debugger start info for a command: " + CollectionsKt.joinToString$default((Iterable)executionCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        String executable = (String)CollectionsKt.first(executionCommand);
        List commandTail = CollectionsKt.drop((Iterable)executionCommand, (int)1);
        String targetExe = null;
        String targetArguments = null;
        String runtimeArguments = null;
        boolean executeAsIs = false;
        if (DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables().contains(executable)) {
            int indexOfExecutable;
            Object[] $this$indexOfFirst$iv;
            Object[] arguments;
            block15: {
                int n;
                void $this$filterTo$iv$iv;
                executeAsIs = false;
                Iterable $this$filter$iv = commandTail;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl3 = false;
                    boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                arguments = (Object[])destination$iv$iv;
                if (arguments.isEmpty()) {
                    ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(RiderDockerBundle.Companion.message("rider.docker.container.entrypoint.error", new Object[0])));
                    return null;
                }
                $this$indexOfFirst$iv = arguments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object e : $this$indexOfFirst$iv) {
                    String it = (String)e;
                    boolean bl5 = false;
                    if (StringsKt.endsWith((String)it, (String)".dll", (boolean)true) || StringsKt.endsWith((String)it, (String)".exe", (boolean)true)) {
                        n = index$iv;
                        break block15;
                    }
                    ++index$iv;
                }
                n = indexOfExecutable = -1;
            }
            if (indexOfExecutable < 0) {
                $this$indexOfFirst$iv = new Object[]{CollectionsKt.joinToString$default((Iterable)executionCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(RiderDockerBundle.Companion.message("rider.docker.can.not.find.target.executable", $this$indexOfFirst$iv)));
                return null;
            }
            targetExe = (String)arguments.get(indexOfExecutable);
            targetArguments = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)(indexOfExecutable + 1), (int)arguments.size())), (CharSequence)" ", null, null, (int)0, null, arg_0 -> DotNetCoreDockerDebugProvider.getDebuggerStartInfo$lambda$3((List)arguments, arg_0), (int)30, null);
            runtimeArguments = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)indexOfExecutable)), (CharSequence)" ", null, null, (int)0, null, arg_0 -> DotNetCoreDockerDebugProvider.getDebuggerStartInfo$lambda$4((List)arguments, arg_0), (int)30, null);
        } else {
            String string;
            executeAsIs = true;
            Path path = Paths.get(executable, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path targetExePath = path;
            if (targetExePath.isAbsolute()) {
                string = NioPathUtil.toCanonicalPath((Path)targetExePath);
            } else {
                Path path2 = Paths.get(workingDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                Path workingDirPath = path2;
                Path path3 = workingDirPath.resolve(executable);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                string = NioPathUtil.toCanonicalPath((Path)path3);
            }
            targetExe = string;
            runtimeArguments = null;
            targetArguments = CollectionsKt.joinToString$default((Iterable)commandTail, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
        String string = dotnetVersion2;
        if (string != null) {
            String it = string;
            bl = false;
            RdTargetFrameworkId rdTargetFrameworkId = this.getTargetFrameworkId(it);
            if (rdTargetFrameworkId == null) {
                encInfo = null;
            } else {
                RdTargetFrameworkId targetFrameworkId = rdTargetFrameworkId;
                encInfo = new EncInfo(targetFrameworkId);
            }
        } else {
            encInfo = null;
        }
        EncInfo encInfo2 = encInfo;
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            bl = false;
            logger.trace("Found executable: " + targetExe + "; arguments: " + targetArguments + "; working directory: " + workingDir);
        }
        return (DebuggerStartInfoBase)new DotNetCoreExeStartInfo(new DotNetCoreInfo(null), encInfo2, targetExe, workingDir, targetArguments, CollectionsKt.emptyList(), runtimeArguments, executeAsIs, false);
    }

    private final RdTargetFrameworkId getTargetFrameworkId(String dotnetVersion2) {
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)dotnetVersion2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.isEmpty()) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)((String)parts.get(0)));
        if (n == null) {
            return null;
        }
        int major = n;
        Integer n2 = parts.size() > 1 ? StringsKt.toIntOrNull((String)((String)parts.get(1))) : null;
        int minor = n2 != null ? n2 : 0;
        Integer n3 = parts.size() > 2 ? StringsKt.toIntOrNull((String)((String)parts.get(2))) : null;
        int patch = n3 != null ? n3 : 0;
        RdVersionInfo versionInfo = new RdVersionInfo(major, minor, patch);
        return new RdTargetFrameworkId(versionInfo, ".NETCoreApp", "net" + major + "." + minor, true, false);
    }

    private static final CharSequence getDebuggerStartInfo$lambda$3(List $arguments, int it) {
        return (CharSequence)$arguments.get(it);
    }

    private static final CharSequence getDebuggerStartInfo$lambda$4(List $arguments, int it) {
        return (CharSequence)$arguments.get(it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DotNetCoreDockerDebugProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

