/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.attach.attachHosts;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.execution.RunManager;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.xdebugger.attach.XAttachHost;
import com.jetbrains.rider.plugins.appender.docker.attach.ContainerProcessesFetchingProblemExceptionsKt;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.RunManagerExtensionsKt;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/attach/attachHosts/RiderDockerServerAttachHost;", "Lcom/intellij/xdebugger/attach/XAttachHost$Async;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "isConnected", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/remoteServer/configuration/RemoteServer;ZLcom/intellij/openapi/project/Project;)V", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "getProcessListAsync", "", "Lcom/intellij/execution/process/ProcessInfo;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "other", "", "hashCode", "", "intellij.rider.plugins.appender"})
public final class RiderDockerServerAttachHost
implements XAttachHost.Async {
    @NotNull
    private final RemoteServer<DockerCloudConfiguration> server;
    private final boolean isConnected;
    @NotNull
    private final Project project;

    public RiderDockerServerAttachHost(@NotNull RemoteServer<DockerCloudConfiguration> server, boolean isConnected, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.server = server;
        this.isConnected = isConnected;
        this.project = project;
    }

    @NotNull
    public final RemoteServer<DockerCloudConfiguration> getServer() {
        return this.server;
    }

    @Nullable
    public Object getProcessListAsync(@NotNull Continuation<? super List<? extends ProcessInfo>> $completion) {
        if (!this.isConnected) {
            throw ContainerProcessesFetchingProblemExceptionsKt.serverIsNotConnectedException(this.server);
        }
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        String string = this.server.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        boolean containsDockerRunConfiguration = RunManagerExtensionsKt.containsDockerRunConfiguration(runManager, string);
        if (containsDockerRunConfiguration) {
            throw ContainerProcessesFetchingProblemExceptionsKt.unableToFindRunningContainerException();
        }
        throw ContainerProcessesFetchingProblemExceptionsKt.unableToFindContainerRunConfiguration();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RiderDockerServerAttachHost)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.server.getName(), (Object)((RiderDockerServerAttachHost)other).server.getName()) && this.isConnected == ((RiderDockerServerAttachHost)other).isConnected;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.server.getName(), this.isConnected};
        return Objects.hash(objectArray);
    }
}

