/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.ms.converters;

import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.ms.SqlServerMsJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.SqlServerConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ConnectionPropertyTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/ms/converters/AuthenticationConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/SqlServerConnectionString;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/ms/SqlServerMsJdbcUrl;", "<init>", "()V", "jdbcToConnectionString", "Ljava/util/TreeMap;", "", "connectionStringToJdbc", "fromJdbcToConnectionString", "", "connectionString", "jdbcUrl", "fromConnectionStringToJdbc", "add", "jdbcValue", "connectionStringValue", "intellij.rider.plugins.appender"})
public final class AuthenticationConnectionPropertyTranslator
implements ConnectionPropertyTranslator<SqlServerConnectionString, SqlServerMsJdbcUrl> {
    @NotNull
    public static final AuthenticationConnectionPropertyTranslator INSTANCE = new AuthenticationConnectionPropertyTranslator();
    @NotNull
    private static final TreeMap<String, String> jdbcToConnectionString = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
    @NotNull
    private static final TreeMap<String, String> connectionStringToJdbc = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));

    private AuthenticationConnectionPropertyTranslator() {
    }

    @Override
    public void fromJdbcToConnectionString(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerMsJdbcUrl jdbcUrl) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        String string = jdbcUrl.getAuthentication();
        if (string == null) {
            return;
        }
        String authenticationType = string;
        if (jdbcToConnectionString.get(authenticationType) != null) {
            connectionString.setAuthentication(jdbcToConnectionString.get(authenticationType));
        } else {
            if (StringsKt.equals((String)authenticationType, (String)"NotSpecified", (boolean)true)) {
                return;
            }
            String[] stringArray = new String[]{"(?<=.)(?=\\p{Lu})"};
            List splitByUppercase = StringsKt.split$default((CharSequence)authenticationType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            connectionString.setAuthentication(!((Collection)splitByUppercase).isEmpty() ? authenticationType : CollectionsKt.joinToString$default((Iterable)splitByUppercase, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
    }

    @Override
    public void fromConnectionStringToJdbc(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerMsJdbcUrl jdbcUrl) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Object object = connectionString.getAuthentication();
        if (object == null || (object = ((SqlServerConnectionString.Authentication)object).getValue()) == null) {
            return;
        }
        Object authenticationType = object;
        if (connectionStringToJdbc.get(authenticationType) != null) {
            jdbcUrl.setAuthentication(connectionStringToJdbc.get(authenticationType));
        } else {
            jdbcUrl.setAuthentication(StringsKt.replace$default((String)authenticationType, (String)"\\s", (String)"", (boolean)false, (int)4, null));
        }
    }

    private final void add(String jdbcValue, String connectionStringValue) {
        ((Map)jdbcToConnectionString).put(jdbcValue, connectionStringValue);
        ((Map)connectionStringToJdbc).put(connectionStringValue, jdbcValue);
    }

    static {
        INSTANCE.add("ActiveDirectoryIntegrated", "Active Directory Integrated");
        INSTANCE.add("ActiveDirectoryPassword", "Active Directory Password");
        INSTANCE.add("ActiveDirectoryMSI", "Active Directory MSI");
        INSTANCE.add("ActiveDirectoryInteractive", "Active Directory Interactive");
        INSTANCE.add("ActiveDirectoryServicePrincipal", "Active Directory Service Principal");
        INSTANCE.add("ActiveDirectoryDeviceCodeFlow", "Active Directory Device Code Flow");
        INSTANCE.add("ActiveDirectoryManagedIdentity", "Active Directory Managed Identity");
        INSTANCE.add("SqlPassword", "Sql Password");
    }
}

