/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.jtds.converters;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.MicrosoftSqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.SqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.jtds.SqlServerJtdsJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.jtds.converters.SslConnectionPropertyTranslator;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.ConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.SqlServerConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ConverterBase;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ServerConnectionPropertyTranslator;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.jdbcUrls.JdbcUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/jtds/converters/JtdsConverter;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ConverterBase;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/SqlServerConnectionString;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/jtds/SqlServerJtdsJdbcUrl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "convert", "connectionString", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/ConnectionString;", "databaseDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "accepts", "", "jdbcUrl", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/jdbcUrls/JdbcUrl;", "provider", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;", "getConnectionStringIfAccepts", "getUrlIfAccepts", "mapServerProperties", "", "mapMiscellaneousProperties", "mapAuthenticationProperties", "mapSSLProperties", "intellij.rider.plugins.appender"})
public final class JtdsConverter
extends ConverterBase<SqlServerConnectionString, SqlServerJtdsJdbcUrl> {
    @NotNull
    private final Project project;

    public JtdsConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mapServerProperties();
        this.mapAuthenticationProperties();
        this.mapSSLProperties();
        this.mapMiscellaneousProperties();
    }

    @Override
    @Nullable
    public SqlServerJtdsJdbcUrl convert(@NotNull ConnectionString connectionString, @NotNull DatabaseDriver databaseDriver) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)databaseDriver, (String)"databaseDriver");
        SqlServerConnectionString sqlServerConnectionString = this.getConnectionStringIfAccepts(connectionString, databaseDriver);
        if (sqlServerConnectionString == null) {
            return null;
        }
        SqlServerConnectionString sqlServerConnectionString2 = sqlServerConnectionString;
        return (SqlServerJtdsJdbcUrl)this.toJdbcUrl((ConnectionString)sqlServerConnectionString2, (JdbcUrl)new SqlServerJtdsJdbcUrl());
    }

    @Override
    public boolean accepts(@NotNull ConnectionString connectionString, @NotNull DatabaseDriver databaseDriver) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)databaseDriver, (String)"databaseDriver");
        return this.getConnectionStringIfAccepts(connectionString, databaseDriver) != null;
    }

    @Override
    @Nullable
    public SqlServerConnectionString convert(@NotNull JdbcUrl jdbcUrl, @NotNull DotnetDataProvider provider) {
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        SqlServerJtdsJdbcUrl sqlServerJtdsJdbcUrl = this.getUrlIfAccepts(jdbcUrl, provider);
        if (sqlServerJtdsJdbcUrl == null) {
            return null;
        }
        SqlServerJtdsJdbcUrl jtdsJdbcUrl = sqlServerJtdsJdbcUrl;
        return (SqlServerConnectionString)this.toConnectionString((ConnectionString)new SqlServerConnectionString(this.project), (JdbcUrl)jtdsJdbcUrl);
    }

    @Override
    public boolean accepts(@NotNull JdbcUrl jdbcUrl, @NotNull DotnetDataProvider provider) {
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return this.getUrlIfAccepts(jdbcUrl, provider) != null;
    }

    private final SqlServerConnectionString getConnectionStringIfAccepts(ConnectionString connectionString, DatabaseDriver databaseDriver) {
        if (connectionString instanceof SqlServerConnectionString && MsUtils.isJtds((DatabaseDriver)databaseDriver)) {
            return (SqlServerConnectionString)connectionString;
        }
        return null;
    }

    private final SqlServerJtdsJdbcUrl getUrlIfAccepts(JdbcUrl jdbcUrl, DotnetDataProvider provider) {
        return jdbcUrl instanceof SqlServerJtdsJdbcUrl && (provider instanceof SqlClientDataProvider || provider instanceof MicrosoftSqlClientDataProvider) ? (SqlServerJtdsJdbcUrl)jdbcUrl : null;
    }

    private final void mapServerProperties() {
        this.map(SqlServerConnectionString.Property.DataSource, SqlServerJtdsJdbcUrl.Property.Server, ServerConnectionPropertyTranslator.INSTANCE);
    }

    private final void mapMiscellaneousProperties() {
        this.directMap(SqlServerConnectionString.Property.InitialCatalog, SqlServerJtdsJdbcUrl.Property.Database);
        this.directMap(SqlServerConnectionString.Property.ApplicationName, SqlServerJtdsJdbcUrl.Property.ApplicationName);
        this.directMap(SqlServerConnectionString.Property.WorkstationID, SqlServerJtdsJdbcUrl.Property.WorkstationID);
        this.directMap(SqlServerConnectionString.Property.PacketSize, SqlServerJtdsJdbcUrl.Property.PacketSize);
    }

    private final void mapAuthenticationProperties() {
        this.directMap(SqlServerConnectionString.Property.UserID, SqlServerJtdsJdbcUrl.Property.User);
        this.directMap(SqlServerConnectionString.Property.Password, SqlServerJtdsJdbcUrl.Property.Password);
    }

    private final void mapSSLProperties() {
        this.map(SqlServerConnectionString.Property.Encrypt, SqlServerJtdsJdbcUrl.Property.Ssl, SslConnectionPropertyTranslator.INSTANCE);
    }
}

