/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class IdeConsoleHandlerFormatter
extends Formatter {
    private static final String format = "%2$s: %1$s - %3$s %4$s%n";
    private static final String backendLoggerName = "com.jetbrains.jdbc.base.utils.logging.BackendLogListener";

    @Override
    public String format(LogRecord record) {
        String source = this.getSource(record);
        String message = this.formatMessage(record);
        String throwable = this.getThrowable(record);
        return new java.util.Formatter().format(format, source, record.getLevel().getName(), message, throwable).toString();
    }

    private String getSource(LogRecord record) {
        if (this.isLogFromBackend(record).booleanValue()) {
            return this.getSourceForBackendLog();
        }
        return this.getSourceForFrontendLog(record);
    }

    private String getThrowable(LogRecord record) {
        if (record.getThrown() == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        record.getThrown().printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private Boolean isLogFromBackend(LogRecord record) {
        return record.getSourceClassName() != null && record.getSourceClassName().equals(backendLoggerName);
    }

    private String getSourceForFrontendLog(LogRecord record) {
        Object source;
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        return source;
    }

    private String getSourceForBackendLog() {
        return "[JB JDBC Driver Backend]";
    }
}

