/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.Fix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonDescription;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonLinkDescription;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonSeverity;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ShowDetailsHtmlContentCreator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.SingleActionLinkDescription;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u001c\u0010%\u001a\u00020\u0013*\u00020&2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ShowDetailsLink;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "actionLink", "Lcom/intellij/ui/components/ActionLink;", "popupFactory", "Lcom/intellij/openapi/ui/popup/JBPopupFactory;", "kotlin.jvm.PlatformType", "textColor", "Ljava/awt/Color;", "backgroundColor", "Lorg/jetbrains/annotations/NotNull;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getComponent", "enable", "", "disable", "hide", "show", "balloonLinkDescription", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonLinkDescription;", "linkDescription", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/SingleActionLinkDescription;", "showBalloon", "balloonDescription", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonDescription;", "handleDetailsLink", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "actions", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/Fix;", "addActionListener", "Ljavax/swing/AbstractButton;", "l", "Ljava/awt/event/ActionListener;", "getBalloonBorderColor", "severity", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonSeverity;", "intellij.rider.plugins.appender"})
public final class ShowDetailsLink {
    @NotNull
    private final ActionLink actionLink;
    private final JBPopupFactory popupFactory;
    private final Color textColor;
    @NotNull
    private final Color backgroundColor;
    @NotNull
    private final SequentialLifetimes lifetimes;

    public ShowDetailsLink(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.actionLink = new ActionLink();
        this.popupFactory = JBPopupFactory.getInstance();
        this.textColor = UIUtil.getLabelTextForeground();
        Color color = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPanelBackground(...)");
        this.backgroundColor = color;
        this.lifetimes = new SequentialLifetimes(lifetime);
    }

    @NotNull
    public final ActionLink getComponent() {
        return this.actionLink;
    }

    public final void enable() {
        this.actionLink.setEnabled(true);
    }

    public final void disable() {
        this.actionLink.setEnabled(false);
    }

    public final void hide() {
        this.lifetimes.next();
        this.actionLink.setVisible(false);
    }

    public final void show(@NotNull BalloonLinkDescription balloonLinkDescription) {
        Intrinsics.checkNotNullParameter((Object)balloonLinkDescription, (String)"balloonLinkDescription");
        this.actionLink.setVisible(true);
        this.actionLink.setEnabled(true);
        this.actionLink.setText(balloonLinkDescription.getText());
        BalloonDescription balloonDescription = balloonLinkDescription.getBalloonDescription();
        LifetimeDefinition lifetime = this.lifetimes.next();
        this.addActionListener((AbstractButton)this.actionLink, (Lifetime)lifetime, arg_0 -> ShowDetailsLink.show$lambda$0(this, lifetime, balloonDescription, arg_0));
        if (balloonDescription.getShowImmediately()) {
            this.showBalloon((Lifetime)lifetime, balloonDescription);
        }
    }

    public final void show(@NotNull SingleActionLinkDescription linkDescription) {
        Intrinsics.checkNotNullParameter((Object)linkDescription, (String)"linkDescription");
        this.actionLink.setVisible(true);
        this.actionLink.setText(linkDescription.getText());
        LifetimeDefinition lifetime = this.lifetimes.next();
        this.addActionListener((AbstractButton)this.actionLink, (Lifetime)lifetime, arg_0 -> ShowDetailsLink.show$lambda$1(linkDescription, arg_0));
    }

    private final void showBalloon(Lifetime lifetime, BalloonDescription balloonDescription) {
        String content = ShowDetailsHtmlContentCreator.INSTANCE.create(balloonDescription);
        Ref.ObjectRef balloon = new Ref.ObjectRef();
        balloon.element = this.popupFactory.createHtmlTextBalloonBuilder(content, null, this.textColor, this.backgroundColor, arg_0 -> ShowDetailsLink.showBalloon$lambda$0(this, balloonDescription, balloon, arg_0)).setAnimationCycle(100).setBorderColor(this.getBalloonBorderColor(balloonDescription.getSeverity())).createBalloon();
        lifetime.onTermination(() -> ShowDetailsLink.showBalloon$lambda$1(balloon));
        ((Balloon)balloon.element).show(RelativePoint.getNorthWestOf((JComponent)((JComponent)this.actionLink)), Balloon.Position.above);
    }

    private final boolean handleDetailsLink(HyperlinkEvent e, List<? extends Fix> actions) {
        if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return false;
        }
        String string = StringUtil.trimStart((String)e.getDescription(), (String)"fix_");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(...)");
        Integer actionIndex = StringsKt.toIntOrNull((String)string);
        if (actionIndex == null || actionIndex >= actions.size()) {
            return false;
        }
        actions.get(actionIndex).execute();
        return true;
    }

    private final void addActionListener(AbstractButton $this$addActionListener, Lifetime lifetime, ActionListener l) {
        lifetime.bracketIfAlive(() -> ShowDetailsLink.addActionListener$lambda$0($this$addActionListener, l), () -> ShowDetailsLink.addActionListener$lambda$1($this$addActionListener, l));
    }

    private final Color getBalloonBorderColor(BalloonSeverity severity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> {
                JBColor v0 = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"RED");
                yield (Color)v0;
            }
            case 2 -> {
                JBColor v2 = JBColor.ORANGE;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ORANGE");
                yield (Color)v2;
            }
            case 3 -> {
                JBColor v3 = JBColor.GREEN;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"GREEN");
                yield (Color)v3;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void show$lambda$0(ShowDetailsLink this$0, LifetimeDefinition $lifetime, BalloonDescription $balloonDescription, ActionEvent it) {
        this$0.showBalloon((Lifetime)$lifetime, $balloonDescription);
    }

    private static final void show$lambda$1(SingleActionLinkDescription $linkDescription, ActionEvent it) {
        $linkDescription.getAction().invoke();
    }

    private static final void showBalloon$lambda$0(ShowDetailsLink this$0, BalloonDescription $balloonDescription, Ref.ObjectRef $balloon, HyperlinkEvent it) {
        block1: {
            Intrinsics.checkNotNull((Object)it);
            if (!this$0.handleDetailsLink(it, $balloonDescription.getActions())) break block1;
            Balloon balloon = (Balloon)$balloon.element;
            if (balloon != null) {
                balloon.hide();
            }
        }
    }

    private static final Unit showBalloon$lambda$1(Ref.ObjectRef $balloon) {
        ((Balloon)$balloon.element).hide();
        return Unit.INSTANCE;
    }

    private static final Unit addActionListener$lambda$0(AbstractButton $this_addActionListener, ActionListener $l) {
        $this_addActionListener.addActionListener($l);
        return Unit.INSTANCE;
    }

    private static final Unit addActionListener$lambda$1(AbstractButton $this_addActionListener, ActionListener $l) {
        $this_addActionListener.removeActionListener($l);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BalloonSeverity.values().length];
            try {
                nArray[BalloonSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BalloonSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BalloonSeverity.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

