/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ConfigurationProblem;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0015\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!2\u0006\u0010\u0017\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationFixComponent;", "", "<init>", "()V", "myWarningLabel", "Ljavax/swing/JEditorPane;", "viewport", "Ljavax/swing/JViewport;", "getViewport", "()Ljavax/swing/JViewport;", "component", "Ljavax/swing/JComponent;", "currentProblem", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationProblem;", "_fixClicked", "Lcom/jetbrains/rd/util/reactive/Signal;", "fixClicked", "Lcom/jetbrains/rd/util/reactive/ISource;", "getFixClicked", "()Lcom/jetbrains/rd/util/reactive/ISource;", "getComponent", "show", "", "problem", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "hide", "enable", "disable", "handleHyperLinkClick", "hyperlinkEvent", "Ljavax/swing/event/HyperlinkEvent;", "generateWarningLabelText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nConfigurationFixComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationFixComponent.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationFixComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class ConfigurationFixComponent {
    @NotNull
    private final JEditorPane myWarningLabel;
    @NotNull
    private final JViewport viewport;
    @NotNull
    private final JComponent component;
    @Nullable
    private ConfigurationProblem currentProblem;
    @NotNull
    private final Signal<Object> _fixClicked;
    @NotNull
    private final ISource<Object> fixClicked;

    /*
     * WARNING - void declaration
     */
    public ConfigurationFixComponent() {
        void $this$viewport_u24lambda_u240;
        JComponent $this$myWarningLabel_u24lambda_u240;
        JComponent jComponent;
        JEditorPane jEditorPane = jComponent = new JEditorPane();
        ConfigurationFixComponent configurationFixComponent = this;
        boolean bl = false;
        $this$myWarningLabel_u24lambda_u240.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        $this$myWarningLabel_u24lambda_u240.setEditable(false);
        $this$myWarningLabel_u24lambda_u240.setBorder(null);
        NonOpaquePanel.setTransparent((JComponent)$this$myWarningLabel_u24lambda_u240);
        $this$myWarningLabel_u24lambda_u240.addHyperlinkListener(arg_0 -> ConfigurationFixComponent.myWarningLabel$lambda$0$0(this, arg_0));
        configurationFixComponent.myWarningLabel = jComponent;
        $this$myWarningLabel_u24lambda_u240 = jComponent = new JViewport(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(JBUI.scale((int)100), size.height);
            }
        };
        configurationFixComponent = this;
        boolean bl2 = false;
        $this$viewport_u24lambda_u240.setView(this.myWarningLabel);
        configurationFixComponent.viewport = (JViewport)jComponent;
        this._fixClicked = new Signal();
        this.fixClicked = (ISource)this._fixClicked;
        this.component = (JComponent)BuilderKt.panel(arg_0 -> ConfigurationFixComponent._init_$lambda$0(this, arg_0));
        ((DialogPanel)this.component).setVisible(false);
        ClientProperty.put((JComponent)this.component, (Key)UserActivityWatcher.DO_NOT_WATCH, (Object)true);
    }

    @NotNull
    public final JViewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final ISource<Object> getFixClicked() {
        return this.fixClicked;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void show(@NotNull DataSourceProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (Comparing.equal((Object)problem, (Object)this.currentProblem)) {
            return;
        }
        ConfigurationProblem configurationProblem = new ConfigurationProblem(problem);
        this.component.setVisible(true);
        this.currentProblem = configurationProblem;
        this.myWarningLabel.setText(this.generateWarningLabelText(configurationProblem));
    }

    public final void hide() {
        this.component.setVisible(false);
    }

    public final void enable() {
        this.component.setEnabled(true);
    }

    public final void disable() {
        this.component.setEnabled(false);
    }

    private final void handleHyperLinkClick(HyperlinkEvent hyperlinkEvent) {
        block1: {
            if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            ConfigurationProblem configurationProblem = this.currentProblem;
            if (configurationProblem == null) break block1;
            ConfigurationProblem it = configurationProblem;
            boolean bl = false;
            Object action = DataSourceProblem.extractAction((String)hyperlinkEvent.getDescription(), it.getActions());
            Intrinsics.checkNotNull((Object)action);
            this._fixClicked.fire(action);
        }
    }

    private final String generateWarningLabelText(ConfigurationProblem problem) {
        Object[] objectArray;
        DataSourceProblem dataSourceProblem = problem.getDataSourceProblem();
        StringBuilder builder = new StringBuilder("<html><body>");
        String string = dataSourceProblem.getText().getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        String title = string;
        builder.append("<font face=\"verdana\">");
        if (!StringUtil.isEmptyOrSpaces((String)title)) {
            builder.append("<b>");
            objectArray = dataSourceProblem.getText().getLinkActions();
            DataSourceProblem.formatText((StringBuilder)builder, problem.getActions(), (String)title, (Object[])Arrays.copyOf(objectArray, objectArray.length));
            builder.append("</b>: ");
        }
        objectArray = dataSourceProblem.getText().getLinkActions();
        DataSourceProblem.formatText((StringBuilder)builder, problem.getActions(), (String)dataSourceProblem.getText().getShortDescription(), (Object[])Arrays.copyOf(objectArray, objectArray.length));
        builder.append("</font></body></html>");
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final void myWarningLabel$lambda$0$0(ConfigurationFixComponent this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.handleHyperLinkClick(it);
    }

    private static final Unit _init_$lambda$0(ConfigurationFixComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigurationFixComponent.lambda$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(ConfigurationFixComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = UIUtil.getBalloonWarningIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getBalloonWarningIcon(...)");
        $this$row.icon(icon).align((Align)AlignX.LEFT.INSTANCE).gap(RightGap.SMALL);
        $this$row.cell((JComponent)this$0.viewport).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE).resizableColumn();
        return Unit.INSTANCE;
    }
}

