/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.reactive.Signal;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001-B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u0014J\"\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\t2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0011J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u0006\u0010\"\u001a\u00020\u0011J\u000b\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020$J\r\u0010'\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b)J\u0006\u0010*\u001a\u00020\u0014J\u0006\u0010+\u001a\u00020\u0014J\b\u0010,\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "currentModel", "Lcom/intellij/database/dataSource/url/template/UrlEditorModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/database/dataSource/url/template/UrlEditorModel;)V", "authPanel", "Lcom/intellij/database/dataSource/url/ui/DatabaseAuthPanel;", "loopPreventor", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler$LoopPreventor;", "isPopupOpen", "", "authTypeSelected", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getAuthTypeSelected", "()Lcom/jetbrains/rd/util/reactive/Signal;", "fieldValueChanged", "getFieldValueChanged", "updateFromUrl", "reinitialize", "model", "authProvider", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "save", "copyCredentials", "processAuthTypeSelection", "authFieldValueChanged", "isNeeded", "getComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "getPreferredFocusedComponent", "getAuthWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "Lorg/jetbrains/annotations/Nullable;", "enable", "disable", "isUserChangeToAuthFields", "LoopPreventor", "intellij.rider.plugins.appender"})
public final class AuthHandler {
    @NotNull
    private UrlEditorModel currentModel;
    @NotNull
    private final DatabaseAuthPanel authPanel;
    @NotNull
    private final LoopPreventor loopPreventor;
    private boolean isPopupOpen;
    @NotNull
    private final Signal<Unit> authTypeSelected;
    @NotNull
    private final Signal<Unit> fieldValueChanged;

    public AuthHandler(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentials, @NotNull UrlEditorModel currentModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)currentModel, (String)"currentModel");
        this.currentModel = currentModel;
        this.authPanel = new DatabaseAuthPanel(project, (DatabaseConnectionConfig)dataSource, credentials);
        this.loopPreventor = new LoopPreventor();
        this.authTypeSelected = new Signal();
        this.fieldValueChanged = new Signal();
        this.authPanel.addListeners(this::authFieldValueChanged, arg_0 -> AuthHandler._init_$lambda$0(this, arg_0));
        this.authPanel.getAuthComboBox().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                isPopupOpen = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                isPopupOpen = false;
                this.processAuthTypeSelection();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                isPopupOpen = false;
            }
        });
        AuthHandler.reinitialize$default(this, dataSource, this.currentModel, null, 4, null);
    }

    @NotNull
    public final Signal<Unit> getAuthTypeSelected() {
        return this.authTypeSelected;
    }

    @NotNull
    public final Signal<Unit> getFieldValueChanged() {
        return this.fieldValueChanged;
    }

    public final void updateFromUrl() {
        this.loopPreventor.enable();
        DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
        if (authWidget != null) {
            authWidget.updateFromUrl((ParametersHolder)this.currentModel);
        }
        this.loopPreventor.disable();
        this.authPanel.getComponent().revalidate();
        this.authPanel.getComponent().repaint();
    }

    public final void reinitialize(@NotNull LocalDataSource dataSource, @NotNull UrlEditorModel model2, @Nullable DatabaseAuthProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.currentModel = model2;
        this.loopPreventor.enable();
        this.authPanel.reset((DatabaseConnectionConfig)dataSource, false);
        this.authPanel.validateAuthTypes((DatabaseConnectionConfig)dataSource, authProvider);
        this.loopPreventor.disable();
        this.authPanel.getComponent().revalidate();
        this.authPanel.getComponent().repaint();
    }

    public static /* synthetic */ void reinitialize$default(AuthHandler authHandler, LocalDataSource localDataSource, UrlEditorModel urlEditorModel, DatabaseAuthProvider databaseAuthProvider, int n, Object object) {
        if ((n & 4) != 0) {
            databaseAuthProvider = null;
        }
        authHandler.reinitialize(localDataSource, urlEditorModel, databaseAuthProvider);
    }

    public final void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.authPanel.save((DatabaseConnectionConfig)dataSource, copyCredentials);
    }

    private final void processAuthTypeSelection() {
        if (this.isPopupOpen) {
            return;
        }
        this.updateFromUrl();
        this.authTypeSelected.fire((Object)Unit.INSTANCE);
    }

    private final void authFieldValueChanged() {
        if (this.isUserChangeToAuthFields()) {
            if (this.currentModel.isParserValid()) {
                DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
                if (authWidget != null) {
                    authWidget.updateUrl((MutableParametersHolder)this.currentModel);
                }
            }
            this.currentModel.commit((Object)true);
        }
        this.fieldValueChanged.fire((Object)Unit.INSTANCE);
    }

    public final boolean isNeeded() {
        return this.authPanel.isNeeded();
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.authPanel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.authPanel.getPreferredFocusedComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getPreferredFocusedComponent(...)");
        return jComponent;
    }

    @Nullable
    public final DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.authPanel.getAuthWidget();
    }

    public final void enable() {
        block0: {
            this.getComponent().setEnabled(true);
            Object object = this.authPanel.getAuthWidget();
            if (object == null || (object = object.getComponent()) == null) break block0;
            ((JComponent)object).setEnabled(true);
        }
    }

    public final void disable() {
        block0: {
            this.getComponent().setEnabled(false);
            Object object = this.authPanel.getAuthWidget();
            if (object == null || (object = object.getComponent()) == null) break block0;
            ((JComponent)object).setEnabled(false);
        }
    }

    private final boolean isUserChangeToAuthFields() {
        return !this.loopPreventor.isActive();
    }

    private static final void _init_$lambda$0(AuthHandler this$0, Object it) {
        this$0.processAuthTypeSelection();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler$LoopPreventor;", "", "<init>", "()V", "value", "", "isActive", "()Z", "enable", "", "disable", "intellij.rider.plugins.appender"})
    private static final class LoopPreventor {
        private boolean isActive;

        public final boolean isActive() {
            return this.isActive;
        }

        public final void enable() {
            this.isActive = true;
        }

        public final void disable() {
            this.isActive = false;
        }
    }
}

