/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation;

import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Steps;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0018J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0018J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0018J\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/RailTracks;", "", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;)V", "manualSteps", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Steps;", "urlSteps", "currentSteps", "value", "currentTrack", "getCurrentTrack", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "selectTrack", "", "addStep", "", "step", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "page", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "removeStep", "moveToBeginning", "Lkotlin/Pair;", "moveNext", "movePrevious", "currentStep", "currentStepPosition", "", "goToStep", "getStepsByConnectionType", "intellij.rider.plugins.appender"})
public final class RailTracks {
    @NotNull
    private final Steps manualSteps;
    @NotNull
    private final Steps urlSteps;
    @NotNull
    private Steps currentSteps;
    @NotNull
    private ConnectionType currentTrack;

    public RailTracks(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        this.manualSteps = new Steps();
        this.urlSteps = new Steps();
        this.currentSteps = this.getStepsByConnectionType(connectionType);
        this.currentTrack = connectionType;
    }

    @NotNull
    public final ConnectionType getCurrentTrack() {
        return this.currentTrack;
    }

    public final boolean selectTrack(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        if (connectionType == this.currentTrack) {
            return false;
        }
        this.currentSteps.moveToBeginning();
        this.currentSteps = this.getStepsByConnectionType(connectionType);
        this.currentTrack = connectionType;
        return true;
    }

    public final void addStep(@NotNull DatabaseConnectionStep step, @NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getStepsByConnectionType(step.getConnectionType()).add(step, page);
    }

    public final void removeStep(@NotNull DatabaseConnectionStep step, @NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getStepsByConnectionType(step.getConnectionType()).remove(step, page);
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> moveToBeginning() {
        return this.currentSteps.moveToBeginning();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> moveNext() {
        return this.currentSteps.moveNext();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> movePrevious() {
        return this.currentSteps.movePrevious();
    }

    @NotNull
    public final DatabaseConnectionStep currentStep() {
        return this.currentSteps.currentStep();
    }

    public final int currentStepPosition() {
        return this.currentSteps.currentStepPosition();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> goToStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return this.currentSteps.goToStep(step);
    }

    private final Steps getStepsByConnectionType(ConnectionType connectionType) {
        return connectionType == ConnectionType.Url ? this.urlSteps : this.manualSteps;
    }
}

