/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation;

import com.intellij.ui.JBCardLayout;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.RailTracks;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001eJ\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u001eJ\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020(J$\u0010%\u001a\u00020\u001e2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020!0*2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "panel", "Ljavax/swing/JPanel;", "layout", "Lcom/intellij/ui/JBCardLayout;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;Ljavax/swing/JPanel;Lcom/intellij/ui/JBCardLayout;)V", "stepShownLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "railTracks", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/RailTracks;", "_currentTrack", "Lcom/jetbrains/rd/util/reactive/Property;", "currentTrack", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getCurrentTrack", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "value", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "currentStep", "getCurrentStep", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "currentStepPosition", "", "changeTrack", "", "addPage", "page", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "moveNext", "movePrevious", "moveToBeginning", "moveTo", "databaseConnectionStep", "isCurrentStepFirst", "", "stepAndPage", "Lkotlin/Pair;", "direction", "Lcom/intellij/ui/JBCardLayout$SwipeDirection;", "intellij.rider.plugins.appender"})
public final class Navigator {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JBCardLayout layout;
    @NotNull
    private final SequentialLifetimes stepShownLifetimes;
    @NotNull
    private final RailTracks railTracks;
    @NotNull
    private final Property<ConnectionType> _currentTrack;
    @NotNull
    private final IPropertyView<ConnectionType> currentTrack;
    private DatabaseConnectionStep currentStep;
    private int currentStepPosition;

    public Navigator(@NotNull Lifetime lifetime, @NotNull ConnectionType connectionType, @NotNull JPanel panel, @NotNull JBCardLayout layout) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.lifetime = lifetime;
        this.panel = panel;
        this.layout = layout;
        this.stepShownLifetimes = new SequentialLifetimes(this.lifetime);
        this.railTracks = new RailTracks(connectionType);
        this._currentTrack = new Property((Object)this.railTracks.getCurrentTrack());
        this.currentTrack = (IPropertyView)this._currentTrack;
        this.currentStepPosition = -1;
    }

    @NotNull
    public final IPropertyView<ConnectionType> getCurrentTrack() {
        return this.currentTrack;
    }

    @NotNull
    public final DatabaseConnectionStep getCurrentStep() {
        DatabaseConnectionStep databaseConnectionStep = this.currentStep;
        if (databaseConnectionStep != null) {
            return databaseConnectionStep;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentStep");
        return null;
    }

    public final void changeTrack(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        if (this.railTracks.selectTrack(connectionType)) {
            this.moveToBeginning();
        }
    }

    public final void addPage(@NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.panel.add((Component)page.getComponent(), page.getId());
        InterfacesKt.viewNotNull((IViewable)((IViewable)page.getSteps()), (Lifetime)this.lifetime, (arg_0, arg_1) -> Navigator.addPage$lambda$0(this, page, arg_0, arg_1));
    }

    public final void moveNext() {
        this.moveTo(this.railTracks.moveNext(), JBCardLayout.SwipeDirection.FORWARD);
    }

    public final void movePrevious() {
        this.moveTo(this.railTracks.movePrevious(), JBCardLayout.SwipeDirection.BACKWARD);
    }

    public final void moveToBeginning() {
        this.moveTo(this.railTracks.moveToBeginning(), JBCardLayout.SwipeDirection.BACKWARD);
    }

    public final void moveTo(@NotNull DatabaseConnectionStep databaseConnectionStep) {
        Intrinsics.checkNotNullParameter((Object)databaseConnectionStep, (String)"databaseConnectionStep");
        this.railTracks.selectTrack(databaseConnectionStep.getConnectionType());
        this.moveTo(this.railTracks.goToStep(databaseConnectionStep), JBCardLayout.SwipeDirection.AUTO);
    }

    public final boolean isCurrentStepFirst() {
        return this.currentStepPosition == 0;
    }

    private final void moveTo(Pair<? extends DatabaseConnectionStep, ? extends DatabaseConnectionDialogPage> stepAndPage, JBCardLayout.SwipeDirection direction) {
        DatabaseConnectionStep step = (DatabaseConnectionStep)stepAndPage.getFirst();
        DatabaseConnectionDialogPage page = (DatabaseConnectionDialogPage)stepAndPage.getSecond();
        Lifetime stepShownLifetime = Lifetime.Companion.intersect(step.getStepLifetime(), (Lifetime)this.stepShownLifetimes.next());
        this.currentStep = this.railTracks.currentStep();
        this.currentStepPosition = this.railTracks.currentStepPosition();
        this._currentTrack.set((Object)this.railTracks.getCurrentTrack());
        step.beforeShown(stepShownLifetime);
        this.layout.swipe((Container)this.panel, page.getId(), direction, () -> Navigator.moveTo$lambda$0(stepShownLifetime, step));
    }

    private static final Unit addPage$lambda$0(Navigator this$0, DatabaseConnectionDialogPage $page, Lifetime lf, DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        lf.bracketIfAlive(() -> Navigator.addPage$lambda$0$0(this$0, step, $page), () -> Navigator.addPage$lambda$0$1(this$0, step, $page));
        return Unit.INSTANCE;
    }

    private static final Unit addPage$lambda$0$0(Navigator this$0, DatabaseConnectionStep $step, DatabaseConnectionDialogPage $page) {
        this$0.railTracks.addStep($step, $page);
        return Unit.INSTANCE;
    }

    private static final Unit addPage$lambda$0$1(Navigator this$0, DatabaseConnectionStep $step, DatabaseConnectionDialogPage $page) {
        this$0.railTracks.removeStep($step, $page);
        return Unit.INSTANCE;
    }

    private static final void moveTo$lambda$0(Lifetime $stepShownLifetime, DatabaseConnectionStep $step) {
        if (RLifetimeKt.isAlive((Lifetime)$stepShownLifetime)) {
            $step.shown();
        }
    }
}

