/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionExecutionResult;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.Fix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.FixesFactory;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.FixesStorage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.ManualFixesForBalloonComparator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.UrlFixesForBalloonComparator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonDescription;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0017j\b\u0012\u0004\u0012\u00020\u0012`\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/BalloonCreator;", "", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "fixesStorage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesStorage;", "fixesFactory", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesFactory;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesStorage;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesFactory;)V", "createBalloon", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonDescription;", "testConnectionExecutionResult", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/TestConnectionExecutionResult;", "showImmediately", "", "createFixes", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/Fix;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "getFixesComparatorFor", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nBalloonCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonCreator.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/BalloonCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1563#2:38\n1634#2,3:39\n1#3:42\n*S KotlinDebug\n*F\n+ 1 BalloonCreator.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/BalloonCreator\n*L\n27#1:38\n27#1:39,3\n*E\n"})
public final class BalloonCreator {
    @NotNull
    private final ConnectionType connectionType;
    @NotNull
    private final FixesStorage fixesStorage;
    @NotNull
    private final FixesFactory fixesFactory;

    public BalloonCreator(@NotNull ConnectionType connectionType, @NotNull FixesStorage fixesStorage, @NotNull FixesFactory fixesFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)fixesStorage, (String)"fixesStorage");
        Intrinsics.checkNotNullParameter((Object)fixesFactory, (String)"fixesFactory");
        this.connectionType = connectionType;
        this.fixesStorage = fixesStorage;
        this.fixesFactory = fixesFactory;
    }

    @Nullable
    public final BalloonDescription createBalloon(@NotNull TestConnectionExecutionResult testConnectionExecutionResult, boolean showImmediately) {
        Intrinsics.checkNotNullParameter((Object)testConnectionExecutionResult, (String)"testConnectionExecutionResult");
        TestConnectionExecutionResult $this$createBalloon_u24lambda_u240 = testConnectionExecutionResult;
        boolean bl = false;
        TestConnectionExecutionResult testConnectionExecutionResult2 = $this$createBalloon_u24lambda_u240;
        if (testConnectionExecutionResult2 instanceof TestConnectionExecutionResult.Failure) {
            List<Fix> actions = this.createFixes(((TestConnectionExecutionResult.Failure)$this$createBalloon_u24lambda_u240).getResult().getFixes());
            return new BalloonDescription(BalloonSeverity.Error, ((TestConnectionExecutionResult.Failure)$this$createBalloon_u24lambda_u240).getResult().getDataSourceInfo(), ((TestConnectionExecutionResult.Failure)$this$createBalloon_u24lambda_u240).getResult().getSummary(), actions, showImmediately);
        }
        if (!(testConnectionExecutionResult2 instanceof TestConnectionExecutionResult.Success) && !(testConnectionExecutionResult2 instanceof TestConnectionExecutionResult.Cancelled)) {
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Fix> createFixes(Collection<? extends ErrorInfo.Fix> fixes) {
        Collection<Fix> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = fixes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ErrorInfo.Fix fix = (ErrorInfo.Fix)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.fixesFactory.createDatagripFix((ErrorInfo.Fix)it));
        }
        Collection<Fix> collection3 = (List)destination$iv$iv;
        if (collection3.isEmpty()) {
            boolean bl = false;
            collection = this.fixesStorage.getFixesFor(this.connectionType);
        } else {
            collection = collection3;
        }
        Collection<Fix> balloonFixes = collection;
        return CollectionsKt.sortedWith((Iterable)balloonFixes, this.getFixesComparatorFor(this.connectionType));
    }

    private final Comparator<Fix> getFixesComparatorFor(ConnectionType connectionType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[connectionType.ordinal()]) {
            case 1 -> new ManualFixesForBalloonComparator();
            case 2 -> new UrlFixesForBalloonComparator();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionType.values().length];
            try {
                nArray[ConnectionType.Manual.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionType.Url.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

