/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages;

import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.StepExtensionsKt;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010J&\u0010\u001c\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/InitialPage;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "urlStepPanel", "Ljavax/swing/JPanel;", "_steps", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "id", "", "getId", "()Ljava/lang/String;", "steps", "getSteps", "()Lcom/jetbrains/rd/util/reactive/ViewableSet;", "addUrlStep", "", "step", "addManualStep", "radioButton", "Lcom/intellij/ui/dsl/builder/Row;", "text", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "createConstants", "Lcom/intellij/uiDesigner/core/GridConstraints;", "repaintAndRevalidate", "intellij.rider.plugins.appender"})
public final class InitialPage
implements DatabaseConnectionDialogPage {
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JPanel urlStepPanel;
    @NotNull
    private final ViewableSet<DatabaseConnectionStep> _steps;
    @NotNull
    private final String id;
    @NotNull
    private final ViewableSet<DatabaseConnectionStep> steps;

    public InitialPage(@NotNull Lifetime lifetime, @NotNull Navigator navigator) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        this.navigator = navigator;
        this.urlStepPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 1));
        this._steps = new ViewableSet(null, 1, null);
        this.id = "Initial";
        this.steps = this._steps;
        this.component = (JComponent)BuilderKt.panel(arg_0 -> InitialPage._init_$lambda$0(this, lifetime, arg_0));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ViewableSet<DatabaseConnectionStep> getSteps() {
        return this.steps;
    }

    public final void addUrlStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.urlStepPanel.add((Component)step.getComponent(), this.createConstants());
        this._steps.add((Object)step);
        this.repaintAndRevalidate();
        this.navigator.getCurrentTrack().advise(step.getStepLifetime(), arg_0 -> InitialPage.addUrlStep$lambda$0(step, arg_0));
        step.getStepLifetime().onTermination(() -> InitialPage.addUrlStep$lambda$1(this, step));
    }

    public final void addManualStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        step.getStepLifetime().bracketIfAlive(() -> InitialPage.addManualStep$lambda$0(this, step), () -> InitialPage.addManualStep$lambda$1(this, step));
    }

    private final void radioButton(Row $this$radioButton, Lifetime lifetime, @NlsContexts.RadioButton String text, ConnectionType connectionType) {
        Row.radioButton$default((Row)$this$radioButton, (String)text, null, (int)2, null).applyToComponent(arg_0 -> InitialPage.radioButton$lambda$0(this, lifetime, connectionType, arg_0));
    }

    private final GridConstraints createConstants() {
        GridConstraints gridConstraints = DatabaseUIUtils.createConstraints((int)0, (int)0, (int)1, (int)9, (int)3, (int)-1, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)gridConstraints, (String)"createConstraints(...)");
        return gridConstraints;
    }

    private final void repaintAndRevalidate() {
        this.urlStepPanel.revalidate();
        this.urlStepPanel.repaint();
    }

    private static final Unit _init_$lambda$0(InitialPage this$0, Lifetime $lifetime, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> InitialPage.lambda$0$0(this$0, $lifetime, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(InitialPage this$0, Lifetime $lifetime, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> InitialPage.lambda$0$0$0(this$0, $lifetime, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> InitialPage.lambda$0$0$1(this$0, $lifetime, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> InitialPage.lambda$0$0$2(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$0(InitialPage this$0, Lifetime $lifetime, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.radioButton($this$row, $lifetime, RiderDatabaseBundle.message("radio.add.data.source.manually", new Object[0]), ConnectionType.Manual);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1(InitialPage this$0, Lifetime $lifetime, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.radioButton($this$row, $lifetime, RiderDatabaseBundle.message("radio.use.connection.string", new Object[0]), ConnectionType.Url);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2(InitialPage this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.urlStepPanel).resizableColumn().align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit addUrlStep$lambda$0(DatabaseConnectionStep $step, ConnectionType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
            case 1: {
                StepExtensionsKt.enable($step);
                break;
            }
            case 2: {
                StepExtensionsKt.disable($step);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit addUrlStep$lambda$1(InitialPage this$0, DatabaseConnectionStep $step) {
        this$0.urlStepPanel.remove($step.getComponent());
        this$0._steps.remove((Object)$step);
        return Unit.INSTANCE;
    }

    private static final boolean addManualStep$lambda$0(InitialPage this$0, DatabaseConnectionStep $step) {
        return this$0._steps.add((Object)$step);
    }

    private static final Unit addManualStep$lambda$1(InitialPage this$0, DatabaseConnectionStep $step) {
        this$0._steps.remove((Object)$step);
        return Unit.INSTANCE;
    }

    private static final Unit radioButton$lambda$0(InitialPage this$0, Lifetime $lifetime, ConnectionType $connectionType, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> InitialPage.radioButton$lambda$0$0(this$0, $connectionType, arg_0));
        this$0.navigator.getCurrentTrack().advise($lifetime, arg_0 -> InitialPage.radioButton$lambda$0$1($this$applyToComponent, $connectionType, arg_0));
        return Unit.INSTANCE;
    }

    private static final void radioButton$lambda$0$0(InitialPage this$0, ConnectionType $connectionType, ActionEvent it) {
        this$0.navigator.changeTrack($connectionType);
    }

    private static final Unit radioButton$lambda$0$1(JBRadioButton $this_applyToComponent, ConnectionType $connectionType, ConnectionType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $this_applyToComponent.setSelected(it == $connectionType);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionType.values().length];
            try {
                nArray[ConnectionType.Url.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionType.Manual.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

