/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.unified;

import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.openapi.ui.ValidationInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.session.ManualSelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.unified.StepStateMachine;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.unified.UnifiedManualConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionExecutionResult;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionResultDisplay;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.StepStates;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.states.IdleStateBase;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ConfigurationStatusComponent;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.TestConnectionButton;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0016\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/steps/unified/IdleState;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/states/IdleStateBase;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/steps/unified/UnifiedManualConnectionStep;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/session/ManualSelectedDriverSession;", "step", "stateMachine", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/steps/unified/StepStateMachine;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/steps/unified/UnifiedManualConnectionStep;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/steps/unified/StepStateMachine;)V", "display", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/TestConnectionResultDisplay;", "entered", "", "stateActiveLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "from", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/StepStates;", "getComponentToFocus", "Ljavax/swing/JComponent;", "problemsFound", "foundProblems", "", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "nextPressed", "previousPressed", "validationFinished", "validation", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.rider.plugins.appender"})
public final class IdleState
extends IdleStateBase<UnifiedManualConnectionStep, ManualSelectedDriverSession> {
    @NotNull
    private final StepStateMachine stateMachine;
    @NotNull
    private final TestConnectionResultDisplay display;

    public IdleState(@NotNull UnifiedManualConnectionStep step, @NotNull StepStateMachine stateMachine) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        super(step.getProject(), (DatabaseConnectionStep)step, (SelectedDriverSession)step.getSession(), step.getNavigator(), step.getDialogManager());
        this.stateMachine = stateMachine;
        this.display = new TestConnectionResultDisplay(step.getConnectionStatus(), (SelectedDriverSession)this.getSession(), step.getBalloonCreator());
    }

    @Override
    public void entered(@NotNull Lifetime stateActiveLifetime, @NotNull StepStates from) {
        Intrinsics.checkNotNullParameter((Object)stateActiveLifetime, (String)"stateActiveLifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        super.entered(stateActiveLifetime, from);
        ((ManualSelectedDriverSession)this.getSession()).isDriverDownloaded().advise(stateActiveLifetime, arg_0 -> IdleState.entered$lambda$0(this, arg_0));
        ((UnifiedManualConnectionStep)this.getStep()).getTestConnectionButton().getTestConnectionPressed().advise(stateActiveLifetime, arg_0 -> IdleState.entered$lambda$1(this, arg_0));
        ((UnifiedManualConnectionStep)this.getStep()).getConfigurationFixBar().getFixClicked().advise(stateActiveLifetime, arg_0 -> IdleState.entered$lambda$2(this, arg_0));
        ((ManualSelectedDriverSession)this.getSession()).getAuthHandler().getAuthTypeSelected().advise(stateActiveLifetime, arg_0 -> IdleState.entered$lambda$3(this, arg_0));
    }

    @Override
    @Nullable
    protected JComponent getComponentToFocus(@NotNull StepStates from) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        switch (WhenMappings.$EnumSwitchMapping$0[from.ordinal()]) {
            case 1: 
            case 2: {
                if (((ManualSelectedDriverSession)this.getSession()).getStorage().getConnectionExecutionResult() instanceof TestConnectionExecutionResult.Failure) {
                    jComponent = (JComponent)((UnifiedManualConnectionStep)this.getStep()).getConnectionStatus().getPreferredFocusableComponent();
                    break;
                }
                jComponent = this.getDialogManager().getNextButton();
                break;
            }
            case 3: {
                jComponent = ((ManualSelectedDriverSession)this.getSession()).getConstructorPanel().getPreferredFocusableComponentOnFirstPage();
                break;
            }
            case 4: {
                jComponent = ((ManualSelectedDriverSession)this.getSession()).getConstructorPanel().getPreferredFocusableComponentOnFirstPage();
                if (jComponent != null) break;
                jComponent = ((ManualSelectedDriverSession)this.getSession()).getAuthHandler().getPreferredFocusedComponent();
                break;
            }
            default: {
                jComponent = null;
            }
        }
        return jComponent;
    }

    @Override
    protected void problemsFound(@NotNull Collection<? extends DataSourceProblem> foundProblems) {
        Intrinsics.checkNotNullParameter(foundProblems, (String)"foundProblems");
        DataSourceProblem problem = (DataSourceProblem)CollectionsKt.firstOrNull((Iterable)foundProblems);
        if (problem != null) {
            ((UnifiedManualConnectionStep)this.getStep()).getConfigurationFixBar().show(problem);
        } else {
            ((UnifiedManualConnectionStep)this.getStep()).getConfigurationFixBar().hide();
        }
    }

    @Override
    public void nextPressed() {
        if (!((UnifiedManualConnectionStep)this.getStep()).beginValidation()) {
            return;
        }
        StepStates nextState = (Boolean)((ManualSelectedDriverSession)this.getSession()).isDriverDownloaded().getValue() != false ? StepStates.CreatingDatabaseConnection : StepStates.DownloadingDriver;
        this.stateMachine.goTo(nextState);
    }

    @Override
    public void previousPressed() {
        this.getNavigator().movePrevious();
    }

    @Override
    protected void validationFinished(@NotNull List<ValidationInfo> validation) {
        Intrinsics.checkNotNullParameter(validation, (String)"validation");
        if (validation.isEmpty()) {
            ((UnifiedManualConnectionStep)this.getStep()).getTestConnectionButton().enable();
        } else {
            ((UnifiedManualConnectionStep)this.getStep()).getTestConnectionButton().disable();
        }
    }

    private static final Unit entered$lambda$0(IdleState this$0, boolean it) {
        if (it) {
            TestConnectionButton testConnectionButton;
            TestConnectionButton $this$entered_u24lambda_u240_u240 = testConnectionButton = ((UnifiedManualConnectionStep)this$0.getStep()).getTestConnectionButton();
            boolean bl = false;
            $this$entered_u24lambda_u240_u240.show();
            $this$entered_u24lambda_u240_u240.enable();
            this$0.display.showConnectionResult(((ManualSelectedDriverSession)this$0.getSession()).getStorage().getConnectionExecutionResult());
            ((UnifiedManualConnectionStep)this$0.getStep()).getStatusBar().hide();
            this$0.getDialogManager().setNextButtonText(RiderDatabaseBundle.message("connect.to.database", new Object[0]));
        } else {
            ((UnifiedManualConnectionStep)this$0.getStep()).getTestConnectionButton().hide();
            ((UnifiedManualConnectionStep)this$0.getStep()).getConnectionStatus().hide();
            Object[] objectArray = new Object[]{((ManualSelectedDriverSession)this$0.getSession()).getDriver().getDisplayName()};
            ConfigurationStatusComponent.showInfo$default(((UnifiedManualConnectionStep)this$0.getStep()).getStatusBar(), RiderDatabaseBundle.message("driver.for.0.will.be.downloaded", objectArray), null, 2, null);
            this$0.getDialogManager().setNextButtonText(RiderDatabaseBundle.message("download.and.connect", new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final Unit entered$lambda$1(IdleState this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((UnifiedManualConnectionStep)this$0.getStep()).beginValidation()) {
            this$0.stateMachine.goTo(StepStates.PerformingTestConnection);
        }
        return Unit.INSTANCE;
    }

    private static final Unit entered$lambda$2(IdleState this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((UnifiedManualConnectionStep)this$0.getStep()).getFixExecutor().executeFix(it);
        return Unit.INSTANCE;
    }

    private static final Unit entered$lambda$3(IdleState this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DatabaseAuthProvider.AuthWidget authWidget = ((ManualSelectedDriverSession)this$0.getSession()).getAuthHandler().getAuthWidget();
        if (authWidget != null) {
            v0 = authWidget.getPreferredFocusedComponent().requestFocusInWindow();
        } else {
            JComponent componentToFocus = ((UnifiedManualConnectionStep)this$0.getStep()).getTestConnectionButton().isVisible() ? (JComponent)((UnifiedManualConnectionStep)this$0.getStep()).getTestConnectionButton().getComponent() : this$0.getDialogManager().getNextButton();
            v0 = componentToFocus.requestFocusInWindow();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StepStates.values().length];
            try {
                nArray[StepStates.PerformingTestConnection.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStates.CreatingDatabaseConnection.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStates.DownloadingDriver.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStates.Idle.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

