/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.session;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.session.ManualSelectedDriverSession;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/session/CustomDataSourceFacade;", "Lcom/intellij/database/dataSource/DataSourceFacade;", "session", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/session/ManualSelectedDriverSession;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/session/ManualSelectedDriverSession;)V", "getTempDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "saveData", "", "dataSource", "copyCredentials", "", "actual", "showErrorNotification", "message", "", "id", "", "getActiveParser", "Lcom/intellij/database/dataSource/url/StatelessJdbcUrlParser;", "getProject", "Lcom/intellij/openapi/project/Project;", "getSecretService", "Lcom/intellij/database/access/DatabaseCredentials;", "getCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "transferSettings", "project", "from", "to", "intellij.rider.plugins.appender"})
public final class CustomDataSourceFacade
implements DataSourceFacade {
    @NotNull
    private final ManualSelectedDriverSession session;

    public CustomDataSourceFacade(@NotNull ManualSelectedDriverSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public LocalDataSource getTempDataSource() {
        return this.session.getDataSource();
    }

    public void saveData(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        LocalDataSource currentDataSource = this.session.getDataSource();
        this.transferSettings(this.getProject(), currentDataSource, dataSource);
        dataSource.getInfo().copyFrom(currentDataSource.getInfo());
    }

    public void showErrorNotification(@Nullable String message, @NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.session.getModel().getMeaningfulParser();
    }

    @NotNull
    public Project getProject() {
        return this.session.getProject();
    }

    @NotNull
    public DatabaseCredentials getSecretService() {
        return this.session.getTempCredentials();
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.session.getScope();
    }

    private final void transferSettings(Project project, LocalDataSource from, LocalDataSource to) {
        String string = LocalDataSourceSerialization.INSTANCE.serializedSettings(project, from).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String settings = string;
        LocalDataSourceSerialization.deserialize((Project)project, (LocalDataSource)to, (Reader)new StringReader(settings));
    }
}

