/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.manual;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialogManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.session.ManualSelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.InitialManualConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.first.FirstManualConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.second.SecondManualConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.steps.unified.UnifiedManualConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.InitialPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.SimplePage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.BalloonCreator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverDownloadingManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Drivers;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.DatagripFixExecutor;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.FixesFactory;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.FixesStorage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.UrlEditorModelProvider;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers.DriversComboBox;
import java.util.Collection;
import javax.swing.JComboBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u00101\u001a\u00020/2\u0006\u0010-\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/ManualConnectionManager;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "initialPage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/InitialPage;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "fixesStorage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesStorage;", "dialogManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialogManager;", "driverDownloadingManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;", "drivers", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/InitialPage;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesStorage;Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialogManager;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;)V", "driversComboBox", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox;", "currentSession", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/session/ManualSelectedDriverSession;", "sequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "modelProvider", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/UrlEditorModelProvider;", "firstPage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/SimplePage;", "secondPage", "initializePageAndSteps", "", "createSessionForDriver", "driver", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "createSession", "previousSession", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "getPage", "index", "", "createSteps", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "session", "shouldUnifySteps", "", "isFirstPageEmpty", "isSecondPageEmpty", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nManualConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualConnectionManager.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/ManualConnectionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1878#2,3:115\n*S KotlinDebug\n*F\n+ 1 ManualConnectionManager.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/ManualConnectionManager\n*L\n66#1:115,3\n*E\n"})
public final class ManualConnectionManager {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final InitialPage initialPage;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final FixesStorage fixesStorage;
    @NotNull
    private final DatabaseConnectionDialogManager dialogManager;
    @NotNull
    private final DriverDownloadingManager driverDownloadingManager;
    @NotNull
    private final Drivers drivers;
    @NotNull
    private final DriversComboBox driversComboBox;
    @Nullable
    private ManualSelectedDriverSession currentSession;
    @NotNull
    private final SequentialLifetimes sequentialLifetimes;
    @NotNull
    private final UrlEditorModelProvider modelProvider;
    @NotNull
    private final SimplePage firstPage;
    @NotNull
    private final SimplePage secondPage;

    public ManualConnectionManager(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull InitialPage initialPage, @NotNull Navigator navigator, @NotNull FixesStorage fixesStorage, @NotNull DatabaseConnectionDialogManager dialogManager, @NotNull DriverDownloadingManager driverDownloadingManager, @NotNull Drivers drivers) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialPage, (String)"initialPage");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)fixesStorage, (String)"fixesStorage");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)driverDownloadingManager, (String)"driverDownloadingManager");
        Intrinsics.checkNotNullParameter((Object)drivers, (String)"drivers");
        this.lifetime = lifetime;
        this.project = project;
        this.initialPage = initialPage;
        this.navigator = navigator;
        this.fixesStorage = fixesStorage;
        this.dialogManager = dialogManager;
        this.driverDownloadingManager = driverDownloadingManager;
        this.drivers = drivers;
        this.driversComboBox = new DriversComboBox(this.project, this.lifetime, this.drivers);
        this.sequentialLifetimes = new SequentialLifetimes(this.lifetime);
        this.modelProvider = new UrlEditorModelProvider();
        this.firstPage = new SimplePage("manual_first");
        this.secondPage = new SimplePage("manual_second");
        SourceExKt.adviseNotNull((ISource)this.driversComboBox.getCurrentDriver().getChange(), (Lifetime)this.lifetime, arg_0 -> ManualConnectionManager._init_$lambda$0(this, arg_0));
    }

    public final void initializePageAndSteps() {
        this.initialPage.addManualStep(new InitialManualConnectionStep(this.lifetime, this.project, this.dialogManager, this.navigator));
        this.navigator.addPage(this.firstPage);
        this.navigator.addPage(this.secondPage);
        this.currentSession = this.createSessionForDriver(this.drivers.getDefaultDriver());
    }

    /*
     * WARNING - void declaration
     */
    private final ManualSelectedDriverSession createSessionForDriver(Driver driver) {
        ManualSelectedDriverSession manualSelectedDriverSession;
        LifetimeDefinition sessionLifetime = this.sequentialLifetimes.next();
        ManualSelectedDriverSession $this$createSessionForDriver_u24lambda_u240 = manualSelectedDriverSession = this.createSession((Lifetime)sessionLifetime, driver, this.currentSession);
        boolean bl = false;
        Collection<DatabaseConnectionStep> steps = this.createSteps((Lifetime)sessionLifetime, $this$createSessionForDriver_u24lambda_u240, this.navigator);
        Iterable $this$forEachIndexed$iv = steps;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void databaseConnectionStep;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DatabaseConnectionStep databaseConnectionStep2 = (DatabaseConnectionStep)item$iv;
            int index = n;
            boolean bl2 = false;
            this.getPage(index).addStep((DatabaseConnectionStep)databaseConnectionStep);
        }
        return manualSelectedDriverSession;
    }

    private final ManualSelectedDriverSession createSession(Lifetime lifetime, Driver driver, SelectedDriverSession previousSession) {
        return new ManualSelectedDriverSession(lifetime, this.project, driver, previousSession, this.driverDownloadingManager, this.modelProvider);
    }

    private final SimplePage getPage(int index) {
        return switch (index) {
            case 0 -> this.firstPage;
            case 1 -> this.secondPage;
            default -> throw new IllegalArgumentException("Attempt was made to get a not existent page");
        };
    }

    private final Collection<DatabaseConnectionStep> createSteps(Lifetime lifetime, ManualSelectedDriverSession session, Navigator navigator) {
        DatagripFixExecutor fixExecutor = new DatagripFixExecutor(this.project, session);
        FixesFactory fixesFactory = new FixesFactory(this.project, session, navigator, fixExecutor);
        BalloonCreator balloonCreator = new BalloonCreator(ConnectionType.Manual, this.fixesStorage, fixesFactory);
        if (this.shouldUnifySteps(session)) {
            return CollectionsKt.listOf((Object)new UnifiedManualConnectionStep(lifetime, this.project, session, (JComboBox)((Object)this.driversComboBox), navigator, this.fixesStorage, fixesFactory, fixExecutor, balloonCreator, this.dialogManager));
        }
        FirstManualConnectionStep first = new FirstManualConnectionStep(lifetime, this.project, session, this.fixesStorage, fixesFactory, this.dialogManager, (JComboBox)((Object)this.driversComboBox), navigator);
        SecondManualConnectionStep second = new SecondManualConnectionStep(lifetime, this.project, session, this.fixesStorage, fixesFactory, fixExecutor, balloonCreator, this.dialogManager, navigator);
        Object[] objectArray = new DatabaseConnectionStep[]{first, second};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean shouldUnifySteps(ManualSelectedDriverSession session) {
        return this.isFirstPageEmpty(session) || this.isSecondPageEmpty(session);
    }

    private final boolean isFirstPageEmpty(ManualSelectedDriverSession session) {
        return session.getConstructorPanel().getFirstPageComponent() == null;
    }

    private final boolean isSecondPageEmpty(ManualSelectedDriverSession session) {
        ManualSelectedDriverSession $this$isSecondPageEmpty_u24lambda_u240 = session;
        boolean bl = false;
        return $this$isSecondPageEmpty_u24lambda_u240.getConstructorPanel().getSecondPageComponent() == null && !$this$isSecondPageEmpty_u24lambda_u240.getAuthHandler().isNeeded();
    }

    private static final Unit _init_$lambda$0(ManualConnectionManager this$0, Driver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ManualSelectedDriverSession manualSelectedDriverSession = this$0.currentSession;
        if (Intrinsics.areEqual((Object)this$0.driversComboBox.getSelectedItem(), (Object)(manualSelectedDriverSession != null ? manualSelectedDriverSession.getDriver() : null))) {
            return Unit.INSTANCE;
        }
        Object object = this$0.driversComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver");
        this$0.currentSession = this$0.createSessionForDriver((Driver)object);
        this$0.navigator.moveTo((DatabaseConnectionStep)CollectionsKt.first((Iterable)((Iterable)this$0.firstPage.getSteps())));
        return Unit.INSTANCE;
    }
}

