/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.fus;

import com.intellij.database.Dbms;
import com.intellij.database.statistic.DatabaseUsagesCollectors;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u001e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u001e\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u001e\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010%\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/fus/RiderDatabaseConnectionDialogStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "CONNECTION_TYPES", "", "", "DIALOG_OPENING_SOURCES", "CONNECTION_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "DIALOG_OPENING_SOURCE", "DBMS", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Lcom/intellij/database/Dbms;", "TEST_CONNECTION_PRESSED", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "CONNECTION_CREATED", "DATAGRIP_FIX_CLICKED", "NAVIGATION_FIX_CLICKED", "DIALOG_OPENED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "logDialogOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "source", "logTestConnection", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "dbms", "logConnectionCreated", "logDatagripFixExecuted", "logNavigationFixExecuted", "getConnectionType", "getOpeningSource", "getGroup", "intellij.rider.plugins.appender"})
public final class RiderDatabaseConnectionDialogStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RiderDatabaseConnectionDialogStatisticsCollector INSTANCE = new RiderDatabaseConnectionDialogStatisticsCollector();
    @JvmField
    @NotNull
    public static final EventLogGroup GROUP = new EventLogGroup("rider.databaseConnectionDialog", 1, null, 4, null);
    @NotNull
    private static final List<String> CONNECTION_TYPES;
    @NotNull
    private static final List<String> DIALOG_OPENING_SOURCES;
    @NotNull
    private static final StringEventField CONNECTION_TYPE;
    @NotNull
    private static final StringEventField DIALOG_OPENING_SOURCE;
    @NotNull
    private static final EventField<Dbms> DBMS;
    @NotNull
    private static final EventId2<String, Dbms> TEST_CONNECTION_PRESSED;
    @NotNull
    private static final EventId2<String, Dbms> CONNECTION_CREATED;
    @NotNull
    private static final EventId2<String, Dbms> DATAGRIP_FIX_CLICKED;
    @NotNull
    private static final EventId2<String, Dbms> NAVIGATION_FIX_CLICKED;
    @NotNull
    private static final EventId1<String> DIALOG_OPENED;

    private RiderDatabaseConnectionDialogStatisticsCollector() {
    }

    public final void logDialogOpened(@NotNull Project project, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DIALOG_OPENED.log(project, (Object)this.getOpeningSource(source));
    }

    public final void logTestConnection(@NotNull Project project, @NotNull ConnectionType connectionType, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        TEST_CONNECTION_PRESSED.log(project, (Object)this.getConnectionType(connectionType), (Object)dbms);
    }

    public final void logConnectionCreated(@NotNull Project project, @NotNull ConnectionType connectionType, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        CONNECTION_CREATED.log(project, (Object)this.getConnectionType(connectionType), (Object)dbms);
    }

    public final void logDatagripFixExecuted(@NotNull Project project, @NotNull ConnectionType connectionType, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        DATAGRIP_FIX_CLICKED.log(project, (Object)this.getConnectionType(connectionType), (Object)dbms);
    }

    public final void logNavigationFixExecuted(@NotNull Project project, @NotNull ConnectionType connectionType, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        NAVIGATION_FIX_CLICKED.log(project, (Object)this.getConnectionType(connectionType), (Object)dbms);
    }

    private final String getConnectionType(ConnectionType connectionType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[connectionType.ordinal()]) {
            case 1 -> "manual";
            case 2 -> "url";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getOpeningSource(String source) {
        if (DIALOG_OPENING_SOURCES.contains(source)) {
            return source;
        }
        return "unknown";
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Object[] objectArray = new String[]{"url", "manual"};
        CONNECTION_TYPES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"popup@DatabaseViewToolbar", "Notification", "MainMenu", "unknown"};
        DIALOG_OPENING_SOURCES = CollectionsKt.listOf((Object[])objectArray);
        CONNECTION_TYPE = EventFields.String((String)"connectionType", CONNECTION_TYPES);
        DIALOG_OPENING_SOURCE = EventFields.String((String)"openingPlace", DIALOG_OPENING_SOURCES);
        DBMS = (EventField)new DatabaseUsagesCollectors.DbmsEventField("dbms");
        TEST_CONNECTION_PRESSED = GROUP.registerEvent("testConnection", (EventField)CONNECTION_TYPE, DBMS);
        CONNECTION_CREATED = GROUP.registerEvent("connectionCreated", (EventField)CONNECTION_TYPE, DBMS);
        DATAGRIP_FIX_CLICKED = GROUP.registerEvent("fix.datagrip.executed", (EventField)CONNECTION_TYPE, DBMS);
        NAVIGATION_FIX_CLICKED = GROUP.registerEvent("fix.navigation.executed", (EventField)CONNECTION_TYPE, DBMS);
        DIALOG_OPENED = GROUP.registerEvent("dialog.opened", (EventField)DIALOG_OPENING_SOURCE);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionType.values().length];
            try {
                nArray[ConnectionType.Manual.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionType.Url.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

