/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.connectionStrings.finders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.finders.JsonSettingsFileConnectionStringsProcessor;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.finders.ProjectConnectionStringsFinder;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/UserSecretsConnectionStringFinder;", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ProjectConnectionStringsFinder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findFilesWithConnectionStrings", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "processFile", "", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/PotentialConnectionString;", "fileWithConnectionStrings", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.rider.plugins.appender"})
public final class UserSecretsConnectionStringFinder
extends ProjectConnectionStringsFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Path userSecretsFolder = SystemInfo.isWindows ? com.jetbrains.rider.plugins.appender.database.connectionStrings.finders.UserSecretsConnectionStringFinder$Companion.access$windowsSecretsFolder(Companion) : com.jetbrains.rider.plugins.appender.database.connectionStrings.finders.UserSecretsConnectionStringFinder$Companion.access$nonWindowsSecretsFolder(Companion);

    public UserSecretsConnectionStringFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected Collection<VirtualFile> findFilesWithConnectionStrings(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)entity.getDescriptor(), (String)"UserSecretsId");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String userSecretsId = string;
        Path pathToUserSecretsFile = userSecretsFolder.resolve(userSecretsId).resolve("secrets.json");
        VirtualFile userSecretsFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(pathToUserSecretsFile);
        if (userSecretsFile == null || !VirtualFileUtil.isFile((VirtualFile)userSecretsFile) || !userSecretsFile.exists()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)userSecretsFile);
    }

    @Override
    @NotNull
    protected List<PotentialConnectionString> processFile(@NotNull PsiFile fileWithConnectionStrings) {
        Intrinsics.checkNotNullParameter((Object)fileWithConnectionStrings, (String)"fileWithConnectionStrings");
        return JsonSettingsFileConnectionStringsProcessor.INSTANCE.processFile(fileWithConnectionStrings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/UserSecretsConnectionStringFinder$Companion;", "", "<init>", "()V", "windowsSecretsFolder", "Ljava/nio/file/Path;", "nonWindowsSecretsFolder", "userSecretsFolder", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        private final Path windowsSecretsFolder() {
            String string = System.getenv("APPDATA");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            String string2 = string;
            String[] stringArray = new String[]{"Microsoft", "UserSecrets"};
            Path path = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        private final Path nonWindowsSecretsFolder() {
            String string = System.getenv("HOME");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            String string2 = string;
            String[] stringArray = new String[]{".microsoft", "usersecrets"};
            Path path = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Path access$windowsSecretsFolder(Companion $this) {
            return $this.windowsSecretsFolder();
        }

        public static final /* synthetic */ Path access$nonWindowsSecretsFolder(Companion $this) {
            return $this.nonWindowsSecretsFolder();
        }
    }
}

