/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.connectionStrings.finders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.finders.ProjectConnectionStringsFinder;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0012H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0012H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ConfigConnectionStringsFinder;", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ProjectConnectionStringsFinder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findFilesWithConnectionStrings", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "processFile", "", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/PotentialConnectionString;", "fileWithConnectionStrings", "Lcom/intellij/psi/PsiFile;", "processConnectionStringsTag", "connectionStringsTag", "Lcom/intellij/psi/xml/XmlTag;", "processConnectionStringsTagWithConfigSource", "baseFile", "processConnectionStringsTagWithConnectionStrings", "getConfigSourceFilePath", "Ljava/nio/file/Path;", "isConnectionStrings", "", "isConnectionStringsWithConfigSource", "getConfigSourceAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nConfigConnectionStringsFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigConnectionStringsFinder.kt\ncom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ConfigConnectionStringsFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n1617#2,9:96\n1869#2:105\n1870#2:107\n1626#2:108\n1563#2:112\n1634#2,2:113\n1636#2:137\n1#3:106\n3919#4:109\n4434#4,2:110\n3260#4,11:115\n3260#4,11:126\n1400#4,2:138\n*S KotlinDebug\n*F\n+ 1 ConfigConnectionStringsFinder.kt\ncom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ConfigConnectionStringsFinder\n*L\n26#1:96,9\n26#1:105\n26#1:107\n26#1:108\n77#1:112\n77#1:113,2\n77#1:137\n26#1:106\n77#1:109\n77#1:110,2\n78#1:115,11\n80#1:126,11\n94#1:138,2\n*E\n"})
final class ConfigConnectionStringsFinder
extends ProjectConnectionStringsFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> CONFIG_FILE_NAMES;

    public ConfigConnectionStringsFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<VirtualFile> findFilesWithConnectionStrings(@NotNull ProjectModelEntity entity) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)entity);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile directory = virtualFile2;
        Iterable $this$mapNotNull$iv = CONFIG_FILE_NAMES;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (directory.findChild(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected List<PotentialConnectionString> processFile(@NotNull PsiFile fileWithConnectionStrings) {
        Intrinsics.checkNotNullParameter((Object)fileWithConnectionStrings, (String)"fileWithConnectionStrings");
        List connectionStrings = new ArrayList();
        fileWithConnectionStrings.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(this, connectionStrings, fileWithConnectionStrings){
            final /* synthetic */ ConfigConnectionStringsFinder this$0;
            final /* synthetic */ List<PotentialConnectionString> $connectionStrings;
            final /* synthetic */ PsiFile $fileWithConnectionStrings;
            {
                this.this$0 = $receiver;
                this.$connectionStrings = $connectionStrings;
                this.$fileWithConnectionStrings = $fileWithConnectionStrings;
            }

            public void visitXmlTag(XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                if (ConfigConnectionStringsFinder.access$isConnectionStrings(this.this$0, tag)) {
                    this.$connectionStrings.addAll(ConfigConnectionStringsFinder.access$processConnectionStringsTag(this.this$0, this.$fileWithConnectionStrings, tag));
                    this.stopWalking();
                } else {
                    super.visitXmlTag(tag);
                }
            }
        });
        return connectionStrings;
    }

    private final Collection<PotentialConnectionString> processConnectionStringsTag(PsiFile fileWithConnectionStrings, XmlTag connectionStringsTag) {
        return this.isConnectionStringsWithConfigSource(connectionStringsTag) ? this.processConnectionStringsTagWithConfigSource(fileWithConnectionStrings, connectionStringsTag) : this.processConnectionStringsTagWithConnectionStrings(connectionStringsTag);
    }

    private final Collection<PotentialConnectionString> processConnectionStringsTagWithConfigSource(PsiFile baseFile, XmlTag connectionStringsTag) {
        Path path = this.getConfigSourceFilePath(baseFile, connectionStringsTag);
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path pathToConfigSource = path;
        VirtualFile configSourceFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(pathToConfigSource);
        if (configSourceFile == null || !VirtualFileUtil.isFile((VirtualFile)configSourceFile) || !configSourceFile.exists()) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(configSourceFile);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile configSourcePsiFile = psiFile;
        if (!(configSourcePsiFile instanceof XmlFile)) {
            return CollectionsKt.emptyList();
        }
        XmlTag xmlTag = ((XmlFile)configSourcePsiFile).getRootTag();
        if (xmlTag == null) {
            return CollectionsKt.emptyList();
        }
        XmlTag rootTag = xmlTag;
        if (!this.isConnectionStrings(rootTag)) {
            return CollectionsKt.emptyList();
        }
        return this.processConnectionStringsTagWithConnectionStrings(rootTag);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PotentialConnectionString> processConnectionStringsTagWithConnectionStrings(XmlTag connectionStringsTag) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        XmlTag[] xmlTagArray = connectionStringsTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        Object[] $this$filter$iv = xmlTagArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (XmlTag element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag it = element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLocalName(), (Object)"add")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object object2;
            Object connectionString;
            Collection collection;
            block9: {
                Object object3;
                Object object4;
                void addTag;
                block8: {
                    XmlTag element$iv$iv;
                    element$iv$iv = (XmlTag)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    XmlAttribute[] xmlAttributeArray = addTag.getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
                    Object[] $this$singleOrNull$iv = xmlAttributeArray;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv = $this$singleOrNull$iv[i];
                        XmlAttribute it = (XmlAttribute)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getLocalName(), (Object)"connectionString")) continue;
                        if (found$iv) {
                            object4 = null;
                            break block8;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    object4 = !found$iv ? null : single$iv;
                }
                if ((object3 = (XmlAttribute)object4) == null || (object3 = object3.getValueElement()) == null || (object3 = object3.getValue()) == null) {
                    return CollectionsKt.emptyList();
                }
                connectionString = object3;
                XmlAttribute[] xmlAttributeArray = addTag.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
                Object[] $this$singleOrNull$iv = xmlAttributeArray;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    XmlAttribute it = (XmlAttribute)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getLocalName(), (Object)"providerName")) continue;
                    if (found$iv) {
                        object2 = null;
                        break block9;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                object2 = !found$iv ? null : single$iv;
            }
            if ((object = (XmlAttribute)object2) == null || (object = object.getValueElement()) == null || (object = object.getValue()) == null) {
                return CollectionsKt.emptyList();
            }
            Object providerName = object;
            DotnetDataProvider provider = DotnetDataProvider.Companion.byName((String)providerName, this.getProject());
            collection.add(new PotentialConnectionString((String)connectionString, provider));
        }
        return (List)destination$iv$iv;
    }

    private final Path getConfigSourceFilePath(PsiFile baseFile, XmlTag connectionStringsTag) {
        Object object = this.getConfigSourceAttribute(connectionStringsTag);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object configSourceFilePath = object;
        String string = baseFile.getVirtualFile().getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = Paths.get((String)configSourceFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path.resolve(path2);
    }

    private final boolean isConnectionStrings(XmlTag $this$isConnectionStrings) {
        return Intrinsics.areEqual((Object)$this$isConnectionStrings.getLocalName(), (Object)"connectionStrings");
    }

    private final boolean isConnectionStringsWithConfigSource(XmlTag $this$isConnectionStringsWithConfigSource) {
        return this.getConfigSourceAttribute($this$isConnectionStringsWithConfigSource) != null;
    }

    private final XmlAttribute getConfigSourceAttribute(XmlTag $this$getConfigSourceAttribute) {
        Object object;
        block1: {
            XmlAttribute[] xmlAttributeArray = $this$getConfigSourceAttribute.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
            Object[] $this$firstOrNull$iv = xmlAttributeArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XmlAttribute it = (XmlAttribute)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocalName(), (Object)"configSource")) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (XmlAttribute)object;
    }

    public static final /* synthetic */ boolean access$isConnectionStrings(ConfigConnectionStringsFinder $this, XmlTag $receiver) {
        return $this.isConnectionStrings($receiver);
    }

    public static final /* synthetic */ Collection access$processConnectionStringsTag(ConfigConnectionStringsFinder $this, PsiFile fileWithConnectionStrings, XmlTag connectionStringsTag) {
        return $this.processConnectionStringsTag(fileWithConnectionStrings, connectionStringsTag);
    }

    static {
        Object[] objectArray = new String[]{"app.config", "web.config"};
        CONFIG_FILE_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/finders/ConfigConnectionStringsFinder$Companion;", "", "<init>", "()V", "CONFIG_FILE_NAMES", "", "", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

