/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database;

import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.ConnectionStringsProvider;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import java.awt.event.ActionEvent;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/RiderDatabaseViewPanel;", "Lcom/intellij/database/view/DatabaseViewPanel;", "project", "Lcom/intellij/openapi/project/Project;", "options", "Lcom/intellij/database/view/structure/DvMutableViewOptions;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvMutableViewOptions;)V", "updateEmptyText", "", "intellij.rider.plugins.appender"})
public final class RiderDatabaseViewPanel
extends DatabaseViewPanel {
    public RiderDatabaseViewPanel(@NotNull Project project, @NotNull DvMutableViewOptions options) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(project, options);
    }

    protected void updateEmptyText() {
        StatusText statusText = this.getMyTree().getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        StatusText emptyText = statusText;
        emptyText.clear();
        Collection<PotentialConnectionString> connectionStrings = ConnectionStringsProvider.Companion.getInstance(this.getProject()).getConnectionStrings();
        if (connectionStrings.isEmpty()) {
            v1 = emptyText.appendLine(RiderDatabaseBundle.message("status.text.no.databases.connected", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES, null);
        } else {
            Object[] objectArray = new Object[]{connectionStrings.size()};
            v1 = emptyText.appendLine(RiderDatabaseBundle.message("status.text.connection.strings.were.found.in.project", objectArray), SimpleTextAttributes.GRAY_ATTRIBUTES, null);
        }
        emptyText.appendLine(RiderDatabaseBundle.message("status.text.connect.to.database", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> RiderDatabaseViewPanel.updateEmptyText$lambda$0(this, arg_0));
    }

    private static final void updateEmptyText$lambda$0(RiderDatabaseViewPanel this$0, ActionEvent it) {
        AnAction action = ActionManager.getInstance().getAction("rider.connectToDatabase");
        DataContext dataContext = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.PROJECT, (Object)this$0.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getSimpleContext(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"DatabaseViewToolbar", (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
    }
}

