/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.sentence;

import ai.grazie.Direction;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.patterns.standard.StrictPatterns;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.rule.PatternSplitTokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.nlp.utils.normalization.UnicodePunctuationNormalizer;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.text.exclusions.ExclusionUtilsKt;
import ai.grazie.text.exclusions.IExclusion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0015\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0013\u001a\u00020\u0017J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0013\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Lai/grazie/nlp/tokenizer/Tokenizer;", "splitByNewLinesNumber", "", "language", "Lai/grazie/nlp/langs/Language;", "<init>", "(Ljava/lang/Integer;Lai/grazie/nlp/langs/Language;)V", "(Ljava/lang/Integer;)V", "newLineTokenizer", "Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "ignore", "Lai/grazie/nlp/patterns/AggregatedPattern;", "punctuationTokenizer", "newLinesPattern", "Lai/grazie/nlp/patterns/Pattern;", "tokenize", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "text", "Lai/grazie/text/Text;", "tokenRanges", "Lai/grazie/text/TextRange;", "", "adjustByExclusions", "ranges", "exclusions", "Lai/grazie/text/exclusions/IExclusion;", "Companion", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nStandardSentenceTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1557#2:212\n1628#2,2:213\n1611#2,9:215\n1863#2:224\n1864#2:226\n1620#2:227\n1630#2:228\n1368#2:229\n1454#2,2:230\n1557#2:232\n1628#2,3:233\n1456#2,3:236\n1202#2,2:239\n1230#2,4:241\n1#3:225\n1#3:245\n*S KotlinDebug\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n*L\n174#1:212\n174#1:213,2\n175#1:215,9\n175#1:224\n175#1:226\n175#1:227\n174#1:228\n183#1:229\n183#1:230,2\n184#1:232\n184#1:233,3\n183#1:236,3\n194#1:239,2\n194#1:241,4\n175#1:225\n*E\n"})
public final class StandardSentenceTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PatternSplitTokenizer newLineTokenizer;
    @NotNull
    private final AggregatedPattern ignore;
    @NotNull
    private final PatternSplitTokenizer punctuationTokenizer;
    @NotNull
    private static final String quotes = "'\"`\u2018\u2019" + CollectionsKt.joinToString$default((Iterable)UnicodePunctuationNormalizer.Companion.getDoubleQuotes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    @NotNull
    private static final Pattern Parenthetical;
    @NotNull
    private static final Companion.Ellipsis.1.1 Ellipsis;
    @NotNull
    private static final Pattern QuotedStuff;
    @NotNull
    private static final String normalSentenceEnd;
    @NotNull
    private static final String romanBullet;
    @NotNull
    private static final String bulletContents = "[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*";
    @NotNull
    private static final String braceBullet = "(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\])";
    @NotNull
    private static final String spaceOrEnd = "\n+|\\s+|$";
    @NotNull
    private static final Regex sentenceContinuation;
    @NotNull
    private static final Companion.endPunctuation.1 endPunctuation;
    @NotNull
    private static final Pattern nextLineStartsWithBullet;
    @NotNull
    private static final StandardSentenceTokenizer Default;

    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.newLineTokenizer = splitByNewLinesNumber == null ? null : new PatternSplitTokenizer(this.newLinesPattern(splitByNewLinesNumber), Direction.Right, null);
        Object[] objectArray = new Pattern[]{Parenthetical, Ellipsis, QuotedStuff, LikelyPatterns.NameInitials, LikelyPatterns.PunctuationOperator, LikelyPatterns.IsEmail, AbbreviationPatterns.forSentenceTokenization(language), language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanOrdinal : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanOrdinalAfterNames : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanDateWithDot : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanStreetName : null, LikelyPatterns.IsIPv4, LikelyPatterns.IsURL, LikelyPatterns.IsFilePath, StrictPatterns.INSTANCE.getIsUUID(), LikelyPatterns.IsDotInBashCommand, LikelyPatterns.IsInnerSentenceInQuotes};
        this.ignore = new AggregatedPattern(CollectionsKt.listOfNotNull((Object[])objectArray));
        objectArray = new Pattern[]{endPunctuation, nextLineStartsWithBullet};
        this.punctuationTokenizer = new PatternSplitTokenizer(new AggregatedPattern((Pattern[])objectArray), Direction.Right, this.ignore);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, Language language, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n, language);
    }

    @Deprecated(message="Specify the language")
    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber) {
        this(splitByNewLinesNumber, Language.UNKNOWN);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    private final Pattern newLinesPattern(int splitByNewLinesNumber) {
        return new RegexPattern("\n{" + splitByNewLinesNumber + ",}").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)StandardSentenceTokenizer::newLinesPattern$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Iterable $this$map$iv = this.tokenRanges(text2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range;
            void $this$mapNotNullTo$iv$iv;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = ExclusionUtilsKt.getExclusions(text2);
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IExclusion it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                IExclusion it = (IExclusion)element$iv$iv;
                boolean bl3 = false;
                if (it.restrictToRange(range.getStart(), range.getEndExclusive()) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List subExclusions = (List)destination$iv$iv2;
            collection.add(new Tokenizer.Token(ExclusionUtilsKt.withExclusions(text2.substring((TextRange)range), subExclusions), (TextRange)range));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text2) {
        List exclusions;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Object object = this.newLineTokenizer;
        if (object == null || (object = ((PatternSplitTokenizer)object).tokenRanges(text2)) == null) {
            object = CollectionsKt.listOf((Object)new TextRange(0, text2.length()));
        }
        Object hard = object;
        Iterable $this$flatMap$iv = (Iterable)hard;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRange chunk = (TextRange)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.punctuationTokenizer.tokenRanges(text2.subSequence(chunk.getStart(), chunk.getEndExclusive()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ExtensionsKt.withOffset((TextRange)it, chunk.getStart()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        Text text3 = text2 instanceof Text ? (Text)text2 : null;
        List list = text3 != null ? ExclusionUtilsKt.getExclusions(text3) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(exclusions = list)).isEmpty()) {
            return this.adjustByExclusions(text2, result2, exclusions);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> adjustByExclusions(CharSequence text2, List<TextRange> ranges, List<? extends IExclusion> exclusions) {
        Object object;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = exclusions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            object = (IExclusion)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getOffset(), element$iv$iv);
        }
        Map map3 = destination$iv$iv;
        int i = 1;
        ArrayList<TextRange> adjusted = new ArrayList<TextRange>((Collection)ranges);
        int n = CollectionsKt.getLastIndex((List)adjusted);
        if (i <= n) {
            while (true) {
                Object v2;
                TextRange curr;
                TextRange prev;
                block6: {
                    int trimmedEnd;
                    prev = (TextRange)adjusted.get(i - 1);
                    curr = (TextRange)adjusted.get(i);
                    for (trimmedEnd = prev.getEndExclusive(); trimmedEnd > prev.getStart() && CharsKt.isWhitespace((char)text2.charAt(trimmedEnd - 1)); --trimmedEnd) {
                    }
                    object = (Iterable)new IntRange(trimmedEnd, curr.getStart());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        int it = ((Number)t).intValue();
                        boolean bl = false;
                        IExclusion iExclusion = (IExclusion)map3.get(it);
                        boolean bl2 = iExclusion != null ? iExclusion.isUnknown() : false;
                        if (!bl2) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                Integer adjustedEnd = v2;
                if (adjustedEnd != null) {
                    adjusted.set(i - 1, new TextRange(prev.getStart(), adjustedEnd));
                    adjusted.set(i, new TextRange(adjustedEnd, curr.getEndExclusive()));
                }
                if (i == n) break;
                ++i;
            }
        }
        return adjusted;
    }

    private static final List newLinesPattern$lambda$0(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List Parenthetical$lambda$7(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List QuotedStuff$lambda$9(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    @JvmStatic
    @NotNull
    public static final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
        return Companion.defaultFor(language);
    }

    public static final /* synthetic */ String access$getQuotes$cp() {
        return quotes;
    }

    public static final /* synthetic */ String access$getNormalSentenceEnd$cp() {
        return normalSentenceEnd;
    }

    public static final /* synthetic */ String access$getRomanBullet$cp() {
        return romanBullet;
    }

    public static final /* synthetic */ Regex access$getSentenceContinuation$cp() {
        return sentenceContinuation;
    }

    static {
        Pattern[] patternArray = new Pattern[]{StandardSentenceTokenizer.Companion.pairedParentheses(), StandardSentenceTokenizer.Companion.pairedDashes()};
        Parenthetical = new AggregatedPattern(patternArray).traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)StandardSentenceTokenizer::Parenthetical$lambda$7));
        Companion $this$Ellipsis_u24lambda_u248 = Companion;
        boolean bl = false;
        Ellipsis = new Pattern(){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int n = text2.length();
                for (int i = 0; i < n; ++i) {
                    if (text2.charAt(i) == '.' && i < text2.length() - 2 && text2.charAt(i + 2) == '.') {
                        int end;
                        if (this.isSpacedEllipsis(i, text2)) {
                            result2.add(new TextRange(i, i + 5));
                            continue;
                        }
                        if (text2.charAt(i + 1) != '.') continue;
                        for (end = i + 3; end < text2.length() && text2.charAt(end) == '.'; ++end) {
                        }
                        if (!this.isEllipsisMatch(i, end, text2)) continue;
                        result2.add(new TextRange(i, end));
                        continue;
                    }
                    if (text2.charAt(i) != '\u2026' || !this.isEllipsisMatch(i, i + 1, text2)) continue;
                    result2.add(new TextRange(i, i + 1));
                }
                return result2;
            }

            private final boolean isSpacedEllipsis(int i, CharSequence text2) {
                return i + 4 < text2.length() && text2.charAt(i + 4) == '.' && CharsKt.isWhitespace((char)text2.charAt(i + 1)) && CharsKt.isWhitespace((char)text2.charAt(i + 3));
            }

            private final boolean isEllipsisMatch(int start, int end, CharSequence text2) {
                return this.isForOmittedSentenceParts(start, end, text2) || this.isActionNameEllipsis(start, end, text2);
            }

            private final boolean isActionNameEllipsis(int start, int end, CharSequence text2) {
                return start > 0 && Character.isLetter(text2.charAt(start - 1)) && end + 1 < text2.length() && CharsKt.isWhitespace((char)text2.charAt(end)) && Character.isLowerCase(text2.charAt(end + 1));
            }

            private final boolean isForOmittedSentenceParts(int start, int end, CharSequence text2) {
                return (start == 0 || CharsKt.isWhitespace((char)text2.charAt(start - 1)) || StringsKt.contains$default((CharSequence)StandardSentenceTokenizer.access$getQuotes$cp(), (char)text2.charAt(start - 1), (boolean)false, (int)2, null)) && (end == text2.length() || CharsKt.isWhitespace((char)text2.charAt(end)) || StringsKt.contains$default((CharSequence)StandardSentenceTokenizer.access$getQuotes$cp(), (char)text2.charAt(end), (boolean)false, (int)2, null)) || start > 0 && end < text2.length() && text2.charAt(start - 1) == '[' && text2.charAt(end) == ']';
            }
        };
        QuotedStuff = new RegexPattern("[" + quotes + "]([\\p{L}\\s\\d]{1,42}(\\.{3,}|\u2026)[" + quotes + "]\\s+\\p{Ll}|\\p{L}+\\.[" + quotes + "]([,;:]|\\s+\\p{Ll})|[^\\s\\p{L}]*[" + quotes + "])").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)StandardSentenceTokenizer::QuotedStuff$lambda$9));
        normalSentenceEnd = "[?!.]+[)}\\]" + quotes + "]?";
        String string = "IVXLMCD".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        romanBullet = "(^|\n)([IVXLMCD]{1,4}|[" + string + "]{1,4})\\)";
        Companion $this$sentenceContinuation_u24lambda_u2410 = Companion;
        boolean bl2 = false;
        String dashes = "(\\s+[-\u2013\u2014]+)";
        String emotionalPunctuation = "([?!]\\.*|([:;]-?[()]+))";
        String directSpeechEnd = "(\\?[" + quotes + "]|!(\\.+[" + quotes + "]?|\\.*[" + quotes + "])|\\.{3,}[" + quotes + "?]*)";
        sentenceContinuation = new Regex("(" + directSpeechEnd + dashes + "?|" + emotionalPunctuation + dashes + ")\\s+([\\[({<])?\\p{Ll}");
        endPunctuation = new Pattern(){
            private final char[] startChars;
            private final Regex regex;
            {
                char[] cArray = "?!.:;\n".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                this.startChars = cArray;
                this.regex = new Regex("(" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + "|" + StandardSentenceTokenizer.access$getRomanBullet$cp() + "|(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\]))(\n+|\\s+|$)|([:;]-?[()]+)(\n+|\\s+|$|" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + ")+");
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                int offset = 0;
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                while (offset >= 0) {
                    MatchResult mr = this.regex.matchAt(text2, offset);
                    if (mr != null) {
                        if (!StandardSentenceTokenizer.access$getSentenceContinuation$cp().matchesAt(text2, offset)) {
                            result2.add(TextRange.Companion.invoke(mr.getRange()));
                        }
                        offset = mr.getRange().getLast() + 1;
                    }
                    offset = StringsKt.indexOfAny$default((CharSequence)text2, (char[])this.startChars, (int)(offset + 1), (boolean)false, (int)4, null);
                }
                return result2;
            }
        };
        nextLineStartsWithBullet = new RegexPattern(new Regex("\n")).before(new Regex("[ \\t]*[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\.\\s+\\S"));
        Default = new StandardSentenceTokenizer(2, Language.UNKNOWN);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\b\b*\u0002\u0010\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion;", "", "<init>", "()V", "defaultFor", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "language", "Lai/grazie/nlp/langs/Language;", "quotes", "", "Parenthetical", "Lai/grazie/nlp/patterns/Pattern;", "pairedParentheses", "Lai/grazie/nlp/patterns/RegexPattern;", "pairedDashes", "Ellipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1$1;", "QuotedStuff", "normalSentenceEnd", "romanBullet", "bulletContents", "braceBullet", "spaceOrEnd", "sentenceContinuation", "Lkotlin/text/Regex;", "endPunctuation", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1;", "nextLineStartsWithBullet", "Default", "getDefault$annotations", "getDefault", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "nlp-tokenizer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            return new StandardSentenceTokenizer(2, language);
        }

        private final RegexPattern pairedParentheses() {
            String noParentheses = "[^()]";
            String nestedParentheses = "\\(" + noParentheses + "{1,500}\\)" + noParentheses + "{0,500}";
            return new RegexPattern(new Regex("\\(" + noParentheses + "{1,500}(" + nestedParentheses + ")*\\)"));
        }

        private final Pattern pairedDashes() {
            Regex dashRegex = new Regex("\\s+[-\u2013\u2014]+\\s+([^-\u2013\u2014]{1,100})\\s+[-\u2013\u2014]+\\s+");
            Regex smileyRegex = new Regex("[:;]-?[()]+");
            return new RegexPattern(dashRegex, smileyRegex){
                final /* synthetic */ Regex $dashRegex;
                final /* synthetic */ Regex $smileyRegex;
                {
                    this.$dashRegex = $dashRegex;
                    this.$smileyRegex = $smileyRegex;
                    super($dashRegex);
                }

                /*
                 * WARNING - void declaration
                 */
                public List<TextRange> find(CharSequence text2) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                    Iterable iterable = super.find(text2);
                    Regex regex = this.$dashRegex;
                    Regex regex2 = this.$smileyRegex;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TextRange it = (TextRange)element$iv$iv;
                        boolean bl = false;
                        CharSequence withDashes = text2.subSequence(it.getStart(), it.getEndExclusive());
                        MatchResult matchResult = regex.matchEntire(withDashes);
                        Intrinsics.checkNotNull((Object)matchResult);
                        String withoutDashes = (String)matchResult.getGroupValues().get(1);
                        if (!(Regex.find$default((Regex)regex2, (CharSequence)withoutDashes, (int)0, (int)2, null) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            };
        }

        @NotNull
        public final StandardSentenceTokenizer getDefault() {
            return Default;
        }

        @Deprecated(message="Use defaultFor with a language")
        public static /* synthetic */ void getDefault$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

