/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.parsing;

import com.jetbrains.jdbc.sqlserver.parsing.ParseResult;
import com.jetbrains.jdbc.sqlserver.parsing.ProcedureNameParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/TsqlSyntaxParser;", "", "()V", "sqlExecSyntax", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "sqlIdentifierPart", "", "sqlIdentifierWithoutGroups", "parse", "Lcom/jetbrains/jdbc/sqlserver/parsing/ParseResult;", "sql", "Frontend"})
public final class TsqlSyntaxParser {
    @NotNull
    public static final TsqlSyntaxParser INSTANCE = new TsqlSyntaxParser();
    @NotNull
    private static final String sqlIdentifierPart = "(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))";
    @NotNull
    private static final String sqlIdentifierWithoutGroups = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)";
    private static final Pattern sqlExecSyntax = Pattern.compile("\\s*?[eE][xX][eE][cC](?:[uU][tT][eE])??\\s+?(((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)\\s*?=\\s+?)??((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:$|(?:\\s+?.*+))");

    private TsqlSyntaxParser() {
    }

    @NotNull
    public final ParseResult parse(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        Matcher matcher = sqlExecSyntax.matcher(sql);
        if (matcher.matches()) {
            boolean hasReturnValueSyntax = matcher.group(1) != null;
            String procedureName = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue(procedureName, "procedureName");
            return new ParseResult.Success(sql, hasReturnValueSyntax, ProcedureNameParser.INSTANCE.parse(procedureName));
        }
        return ParseResult.Failure.INSTANCE;
    }
}

