/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.parsing;

import com.jetbrains.jdbc.sqlserver.parsing.ParseResult;
import com.jetbrains.jdbc.sqlserver.parsing.ProcedureNameParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\"\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/JdbcSyntaxParser;", "", "()V", "jdbcCallSyntax", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "sqlIdentifierPart", "", "sqlIdentifierWithoutGroups", "parse", "Lcom/jetbrains/jdbc/sqlserver/parsing/ParseResult;", "sql", "rewriteToTSQL", "hasReturnValueSyntax", "", "procedureName", "arguments", "Frontend"})
public final class JdbcSyntaxParser {
    @NotNull
    public static final JdbcSyntaxParser INSTANCE = new JdbcSyntaxParser();
    @NotNull
    private static final String sqlIdentifierPart = "(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))";
    @NotNull
    private static final String sqlIdentifierWithoutGroups = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)";
    private static final Pattern jdbcCallSyntax = Pattern.compile("(?s)\\s*?\\{\\s*?(\\?\\s*?=)?\\s*?[cC][aA][lL][lL]\\s+?((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:\\s*?\\((.*)\\))?\\s*\\}.*+");

    private JdbcSyntaxParser() {
    }

    @NotNull
    public final ParseResult parse(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        Matcher matcher = jdbcCallSyntax.matcher(sql);
        if (matcher.matches()) {
            boolean hasReturnValueSyntax = matcher.group(1) != null;
            String procedureName = matcher.group(2);
            String args2 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue(procedureName, "procedureName");
            String tSql = this.rewriteToTSQL(hasReturnValueSyntax, procedureName, args2);
            return new ParseResult.Success(tSql, hasReturnValueSyntax, ProcedureNameParser.INSTANCE.parse(procedureName));
        }
        return ParseResult.Failure.INSTANCE;
    }

    private final String rewriteToTSQL(boolean hasReturnValueSyntax, String procedureName, String arguments2) {
        CharSequence charSequence = arguments2;
        return "EXEC " + (hasReturnValueSyntax ? "? = " : "") + procedureName + (String)(!(charSequence == null || charSequence.length() == 0) ? " " + arguments2 : "");
    }
}

