/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.factories;

import com.jetbrains.jdbc.base.connections.ProtocolConnection;
import com.jetbrains.jdbc.base.conversions.get.ValueGetter;
import com.jetbrains.jdbc.base.conversions.set.ValueSetter;
import com.jetbrains.jdbc.base.factories.IParametersFactory;
import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdBasicStatement;
import com.jetbrains.jdbc.base.models.RdBasicStatementInitialState;
import com.jetbrains.jdbc.base.models.RdCallableStatement;
import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.models.RdConnectionInitialState;
import com.jetbrains.jdbc.base.models.RdDatabaseMetadata;
import com.jetbrains.jdbc.base.models.RdPreparedStatement;
import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.models.RdResultSetInitialState;
import com.jetbrains.jdbc.base.models.RdStatementWithParamsInitialState;
import com.jetbrains.jdbc.base.resultsets.ProtocolResultSet;
import com.jetbrains.jdbc.base.resultsets.ProtocolResultSetMetaData;
import com.jetbrains.jdbc.base.resultsets.cursors.Cursor;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.base.statements.ProtocolBasicStatement;
import com.jetbrains.jdbc.base.statements.ProtocolCallableStatement;
import com.jetbrains.jdbc.base.statements.ProtocolPreparedStatement;
import com.jetbrains.jdbc.base.statements.parameters.ProtocolParameterMetadata;
import com.jetbrains.jdbc.base.statements.parameters.StatementParameters;
import com.jetbrains.jdbc.base.utils.protocol.initialization.BasicStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.CalledStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ConnectionInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ParameterInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.PreparedStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ResultSetInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.BasicStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.CallableStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.ICallableStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IPreparedStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.PreparedStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.StatementParameterPool;
import com.jetbrains.jdbc.sqlserver.SqlServerDatabaseMetadata;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToJavaTypeTranslator;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.SqlServerStatementParser;
import com.jetbrains.jdbc.sqlserver.converters.ConvertersKt;
import com.jetbrains.jdbc.sqlserver.factories.SqlServerCursorFactory;
import com.jetbrains.jdbc.sqlserver.factories.SqlServerParametersFactory;
import com.jetbrains.jdbc.sqlserver.factories.SqlServerRowsAndColumnsFactory;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00100\u001a\u000201H\u0016J \u00105\u001a\u0002062\u0006\u0010)\u001a\u00020*2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u000201H\u0016J.\u00109\u001a\u00020:2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020;2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0016J\"\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010?\u001a\u00020EH\u0016J \u0010F\u001a\u00020B2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020G2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010-\u001a\u00020JH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\b\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\b\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\b\u001a\u0004\b \u0010!R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerFactory;", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "()V", "basicStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/BasicStatementPool;", "getBasicStatementPool", "()Lcom/jetbrains/jdbc/base/utils/protocol/pooling/BasicStatementPool;", "basicStatementPool$delegate", "Lkotlin/Lazy;", "callableStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/CallableStatementPool;", "getCallableStatementPool", "()Lcom/jetbrains/jdbc/base/utils/protocol/pooling/CallableStatementPool;", "callableStatementPool$delegate", "cursorFactory", "Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerCursorFactory;", "jdbcModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "parametersFactory", "Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerParametersFactory;", "getParametersFactory", "()Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerParametersFactory;", "parametersFactory$delegate", "preparedStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/PreparedStatementPool;", "getPreparedStatementPool", "()Lcom/jetbrains/jdbc/base/utils/protocol/pooling/PreparedStatementPool;", "preparedStatementPool$delegate", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerRowsAndColumnsFactory;", "statementParameterPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/StatementParameterPool;", "getStatementParameterPool", "()Lcom/jetbrains/jdbc/base/utils/protocol/pooling/StatementParameterPool;", "statementParameterPool$delegate", "valueGetter", "Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;", "valueSetter", "Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;", "createCallableStatement", "Ljava/sql/CallableStatement;", "connection", "Ljava/sql/Connection;", "rdStatement", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/CalledStatementInitializationData;", "parameters", "", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ParameterInitializationData;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createConnection", "rdConnection", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ConnectionInitializationData;", "createDatabaseMetadata", "Ljava/sql/DatabaseMetaData;", "rdDatabaseMetadata", "Lcom/jetbrains/jdbc/base/models/RdDatabaseMetadata;", "createPreparedStatement", "Ljava/sql/PreparedStatement;", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/PreparedStatementInitializationData;", "createResultSet", "Ljava/sql/ResultSet;", "lifetime", "rdResultSet", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ResultSetInitializationData;", "parentStatement", "Ljava/sql/Statement;", "createResultSetMetadata", "Ljava/sql/ResultSetMetaData;", "Lcom/jetbrains/jdbc/base/models/RdResultSet;", "createStatement", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/BasicStatementInitializationData;", "createStatementParameterMetadata", "Ljava/sql/ParameterMetaData;", "Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;", "Frontend"})
public final class SqlServerFactory
implements JdbcFactory {
    private JdbcModel jdbcModel;
    @NotNull
    private final ValueGetter valueGetter = new ValueGetter(ConvertersKt.createGetValueConverterProvider());
    @NotNull
    private final ValueSetter valueSetter = new ValueSetter(ConvertersKt.createSetValueConverterProvider());
    @NotNull
    private final SqlServerRowsAndColumnsFactory rowsAndColumnsFactory = new SqlServerRowsAndColumnsFactory(this.valueGetter, this.valueSetter);
    @NotNull
    private final SqlServerCursorFactory cursorFactory = new SqlServerCursorFactory(this.rowsAndColumnsFactory);
    @NotNull
    private final Lazy basicStatementPool$delegate = LazyKt.lazy((Function0)new Function0<BasicStatementPool>(this){
        final /* synthetic */ SqlServerFactory this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final BasicStatementPool invoke() {
            JdbcModel jdbcModel2 = SqlServerFactory.access$getJdbcModel$p(this.this$0);
            if (jdbcModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
                jdbcModel2 = null;
            }
            return new BasicStatementPool(jdbcModel2, 10);
        }
    });
    @NotNull
    private final Lazy preparedStatementPool$delegate = LazyKt.lazy((Function0)new Function0<PreparedStatementPool>(this){
        final /* synthetic */ SqlServerFactory this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final PreparedStatementPool invoke() {
            JdbcModel jdbcModel2 = SqlServerFactory.access$getJdbcModel$p(this.this$0);
            if (jdbcModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
                jdbcModel2 = null;
            }
            return new PreparedStatementPool(jdbcModel2, 10);
        }
    });
    @NotNull
    private final Lazy callableStatementPool$delegate = LazyKt.lazy((Function0)new Function0<CallableStatementPool>(this){
        final /* synthetic */ SqlServerFactory this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final CallableStatementPool invoke() {
            JdbcModel jdbcModel2 = SqlServerFactory.access$getJdbcModel$p(this.this$0);
            if (jdbcModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
                jdbcModel2 = null;
            }
            return new CallableStatementPool(jdbcModel2, 10);
        }
    });
    @NotNull
    private final Lazy statementParameterPool$delegate = LazyKt.lazy((Function0)new Function0<StatementParameterPool>(this){
        final /* synthetic */ SqlServerFactory this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final StatementParameterPool invoke() {
            JdbcModel jdbcModel2 = SqlServerFactory.access$getJdbcModel$p(this.this$0);
            if (jdbcModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
                jdbcModel2 = null;
            }
            return new StatementParameterPool(jdbcModel2, 10);
        }
    });
    @NotNull
    private final Lazy parametersFactory$delegate = LazyKt.lazy((Function0)new Function0<SqlServerParametersFactory>(this){
        final /* synthetic */ SqlServerFactory this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final SqlServerParametersFactory invoke() {
            return new SqlServerParametersFactory(SqlServerFactory.access$getValueGetter$p(this.this$0), SqlServerFactory.access$getValueSetter$p(this.this$0), SqlServerFactory.access$getStatementParameterPool(this.this$0));
        }
    });

    private final BasicStatementPool getBasicStatementPool() {
        Lazy lazy = this.basicStatementPool$delegate;
        return (BasicStatementPool)lazy.getValue();
    }

    private final PreparedStatementPool getPreparedStatementPool() {
        Lazy lazy = this.preparedStatementPool$delegate;
        return (PreparedStatementPool)lazy.getValue();
    }

    private final CallableStatementPool getCallableStatementPool() {
        Lazy lazy = this.callableStatementPool$delegate;
        return (CallableStatementPool)lazy.getValue();
    }

    private final StatementParameterPool getStatementParameterPool() {
        Lazy lazy = this.statementParameterPool$delegate;
        return (StatementParameterPool)lazy.getValue();
    }

    private final SqlServerParametersFactory getParametersFactory() {
        Lazy lazy = this.parametersFactory$delegate;
        return (SqlServerParametersFactory)lazy.getValue();
    }

    @Override
    @NotNull
    public Connection createConnection(@NotNull ConnectionInitializationData rdConnection, @NotNull JdbcModel jdbcModel2, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(rdConnection, "rdConnection");
        Intrinsics.checkNotNullParameter(jdbcModel2, "jdbcModel");
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        this.jdbcModel = jdbcModel2;
        return new ProtocolConnection((RdConnection)rdConnection.getModel(), (RdConnectionInitialState)rdConnection.getInitialState(), parentLifetime.createNested(), this, this.getBasicStatementPool(), this.getPreparedStatementPool(), this.getCallableStatementPool(), this.getStatementParameterPool(), SqlServerStatementParser.INSTANCE);
    }

    @Override
    @NotNull
    public DatabaseMetaData createDatabaseMetadata(@NotNull Connection connection, @NotNull RdDatabaseMetadata rdDatabaseMetadata, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(rdDatabaseMetadata, "rdDatabaseMetadata");
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        LifetimeDefinition lifetimeDefinition = parentLifetime.createNested();
        JdbcModel jdbcModel2 = this.jdbcModel;
        if (jdbcModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
            jdbcModel2 = null;
        }
        return new SqlServerDatabaseMetadata(lifetimeDefinition, connection, rdDatabaseMetadata, jdbcModel2, this);
    }

    @Override
    @NotNull
    public ResultSet createResultSet(@NotNull Lifetime lifetime, @NotNull ResultSetInitializationData rdResultSet, @Nullable Statement parentStatement) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(rdResultSet, "rdResultSet");
        LifetimeDefinition resultSetLifetimeDefinition = lifetime.createNested();
        Cursor cursor = this.cursorFactory.createCursor((RdResultSet)rdResultSet.getModel(), ((RdResultSetInitialState)rdResultSet.getInitialState()).getCursorType(), ((RdResultSetInitialState)rdResultSet.getInitialState()).getConcurrency(), ((RdResultSetInitialState)rdResultSet.getInitialState()).getInitialRowsCount(), resultSetLifetimeDefinition.getLifetime());
        return new ProtocolResultSet(resultSetLifetimeDefinition, parentStatement, (RdResultSet)rdResultSet.getModel(), (RdResultSetInitialState)rdResultSet.getInitialState(), this, cursor);
    }

    @Override
    @NotNull
    public Statement createStatement(@NotNull Connection connection, @NotNull BasicStatementInitializationData rdStatement, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(rdStatement, "rdStatement");
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        RdBasicStatement rdBasicStatement = (RdBasicStatement)rdStatement.getModel();
        RdBasicStatementInitialState rdBasicStatementInitialState = (RdBasicStatementInitialState)rdStatement.getInitialState();
        JdbcModel jdbcModel2 = this.jdbcModel;
        if (jdbcModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
            jdbcModel2 = null;
        }
        return new ProtocolBasicStatement(connection, rdBasicStatement, rdBasicStatementInitialState, jdbcModel2, this.getBasicStatementPool(), parentLifetime.createNested(), (JdbcFactory)this, (IStatementParser)SqlServerStatementParser.INSTANCE);
    }

    @Override
    @NotNull
    public PreparedStatement createPreparedStatement(@NotNull Connection connection, @NotNull PreparedStatementInitializationData rdStatement, @NotNull List<ParameterInitializationData> parameters2, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(rdStatement, "rdStatement");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        LifetimeDefinition statementLifetime = parentLifetime.createNested();
        JdbcFactory jdbcFactory = this;
        IParametersFactory iParametersFactory = this.getParametersFactory();
        IPreparedStatementPool iPreparedStatementPool = this.getPreparedStatementPool();
        RdPreparedStatement rdPreparedStatement = (RdPreparedStatement)rdStatement.getModel();
        RdStatementWithParamsInitialState rdStatementWithParamsInitialState = (RdStatementWithParamsInitialState)rdStatement.getInitialState();
        JdbcModel jdbcModel2 = this.jdbcModel;
        if (jdbcModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
            jdbcModel2 = null;
        }
        return new ProtocolPreparedStatement(connection, statementLifetime, jdbcFactory, iParametersFactory, iPreparedStatementPool, rdPreparedStatement, rdStatementWithParamsInitialState, jdbcModel2, parameters2, (IStatementParser)SqlServerStatementParser.INSTANCE);
    }

    @Override
    @NotNull
    public CallableStatement createCallableStatement(@NotNull Connection connection, @NotNull CalledStatementInitializationData rdStatement, @NotNull List<ParameterInitializationData> parameters2, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(rdStatement, "rdStatement");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        LifetimeDefinition statementLifetime = parentLifetime.createNested();
        JdbcFactory jdbcFactory = this;
        IParametersFactory iParametersFactory = this.getParametersFactory();
        ICallableStatementPool iCallableStatementPool = this.getCallableStatementPool();
        RdCallableStatement rdCallableStatement = (RdCallableStatement)rdStatement.getModel();
        RdStatementWithParamsInitialState rdStatementWithParamsInitialState = (RdStatementWithParamsInitialState)rdStatement.getInitialState();
        JdbcModel jdbcModel2 = this.jdbcModel;
        if (jdbcModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("jdbcModel");
            jdbcModel2 = null;
        }
        return new ProtocolCallableStatement(connection, statementLifetime, jdbcFactory, iParametersFactory, iCallableStatementPool, rdCallableStatement, rdStatementWithParamsInitialState, jdbcModel2, parameters2, SqlServerJdbcToNativeTypeTranslator.INSTANCE, SqlServerStatementParser.INSTANCE);
    }

    @Override
    @NotNull
    public ResultSetMetaData createResultSetMetadata(@NotNull RdResultSet rdResultSet) {
        Intrinsics.checkNotNullParameter(rdResultSet, "rdResultSet");
        return new ProtocolResultSetMetaData(rdResultSet, SqlServerJdbcToNativeTypeTranslator.INSTANCE, SqlServerJdbcToJavaTypeTranslator.INSTANCE);
    }

    @Override
    @NotNull
    public ParameterMetaData createStatementParameterMetadata(@NotNull StatementParameters parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        return new ProtocolParameterMetadata(parameters2, SqlServerJdbcToNativeTypeTranslator.INSTANCE, SqlServerJdbcToJavaTypeTranslator.INSTANCE);
    }

    public static final /* synthetic */ JdbcModel access$getJdbcModel$p(SqlServerFactory $this) {
        return $this.jdbcModel;
    }

    public static final /* synthetic */ ValueGetter access$getValueGetter$p(SqlServerFactory $this) {
        return $this.valueGetter;
    }

    public static final /* synthetic */ ValueSetter access$getValueSetter$p(SqlServerFactory $this) {
        return $this.valueSetter;
    }

    public static final /* synthetic */ StatementParameterPool access$getStatementParameterPool(SqlServerFactory $this) {
        return $this.getStatementParameterPool();
    }
}

