/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.factories;

import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.factories.cursors.ICursorFactory;
import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.resultsets.cursors.Cursor;
import com.jetbrains.jdbc.base.resultsets.cursors.CursorBuilder;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.RemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.crud.CursorCrudExecutor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.absolute.AbsoluteMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.afterLast.AfterLastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.beforeFirst.BeforeFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.first.FirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.last.LastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.next.NextMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.previous.PreviousMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.refresh.RefreshMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.relative.RelativeMove;
import com.jetbrains.jdbc.base.resultsets.cursors.position.CursorPositionChecker;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.CursorType;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerCursorFactory;", "Lcom/jetbrains/jdbc/base/factories/cursors/ICursorFactory;", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "(Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;)V", "createCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/Cursor;", "rdResultSet", "Lcom/jetbrains/jdbc/base/models/RdResultSet;", "cursorType", "", "concurrency", "rowsCount", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createRemoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "getClientCursor", "getFastForwardOnlyCursor", "getForwardOnlyCursor", "getKeySetDrivenCursor", "getStaticCursor", "Frontend"})
public final class SqlServerCursorFactory
implements ICursorFactory {
    @NotNull
    private final IRowsAndColumnsFactory rowsAndColumnsFactory;

    public SqlServerCursorFactory(@NotNull IRowsAndColumnsFactory rowsAndColumnsFactory) {
        Intrinsics.checkNotNullParameter(rowsAndColumnsFactory, "rowsAndColumnsFactory");
        this.rowsAndColumnsFactory = rowsAndColumnsFactory;
    }

    @Override
    @NotNull
    public Cursor createCursor(@NotNull RdResultSet rdResultSet, int cursorType, int concurrency, int rowsCount, @NotNull Lifetime lifetime) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter(rdResultSet, "rdResultSet");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        int n = cursorType;
        if (n == CursorType.ForwardOnly.getValue()) {
            cursor = this.getForwardOnlyCursor(rdResultSet, concurrency, rowsCount, lifetime);
        } else if (n == CursorType.FastForwardOnly.getValue()) {
            cursor = this.getFastForwardOnlyCursor(rdResultSet, rowsCount, lifetime);
        } else if (n == CursorType.Client.getValue()) {
            cursor = this.getClientCursor(rdResultSet, rowsCount, lifetime);
        } else if (n == CursorType.KeySetDriven.getValue()) {
            cursor = this.getKeySetDrivenCursor(rdResultSet, concurrency, rowsCount, lifetime);
        } else if (n == CursorType.Static.getValue()) {
            cursor = this.getStaticCursor(rdResultSet, rowsCount, lifetime);
        } else if (n == CursorType.Dynamic.getValue()) {
            cursor = this.getKeySetDrivenCursor(rdResultSet, concurrency, rowsCount, lifetime);
        } else {
            throw ExceptionsKt.unknownCursor(cursorType);
        }
        return cursor;
    }

    private final Cursor getForwardOnlyCursor(RdResultSet rdResultSet, int concurrency, int rowsCount, Lifetime lifetime) {
        CursorBuilder builder = new CursorBuilder(rowsCount, this.rowsAndColumnsFactory, this.createRemoteCursor(rdResultSet, lifetime)).withNext(NextMove.INSTANCE);
        if (concurrency != 1007) {
            builder.withCrudExecutor(CursorCrudExecutor.INSTANCE);
        }
        return builder.build();
    }

    private final Cursor getFastForwardOnlyCursor(RdResultSet rdResultSet, int rowsCount, Lifetime lifetime) {
        CursorBuilder builder = new CursorBuilder(rowsCount, this.rowsAndColumnsFactory, this.createRemoteCursor(rdResultSet, lifetime)).withNext(NextMove.INSTANCE);
        return builder.build();
    }

    private final Cursor getClientCursor(RdResultSet rdResultSet, int rowsCount, Lifetime lifetime) {
        CursorBuilder builder = new CursorBuilder(rowsCount, this.rowsAndColumnsFactory, this.createRemoteCursor(rdResultSet, lifetime)).withNext(NextMove.INSTANCE);
        return builder.build();
    }

    private final Cursor getKeySetDrivenCursor(RdResultSet rdResultSet, int concurrency, int rowsCount, Lifetime lifetime) {
        CursorBuilder builder = new CursorBuilder(rowsCount, this.rowsAndColumnsFactory, this.createRemoteCursor(rdResultSet, lifetime)).withNext(NextMove.INSTANCE).withPrevious(PreviousMove.INSTANCE).withAbsolute(new AbsoluteMove(BeforeFirstMove.INSTANCE, FirstMove.INSTANCE, LastMove.INSTANCE, RelativeMove.INSTANCE)).withRelative(RelativeMove.INSTANCE).withFirst(FirstMove.INSTANCE).withLast(LastMove.INSTANCE).withBeforeFirst(BeforeFirstMove.INSTANCE).withAfterLast(AfterLastMove.INSTANCE).withRefresh(RefreshMove.INSTANCE).withPositionChecker(CursorPositionChecker.INSTANCE);
        if (concurrency != 1007) {
            builder.withCrudExecutor(CursorCrudExecutor.INSTANCE);
        }
        return builder.build();
    }

    private final Cursor getStaticCursor(RdResultSet rdResultSet, int rowsCount, Lifetime lifetime) {
        CursorBuilder builder = new CursorBuilder(rowsCount, this.rowsAndColumnsFactory, this.createRemoteCursor(rdResultSet, lifetime)).withNext(NextMove.INSTANCE).withPrevious(PreviousMove.INSTANCE).withAbsolute(new AbsoluteMove(BeforeFirstMove.INSTANCE, FirstMove.INSTANCE, LastMove.INSTANCE, RelativeMove.INSTANCE)).withRelative(RelativeMove.INSTANCE).withFirst(FirstMove.INSTANCE).withLast(LastMove.INSTANCE).withBeforeFirst(BeforeFirstMove.INSTANCE).withAfterLast(AfterLastMove.INSTANCE).withPositionChecker(CursorPositionChecker.INSTANCE);
        return builder.build();
    }

    private final IRemoteCursor createRemoteCursor(RdResultSet rdResultSet, Lifetime lifetime) {
        return new RemoteCursor(rdResultSet, this.rowsAndColumnsFactory, lifetime);
    }
}

