/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetTimeRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.models.RdTime;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0013\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0017\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0019\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/set/SetTimeConverter;", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "()V", "to", "", "Ljava/sql/JDBCType;", "getTo", "()Ljava/util/List;", "fromLocalDateTime", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/time/LocalDateTime;", "sqlType", "", "fromLocalTime", "Ljava/time/LocalTime;", "fromNString", "", "fromString", "fromTime", "Ljava/sql/Time;", "timeZone", "Ljava/util/TimeZone;", "fromTimestamp", "Ljava/sql/Timestamp;", "fromUtilDate", "Ljava/util/Date;", "Frontend"})
public final class SetTimeConverter
extends SetValueConverter {
    @NotNull
    public static final SetTimeConverter INSTANCE = new SetTimeConverter();
    @NotNull
    private static final List<JDBCType> to = CollectionsKt.listOf(JDBCType.TIME);

    private SetTimeConverter() {
        super(SqlServerJdbcToNativeTypeTranslator.INSTANCE);
    }

    @NotNull
    public List<JDBCType> getTo() {
        return to;
    }

    @Override
    @NotNull
    public RdSetValueRequest fromUtilDate(@Nullable java.util.Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "value.toInstant()");
        java.util.Date date = java.util.Date.from(DateTimeUtilsKt.setBaseDate(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone)).toInstant());
        Intrinsics.checkNotNullExpressionValue(date, "from(\n                va\u2026toInstant()\n            )");
        RdTime rdTime = new RdTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTimestamp(@Nullable Timestamp value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.setBaseDate(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone)).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdTime rdTime = new RdTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalDateTime(@Nullable LocalDateTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toLocalTime().atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdTime rdTime = new RdTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTime(@Nullable Time value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        java.util.Date date = java.util.Date.from(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant());
        Intrinsics.checkNotNullExpressionValue(date, "from(instant.fromGregori\u2026an(timeZone).toInstant())");
        RdTime rdTime = new RdTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalTime(@Nullable LocalTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdTime rdTime = new RdTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        LocalTime localTime = SqlDateTimeFormatter.INSTANCE.parseLocalTime(value2);
        return this.fromLocalTime(localTime, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        return this.fromString(value2, sqlType);
    }
}

