/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.models.RdSetDoubleRequest;
import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.converters.get.GetDecimalConverter;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001f\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001f\u0010!\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\"2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/set/SetFloatConverter;", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "()V", "to", "", "Ljava/sql/JDBCType;", "getTo", "()Ljava/util/List;", "fromBigDecimal", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/math/BigDecimal;", "sqlType", "", "fromBoolean", "", "(Ljava/lang/Boolean;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromByte", "", "(Ljava/lang/Byte;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromDouble", "", "(Ljava/lang/Double;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromFloat", "", "(Ljava/lang/Float;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromInt", "(Ljava/lang/Integer;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromLong", "", "(Ljava/lang/Long;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromNString", "", "fromShort", "", "(Ljava/lang/Short;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromString", "Frontend"})
public final class SetFloatConverter
extends SetValueConverter {
    @NotNull
    public static final SetFloatConverter INSTANCE = new SetFloatConverter();
    @NotNull
    private static final List<JDBCType> to;

    private SetFloatConverter() {
        super(SqlServerJdbcToNativeTypeTranslator.INSTANCE);
    }

    @NotNull
    public List<JDBCType> getTo() {
        return to;
    }

    @Override
    @NotNull
    public RdSetValueRequest fromByte(@Nullable Byte value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = (double)value2;
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromShort(@Nullable Short value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = (double)value2;
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromInt(@Nullable Integer value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = (double)value2;
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLong(@Nullable Long value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = (double)value2;
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromFloat(@Nullable Float value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = value2.floatValue();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromDouble(@Nullable Double value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(value2, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBoolean(@Nullable Boolean value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = value2 != false ? 1.0 : 0.0;
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBigDecimal(@Nullable BigDecimal value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        if (value2.compareTo(GetDecimalConverter.INSTANCE.getDoubleMinValue()) >= 0 && value2.compareTo(GetDecimalConverter.INSTANCE.getDoubleMaxValue()) <= 0) {
            Double d = value2.doubleValue();
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetDoubleRequest(d, ((Number)n).intValue());
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Float.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Float::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Double d = Double.parseDouble(value2);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDoubleRequest(d, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        return this.fromString(value2, sqlType);
    }

    static {
        JDBCType[] jDBCTypeArray = new JDBCType[]{JDBCType.FLOAT, JDBCType.DOUBLE};
        to = CollectionsKt.listOf(jDBCTypeArray);
    }
}

