/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetBigDecimalResponse;
import com.jetbrains.jdbc.base.models.RdGetBooleanResponse;
import com.jetbrains.jdbc.base.models.RdGetByteResponse;
import com.jetbrains.jdbc.base.models.RdGetBytesResponse;
import com.jetbrains.jdbc.base.models.RdGetDateResponse;
import com.jetbrains.jdbc.base.models.RdGetDateTimeOffsetResponse;
import com.jetbrains.jdbc.base.models.RdGetDateTimeResponse;
import com.jetbrains.jdbc.base.models.RdGetDoubleResponse;
import com.jetbrains.jdbc.base.models.RdGetFloatResponse;
import com.jetbrains.jdbc.base.models.RdGetGuidResponse;
import com.jetbrains.jdbc.base.models.RdGetIntResponse;
import com.jetbrains.jdbc.base.models.RdGetLongResponse;
import com.jetbrains.jdbc.base.models.RdGetShortResponse;
import com.jetbrains.jdbc.base.models.RdGetStringResponse;
import com.jetbrains.jdbc.base.models.RdGetTimeOffsetResponse;
import com.jetbrains.jdbc.base.models.RdGetTimeResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import com.jetbrains.jdbc.sqlserver.converters.get.GetBigIntConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetBinaryConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetBitConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetDateConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetDateTimeConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetDateTimeOffsetConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetDecimalConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetFloatConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetIntConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetRealConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetSmallIntConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetStringConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetTimeConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetTinyIntConverter;
import com.jetbrains.jdbc.sqlserver.converters.get.GetUniqueIdentifierConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010CJ\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010J\u001a\u0004\u0018\u0001062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0016J\u001a\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010S\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006V"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetVariantConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getArray", "Ljava/sql/Array;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getAsciiStream", "Ljava/io/InputStream;", "getBigDecimal", "Ljava/math/BigDecimal;", "getBinaryStream", "getBlob", "Ljava/sql/Blob;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getConverter", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getRef", "Ljava/sql/Ref;", "getRowId", "Ljava/sql/RowId;", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "getSqlXml", "Ljava/sql/SQLXML;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getURL", "Ljava/net/URL;", "getUUID", "Ljava/util/UUID;", "getUnicodeStream", "getUtilDate", "Ljava/util/Date;", "Frontend"})
public final class GetVariantConverter
extends GetValueConverter {
    @NotNull
    public static final GetVariantConverter INSTANCE = new GetVariantConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.Variant);

    private GetVariantConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getString(response);
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getBoolean(response);
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getByte(response);
    }

    @Override
    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getShort(response);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getInt(response);
    }

    @Override
    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getLong(response);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getFloat(response);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getDouble(response);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getBigDecimal(response);
    }

    @Override
    @Nullable
    public byte[] getBytes(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getBytes(response);
    }

    @Override
    @Nullable
    public Date getSqlDate(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        GetValueConverter converter = this.getConverter(response);
        return converter.getSqlDate(response, timeZone);
    }

    @Override
    @Nullable
    public java.util.Date getUtilDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getUtilDate(response);
    }

    @Override
    @Nullable
    public Time getTime(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        GetValueConverter converter = this.getConverter(response);
        return converter.getTime(response, timeZone);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        GetValueConverter converter = this.getConverter(response);
        return converter.getTimestamp(response, timeZone);
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getLocalDateTime(response);
    }

    @Override
    @Nullable
    public LocalDate getLocalDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getLocalDate(response);
    }

    @Override
    @Nullable
    public LocalTime getLocalTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getLocalTime(response);
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getOffsetDateTime(response);
    }

    @Override
    @Nullable
    public OffsetTime getOffsetTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getOffsetTime(response);
    }

    @Override
    @Nullable
    public InputStream getAsciiStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getAsciiStream(response);
    }

    @Override
    @Nullable
    public InputStream getBinaryStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getBinaryStream(response);
    }

    @Override
    @Nullable
    public InputStream getUnicodeStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getUnicodeStream(response);
    }

    @Override
    @Nullable
    public Reader getCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getCharacterStream(response);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getNString(response);
    }

    @Override
    @Nullable
    public Reader getNCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getNCharacterStream(response);
    }

    @Override
    @Nullable
    public Blob getBlob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getBlob(response);
    }

    @Override
    @Nullable
    public Clob getClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getClob(response);
    }

    @Override
    @NotNull
    public Array getArray(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getArray(response);
    }

    @Override
    @NotNull
    public URL getURL(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getURL(response);
    }

    @Override
    @NotNull
    public RowId getRowId(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getRowId(response);
    }

    @Override
    @NotNull
    public Ref getRef(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getRef(response);
    }

    @Override
    @Nullable
    public NClob getNClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getNClob(response);
    }

    @Override
    @Nullable
    public SQLXML getSqlXml(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getSqlXml(response);
    }

    @Override
    @Nullable
    public UUID getUUID(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getUUID(response);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        GetValueConverter converter = this.getConverter(response);
        return converter.getObject(response);
    }

    private final GetValueConverter getConverter(RdGetValueResponse response) {
        GetValueConverter getValueConverter;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetStringResponse) {
            getValueConverter = GetStringConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetGuidResponse) {
            getValueConverter = GetUniqueIdentifierConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetBigDecimalResponse) {
            getValueConverter = GetDecimalConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetBooleanResponse) {
            getValueConverter = GetBitConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetByteResponse) {
            getValueConverter = GetTinyIntConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetBytesResponse) {
            getValueConverter = GetBinaryConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetDateResponse) {
            getValueConverter = GetDateConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetDateTimeOffsetResponse) {
            getValueConverter = GetDateTimeOffsetConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetDateTimeResponse) {
            getValueConverter = GetDateTimeConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetDoubleResponse) {
            getValueConverter = GetFloatConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetFloatResponse) {
            getValueConverter = GetRealConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetIntResponse) {
            getValueConverter = GetIntConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetLongResponse) {
            getValueConverter = GetBigIntConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetShortResponse) {
            getValueConverter = GetSmallIntConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetTimeResponse) {
            getValueConverter = GetTimeConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdGetTimeOffsetResponse) {
            getValueConverter = GetDateTimeOffsetConverter.INSTANCE;
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            getValueConverter = GetStringConverter.INSTANCE;
        } else {
            String string = response.getClass().getTypeName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.typeName");
            throw ExceptionsKt.unknownValueReceived(string);
        }
        return getValueConverter;
    }
}

