/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdDate;
import com.jetbrains.jdbc.base.models.RdGetDateResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetDateConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getLocalDate", "Ljava/time/LocalDate;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getNString", "", "getObject", "", "getSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "getString", "getTimestamp", "Ljava/sql/Timestamp;", "getUtilDate", "Ljava/util/Date;", "getValue", "Lcom/jetbrains/jdbc/base/models/RdDate;", "Frontend"})
@SourceDebugExtension(value={"SMAP\nGetDateConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetDateConverter.kt\ncom/jetbrains/jdbc/sqlserver/converters/get/GetDateConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class GetDateConverter
extends GetValueConverter {
    @NotNull
    public static final GetDateConverter INSTANCE = new GetDateConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.Date);

    private GetDateConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
        return this.getSqlDate(response, timeZone);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdDate rdDate = this.getValue(response);
        if (rdDate == null) {
            return null;
        }
        RdDate value2 = rdDate;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant();
        return Timestamp.from(instant);
    }

    @Override
    @Nullable
    public Date getSqlDate(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdDate rdDate = this.getValue(response);
        if (rdDate == null) {
            return null;
        }
        RdDate value2 = rdDate;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant();
        return new Date(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public java.util.Date getUtilDate(@NotNull RdGetValueResponse response) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        RdDate rdDate = this.getValue(response);
        if (rdDate == null) {
            return null;
        }
        RdDate value2 = rdDate;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant();
        return new java.util.Date(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDate rdDate = this.getValue(response);
        if (rdDate == null) {
            return null;
        }
        RdDate value2 = rdDate;
        Instant instant = value2.getDatetime().toInstant();
        return LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
    }

    @Override
    @Nullable
    public LocalDate getLocalDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDate rdDate = this.getValue(response);
        if (rdDate == null) {
            return null;
        }
        RdDate value2 = rdDate;
        Instant instant = value2.getDatetime().toInstant();
        LocalDateTime local = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return local.toLocalDate();
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        String string;
        LocalDate localDate;
        Intrinsics.checkNotNullParameter(response, "response");
        LocalDate localDate2 = localDate = this.getLocalDate(response);
        if (localDate2 != null) {
            LocalDate it = localDate2;
            boolean bl = false;
            string = SqlDateTimeFormatter.INSTANCE.format(it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    private final RdDate getValue(RdGetValueResponse response) {
        RdDate rdDate;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetDateResponse) {
            rdDate = ((RdGetDateResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            rdDate = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetDateResponse.Companion.get_type()).getName(), "RdGetDateResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return rdDate;
    }
}

