/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetBytesResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryBlob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryNClob;
import com.jetbrains.jdbc.base.utils.conversions.BinaryUtilsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetBinaryConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getBinaryStream", "Ljava/io/InputStream;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBlob", "Ljava/sql/Blob;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "", "getString", "getUUID", "Ljava/util/UUID;", "getValue", "Frontend"})
public final class GetBinaryConverter
extends GetValueConverter {
    @NotNull
    public static final GetBinaryConverter INSTANCE = new GetBinaryConverter();
    @NotNull
    private static final List<SqlServerType> from;

    private GetBinaryConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public byte[] getBytes(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public UUID getUUID(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getValue(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        ByteBuffer bb = ByteBuffer.wrap(value2);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    @Override
    @Nullable
    public Blob getBlob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getValue(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        return new ProtocolInMemoryBlob(value2);
    }

    @Override
    @Nullable
    public InputStream getBinaryStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getValue(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        return new ByteArrayInputStream(value2);
    }

    @Override
    @Nullable
    public Clob getClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getString(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new ProtocolInMemoryClob(str);
    }

    @Override
    @Nullable
    public NClob getNClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getString(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new ProtocolInMemoryNClob(str);
    }

    @Override
    @Nullable
    public Reader getCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getString(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new StringReader(str);
    }

    @Override
    @Nullable
    public Reader getNCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getString(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new StringReader(str);
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getValue(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        return BinaryUtilsKt.bytesToHex(value2);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    private final byte[] getValue(RdGetValueResponse response) {
        byte[] byArray;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetBytesResponse) {
            byArray = ((RdGetBytesResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            byArray = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetBytesResponse.Companion.get_type()).getName(), "RdGetBytesResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return byArray;
    }

    static {
        SqlServerType[] sqlServerTypeArray = new SqlServerType[]{SqlServerType.Binary, SqlServerType.VarBinary, SqlServerType.Image, SqlServerType.Timestamp, SqlServerType.Udt};
        from = CollectionsKt.listOf(sqlServerTypeArray);
    }
}

