/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/SqlDateTimeFormatter;", "", "()V", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "dateTimeFormat", "dateTimeOffsetFormat", "timeFormat", "timeOffsetFormat", "format", "", "localDate", "Ljava/time/LocalDate;", "localDateTime", "Ljava/time/LocalDateTime;", "localTime", "Ljava/time/LocalTime;", "offsetDateTime", "Ljava/time/OffsetDateTime;", "getDatePart", "dateTimeString", "getTimePart", "parseLocalDate", "str", "parseLocalDateTime", "parseLocalTime", "parseOffsetDateTime", "parseOffsetTime", "Ljava/time/OffsetTime;", "Frontend"})
public final class SqlDateTimeFormatter {
    @NotNull
    public static final SqlDateTimeFormatter INSTANCE = new SqlDateTimeFormatter();
    @NotNull
    private static final DateTimeFormatter dateFormat;
    @NotNull
    private static final DateTimeFormatter dateTimeFormat;
    @NotNull
    private static final DateTimeFormatter timeFormat;
    @NotNull
    private static final DateTimeFormatter dateTimeOffsetFormat;
    @NotNull
    private static final DateTimeFormatter timeOffsetFormat;

    private SqlDateTimeFormatter() {
    }

    @NotNull
    public final LocalDateTime parseLocalDateTime(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        LocalDateTime localDateTime = LocalDateTime.parse(str, dateTimeFormat);
        Intrinsics.checkNotNullExpressionValue(localDateTime, "parse(str, dateTimeFormat)");
        return localDateTime;
    }

    @NotNull
    public final LocalTime parseLocalTime(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        LocalTime localTime = LocalTime.parse(this.getTimePart(str), timeFormat);
        Intrinsics.checkNotNullExpressionValue(localTime, "parse(getTimePart(str), timeFormat)");
        return localTime;
    }

    @NotNull
    public final LocalDate parseLocalDate(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        LocalDate localDate = LocalDate.parse(this.getDatePart(str), dateFormat);
        Intrinsics.checkNotNullExpressionValue(localDate, "parse(getDatePart(str), dateFormat)");
        return localDate;
    }

    @NotNull
    public final OffsetDateTime parseOffsetDateTime(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(str, dateTimeOffsetFormat);
        Intrinsics.checkNotNullExpressionValue(offsetDateTime, "parse(str, dateTimeOffsetFormat)");
        return offsetDateTime;
    }

    @NotNull
    public final OffsetTime parseOffsetTime(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        OffsetTime offsetTime = OffsetTime.parse(str, timeOffsetFormat);
        Intrinsics.checkNotNullExpressionValue(offsetTime, "parse(str, timeOffsetFormat)");
        return offsetTime;
    }

    @NotNull
    public final String format(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter(localDateTime, "localDateTime");
        String string = localDateTime.format(dateTimeFormat);
        Intrinsics.checkNotNullExpressionValue(string, "localDateTime.format(dateTimeFormat)");
        return string;
    }

    @NotNull
    public final String format(@NotNull LocalDate localDate) {
        Intrinsics.checkNotNullParameter(localDate, "localDate");
        String string = localDate.format(dateFormat);
        Intrinsics.checkNotNullExpressionValue(string, "localDate.format(dateFormat)");
        return string;
    }

    @NotNull
    public final String format(@NotNull LocalTime localTime) {
        Intrinsics.checkNotNullParameter(localTime, "localTime");
        String string = localTime.format(timeFormat);
        Intrinsics.checkNotNullExpressionValue(string, "localTime.format(timeFormat)");
        return string;
    }

    @NotNull
    public final String format(@NotNull OffsetDateTime offsetDateTime) {
        Intrinsics.checkNotNullParameter(offsetDateTime, "offsetDateTime");
        String string = offsetDateTime.format(dateTimeOffsetFormat);
        Intrinsics.checkNotNullExpressionValue(string, "offsetDateTime.format(dateTimeOffsetFormat)");
        return string;
    }

    @NotNull
    public final String getDatePart(@NotNull String dateTimeString) {
        String string;
        Intrinsics.checkNotNullParameter(dateTimeString, "dateTimeString");
        int indexOfSpace = StringsKt.indexOf$default((CharSequence)dateTimeString, ' ', 0, false, 6, null);
        if (-1 == indexOfSpace) {
            string = dateTimeString;
        } else {
            String string2 = dateTimeString.substring(0, indexOfSpace);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    @NotNull
    public final String getTimePart(@NotNull String dateTimeString) {
        String string;
        Intrinsics.checkNotNullParameter(dateTimeString, "dateTimeString");
        int indexOfSpace = StringsKt.indexOf$default((CharSequence)dateTimeString, ' ', 0, false, 6, null);
        if (-1 == indexOfSpace) {
            string = dateTimeString;
        } else {
            String string2 = dateTimeString.substring(indexOfSpace + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    static {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "DateTimeFormatterBuilder\u2026\")\n        .toFormatter()");
        dateFormat = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).toFormatter();
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter2, "DateTimeFormatterBuilder\u2026e)\n        .toFormatter()");
        dateTimeFormat = dateTimeFormatter2;
        DateTimeFormatter dateTimeFormatter3 = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).toFormatter();
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter3, "DateTimeFormatterBuilder\u2026e)\n        .toFormatter()");
        timeFormat = dateTimeFormatter3;
        DateTimeFormatter dateTimeFormatter4 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).appendPattern("[ ]").appendOffset("+HH:MM", "+00:00").toFormatter();
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter4, "DateTimeFormatterBuilder\u2026\")\n        .toFormatter()");
        dateTimeOffsetFormat = dateTimeFormatter4;
        DateTimeFormatter dateTimeFormatter5 = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).appendPattern("[ ]").appendOffset("+HH:MM", "+00:00").toFormatter();
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter5, "DateTimeFormatterBuilder\u2026\")\n        .toFormatter()");
        timeOffsetFormat = dateTimeFormatter5;
    }
}

