/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.properties;

import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdSyncProperty;", "T", "", "initialValue", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "call", "Lcom/jetbrains/rd/framework/IRdCall;", "", "(Ljava/lang/Object;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/jetbrains/rd/framework/IRdCall;)V", "storedValue", "Ljava/lang/Object;", "get", "()Ljava/lang/Object;", "set", "value", "(Ljava/lang/Object;)V", "Frontend"})
public final class RdSyncProperty<T> {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IScheduler scheduler;
    @NotNull
    private final IRdCall<T, Unit> call;
    private T storedValue;

    public RdSyncProperty(T initialValue, @NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @NotNull IRdCall<? super T, Unit> call) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(call, "call");
        this.lifetime = lifetime;
        this.scheduler = scheduler;
        this.call = call;
        this.storedValue = initialValue;
    }

    public final void set(T value2) {
        if (!Intrinsics.areEqual(this.storedValue, value2)) {
            ProtocolUtilsKt.sync(this.lifetime, value2, this.scheduler, this.call);
            this.storedValue = value2;
        }
    }

    public final T get() {
        return this.storedValue;
    }
}

