/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.pooling;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdStatementParameter;
import com.jetbrains.jdbc.base.models.RdStatementParameterInitialState;
import com.jetbrains.jdbc.base.models.RdStatementWithParams;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ParameterInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IStatementParameterPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.ProtocolPool;
import com.jetbrains.rd.util.reactive.ISignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0017\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/pooling/StatementParameterPool;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ProtocolPool;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementParameterPool;", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "poolSize", "", "(Lcom/jetbrains/jdbc/base/models/JdbcModel;I)V", "getInitialState", "Lcom/jetbrains/jdbc/base/models/RdStatementParameterInitialState;", "id", "rentParameters", "", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ParameterInitializationData;", "statement", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;", "count", "returnParameter", "", "parameter", "Lcom/jetbrains/jdbc/base/models/RdStatementParameter;", "returnParameters", "parameters", "", "([Lcom/jetbrains/jdbc/base/models/RdStatementParameter;)V", "Frontend"})
public final class StatementParameterPool
extends ProtocolPool
implements IStatementParameterPool {
    public StatementParameterPool(@NotNull JdbcModel model, int poolSize) {
        Intrinsics.checkNotNullParameter(model, "model");
        super(model, poolSize);
    }

    @Override
    @NotNull
    public List<ParameterInitializationData> rentParameters(@NotNull RdStatementWithParams statement, int count2) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        if (count2 == 0) {
            return CollectionsKt.emptyList();
        }
        List parameters2 = new ArrayList();
        return (List)ProtocolUtilsKt.queueAndWait(this.getScheduler(), (Function0)new Function0<List<ParameterInitializationData>>(count2, this, (List<ParameterInitializationData>)parameters2, statement){
            final /* synthetic */ int $count;
            final /* synthetic */ StatementParameterPool this$0;
            final /* synthetic */ List<ParameterInitializationData> $parameters;
            final /* synthetic */ RdStatementWithParams $statement;
            {
                this.$count = $count;
                this.this$0 = $receiver;
                this.$parameters = $parameters;
                this.$statement = $statement;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ParameterInitializationData> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                StatementParameterPool statementParameterPool2;
                for (int i = 0; i < this.$count; ++i) {
                    RdStatementParameter parameter2;
                    if (this.this$0.getFreeObjects().isEmpty()) {
                        statementParameterPool2 = this.this$0;
                        statementParameterPool2.setObjectId(statementParameterPool2.getObjectId() + 1);
                        parameter2 = new RdStatementParameter(statementParameterPool2.getObjectId());
                        ((Map)this.this$0.getModel().getParameters()).put(parameter2.getId(), parameter2);
                        this.$parameters.add(new ParameterInitializationData(parameter2, StatementParameterPool.access$getInitialState(this.this$0, parameter2.getId())));
                        continue;
                    }
                    V v = this.this$0.getModel().getParameters().get(this.this$0.getFreeObjects().removeFirst());
                    Intrinsics.checkNotNull(v);
                    parameter2 = (RdStatementParameter)v;
                    this.$parameters.add(new ParameterInitializationData(parameter2, StatementParameterPool.access$getInitialState(this.this$0, parameter2.getId())));
                }
                Iterable i = this.$parameters;
                ISignal<List<RdStatementParameterInitialState>> iSignal = this.$statement.getCreateParameters();
                boolean $i$f$map = false;
                statementParameterPool2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ParameterInitializationData parameterInitializationData = (ParameterInitializationData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((RdStatementParameterInitialState)it.getInitialState());
                }
                iSignal.fire((List)destination$iv$iv);
                return this.$parameters;
            }
        });
    }

    @Override
    public void returnParameters(RdStatementParameter ... parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        ProtocolUtilsKt.queueAndWait(this.getScheduler(), (Function0)new Function0<Unit>(parameters2, this){
            final /* synthetic */ RdStatementParameter[] $parameters;
            final /* synthetic */ StatementParameterPool this$0;
            {
                this.$parameters = $parameters;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (RdStatementParameter parameter2 : this.$parameters) {
                    if (this.this$0.getFreeObjects().size() >= this.this$0.getPoolSize()) {
                        this.this$0.getModel().getParameters().remove(parameter2.getId());
                        continue;
                    }
                    this.this$0.getFreeObjects().addLast(parameter2.getId());
                }
            }
        });
    }

    @Override
    public void returnParameter(@NotNull RdStatementParameter parameter2) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        RdStatementParameter[] rdStatementParameterArray = new RdStatementParameter[]{parameter2};
        this.returnParameters(rdStatementParameterArray);
    }

    private final RdStatementParameterInitialState getInitialState(int id) {
        return new RdStatementParameterInitialState(null, null, id);
    }

    public static final /* synthetic */ RdStatementParameterInitialState access$getInitialState(StatementParameterPool $this, int id) {
        return $this.getInitialState(id);
    }
}

