/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.pooling;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ProtocolPool;", "", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "poolSize", "", "(Lcom/jetbrains/jdbc/base/models/JdbcModel;I)V", "freeObjects", "Ljava/util/LinkedList;", "getFreeObjects", "()Ljava/util/LinkedList;", "getModel", "()Lcom/jetbrains/jdbc/base/models/JdbcModel;", "objectId", "getObjectId", "()I", "setObjectId", "(I)V", "getPoolSize", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "getScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "Frontend"})
public abstract class ProtocolPool {
    @NotNull
    private final JdbcModel model;
    private final int poolSize;
    @NotNull
    private final LinkedList<Integer> freeObjects;
    private int objectId;

    public ProtocolPool(@NotNull JdbcModel model, int poolSize) {
        Intrinsics.checkNotNullParameter(model, "model");
        this.model = model;
        this.poolSize = poolSize;
        this.freeObjects = new LinkedList();
    }

    @NotNull
    protected final JdbcModel getModel() {
        return this.model;
    }

    protected final int getPoolSize() {
        return this.poolSize;
    }

    @NotNull
    protected final LinkedList<Integer> getFreeObjects() {
        return this.freeObjects;
    }

    protected final int getObjectId() {
        return this.objectId;
    }

    protected final void setObjectId(int n) {
        this.objectId = n;
    }

    @NotNull
    protected final IScheduler getScheduler() {
        return JdbcModelExtKt.getScheduler(this.model);
    }
}

