/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.pooling;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.models.RdPreparedStatement;
import com.jetbrains.jdbc.base.models.RdStatementWithParamsInitialState;
import com.jetbrains.jdbc.base.utils.protocol.initialization.PreparedStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IPreparedStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.StatementWithParamsPool;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/pooling/PreparedStatementPool;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/StatementWithParamsPool;", "Lcom/jetbrains/jdbc/base/models/RdPreparedStatement;", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/PreparedStatementInitializationData;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IPreparedStatementPool;", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "poolSize", "", "(Lcom/jetbrains/jdbc/base/models/JdbcModel;I)V", "createRdStatement", "id", "createResponse", "rdStatement", "state", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;", "fireCreateStatement", "", "connection", "Lcom/jetbrains/jdbc/base/models/RdConnection;", "getStatementStorage", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "Frontend"})
public final class PreparedStatementPool
extends StatementWithParamsPool<RdPreparedStatement, PreparedStatementInitializationData>
implements IPreparedStatementPool {
    public PreparedStatementPool(@NotNull JdbcModel model, int poolSize) {
        Intrinsics.checkNotNullParameter(model, "model");
        super(model, poolSize);
    }

    @Override
    @NotNull
    protected RdPreparedStatement createRdStatement(int id) {
        return new RdPreparedStatement(id);
    }

    @Override
    protected void fireCreateStatement(@NotNull RdConnection connection, @NotNull RdStatementWithParamsInitialState state) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(state, "state");
        connection.getCreatePreparedStatement().fire(state);
    }

    @Override
    @NotNull
    protected IMutableViewableMap<Integer, RdPreparedStatement> getStatementStorage() {
        return this.getModel().getPreparedStatements();
    }

    @Override
    @NotNull
    protected PreparedStatementInitializationData createResponse(@NotNull RdPreparedStatement rdStatement, @NotNull RdStatementWithParamsInitialState state) {
        Intrinsics.checkNotNullParameter(rdStatement, "rdStatement");
        Intrinsics.checkNotNullParameter(state, "state");
        return new PreparedStatementInitializationData(rdStatement, state);
    }
}

