/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.hosting;

import com.jetbrains.jdbc.base.utils.FileExtKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.logging.ILoggerProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/hosting/DotNetBackendStarter;", "", "loggerProvider", "Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;", "(Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;)V", "logger", "Ljava/util/logging/Logger;", "addArgs", "", "args", "", "", "port", "", "logOnceExited", "backendProcess", "Ljava/lang/Process;", "runExecutable", "pathToBackend", "runWithDotNet", "pathToDotNet", "pathToBackendDll", "start", "Companion", "Frontend"})
public final class DotNetBackendStarter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String DOTNET_PATH = "jetbrains.sqlserver.driver.dotnet.path";
    @NotNull
    public static final String BACKEND_PATH = "jetbrains.sqlserver.driver.backend.path";

    public DotNetBackendStarter(@NotNull ILoggerProvider loggerProvider) {
        Intrinsics.checkNotNullParameter(loggerProvider, "loggerProvider");
        this.logger = loggerProvider.getLogger(DotNetBackendStarter.class);
    }

    public final void start(int port) {
        String pathToDotNet = System.getProperty(DOTNET_PATH);
        String pathToBackend = System.getProperty(BACKEND_PATH);
        CharSequence charSequence = pathToBackend;
        if (charSequence == null || charSequence.length() == 0) {
            throw ExceptionsKt.pathToBackendIsMissing();
        }
        Intrinsics.checkNotNullExpressionValue(pathToBackend, "pathToBackend");
        if (Intrinsics.areEqual(FileExtKt.getExtension(pathToBackend), "dll")) {
            charSequence = pathToDotNet;
            if (charSequence == null || charSequence.length() == 0) {
                throw ExceptionsKt.pathToDotNetIsMissing();
            }
            Intrinsics.checkNotNullExpressionValue(pathToDotNet, "pathToDotNet");
            this.runWithDotNet(pathToDotNet, pathToBackend, port);
        } else {
            this.runExecutable(pathToBackend, port);
        }
    }

    private final void runWithDotNet(String pathToDotNet, String pathToBackendDll, int port) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List args2 = new ArrayList();
        args2.add(pathToDotNet);
        args2.add(pathToBackendDll);
        this.addArgs(args2, port);
        processBuilder.command(args2);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        Process process = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue(process, "processBuilder.start()");
        this.logOnceExited(process);
    }

    private final void runExecutable(String pathToBackend, int port) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List args2 = new ArrayList();
        args2.add(pathToBackend);
        this.addArgs(args2, port);
        processBuilder.command(args2);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        Process process = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue(process, "processBuilder.start()");
        this.logOnceExited(process);
    }

    private final void addArgs(List<String> args2, int port) {
        args2.add(String.valueOf(port));
        args2.add(String.valueOf(ProcessHandle.current().pid()));
    }

    private final void logOnceExited(Process backendProcess) {
        backendProcess.onExit().thenAccept(arg_0 -> DotNetBackendStarter.logOnceExited$lambda$0(new Function1<Process, Unit>(this){
            final /* synthetic */ DotNetBackendStarter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Process it) {
                int exitValue = it.exitValue();
                if (exitValue != 0) {
                    DotNetBackendStarter.access$getLogger$p(this.this$0).warning("Backend process exited with code = " + it.exitValue());
                }
            }
        }, arg_0));
    }

    private static final void logOnceExited$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DotNetBackendStarter $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/hosting/DotNetBackendStarter$Companion;", "", "()V", "BACKEND_PATH", "", "DOTNET_PATH", "Frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

