/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol;

import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000b\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u000b\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n\u001a\u001a\u0010\r\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"checkIfValid", "", "Lcom/jetbrains/jdbc/base/models/RdConnection;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "timeout", "", "commit", "", "getSchema", "", "rollback", "savepointName", "setSavepoint", "name", "Frontend"})
public final class RdConnectionExtKt {
    public static final void commit(@NotNull RdConnection $this$commit, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter($this$commit, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        ProtocolUtilsKt.sync(lifetime, Unit.INSTANCE, JdbcModelExtKt.getScheduler($this$commit), $this$commit.getCommitCurrentTransaction());
    }

    public static final void rollback(@NotNull RdConnection $this$rollback, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter($this$rollback, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        ProtocolUtilsKt.sync(lifetime, Unit.INSTANCE, JdbcModelExtKt.getScheduler($this$rollback), $this$rollback.getRollbackTransaction());
    }

    public static final void rollback(@NotNull RdConnection $this$rollback, @NotNull Lifetime lifetime, @NotNull String savepointName) {
        Intrinsics.checkNotNullParameter($this$rollback, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(savepointName, "savepointName");
        ProtocolUtilsKt.sync(lifetime, savepointName, JdbcModelExtKt.getScheduler($this$rollback), $this$rollback.getRollbackTransactionToSavepoint());
    }

    public static final void setSavepoint(@NotNull RdConnection $this$setSavepoint, @NotNull Lifetime lifetime, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$setSavepoint, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(name, "name");
        ProtocolUtilsKt.sync(lifetime, name, JdbcModelExtKt.getScheduler($this$setSavepoint), $this$setSavepoint.getSetSavepoint());
    }

    public static final boolean checkIfValid(@NotNull RdConnection $this$checkIfValid, @NotNull Lifetime lifetime, int timeout) {
        Intrinsics.checkNotNullParameter($this$checkIfValid, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        return ProtocolUtilsKt.sync(lifetime, timeout, JdbcModelExtKt.getScheduler($this$checkIfValid), $this$checkIfValid.getCheckIfValid());
    }

    @NotNull
    public static final String getSchema(@NotNull RdConnection $this$getSchema, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter($this$getSchema, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        return ProtocolUtilsKt.sync(lifetime, Unit.INSTANCE, JdbcModelExtKt.getScheduler($this$getSchema), $this$getSchema.getGetSchema());
    }
}

