/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.logging;

import com.jetbrains.jdbc.base.utils.logging.ILoggerProvider;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u001c\u0010\u0006\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/jdbc/base/utils/logging/LoggerProvider;", "Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;", "baseLogger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "getBaseLogger", "getLogger", "T", "c", "Ljava/lang/Class;", "Frontend"})
public final class LoggerProvider
implements ILoggerProvider {
    @NotNull
    private final Logger baseLogger;

    public LoggerProvider(@NotNull Logger baseLogger) {
        Intrinsics.checkNotNullParameter(baseLogger, "baseLogger");
        this.baseLogger = baseLogger;
    }

    @Override
    @NotNull
    public Logger getBaseLogger() {
        return this.baseLogger;
    }

    @Override
    @NotNull
    public <T> Logger getLogger(@NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        Logger logger = Logger.getLogger(this.baseLogger.getName() + "." + c.getSimpleName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"${baseLogger.name}.${c.simpleName}\")");
        return logger;
    }
}

