/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.conversions;

import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"HEX_ARRAY", "", "fromChar", "", "c", "", "bytesToHex", "", "hexToBytes", "Frontend"})
public final class BinaryUtilsKt {
    @NotNull
    private static final byte[] HEX_ARRAY;

    @NotNull
    public static final byte[] hexToBytes(@NotNull String $this$hexToBytes) {
        Intrinsics.checkNotNullParameter($this$hexToBytes, "<this>");
        if ($this$hexToBytes.length() % 2 != 0) {
            throw ExceptionsKt.notInHexadecimal();
        }
        byte[] bytes = new byte[$this$hexToBytes.length() / 2];
        int j = 0;
        int i = 0;
        while (j < bytes.length) {
            int byteHigh = BinaryUtilsKt.fromChar($this$hexToBytes.charAt(i));
            int byteLow = BinaryUtilsKt.fromChar($this$hexToBytes.charAt(i + 1));
            if ((byteLow | byteHigh) == 255) break;
            bytes[j++] = (byte)(byteHigh << 4 | byteLow);
            i += 2;
        }
        return bytes;
    }

    @NotNull
    public static final String bytesToHex(@NotNull byte[] $this$bytesToHex) {
        Intrinsics.checkNotNullParameter($this$bytesToHex, "<this>");
        byte[] hexChars = new byte[$this$bytesToHex.length * 2];
        int n = $this$bytesToHex.length;
        for (int i = 0; i < n; ++i) {
            int v = $this$bytesToHex[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        Charset charset2 = charset;
        return new String(hexChars, charset2);
    }

    private static final int fromChar(char c) {
        boolean bl = 'A' <= c ? c < 'G' : false;
        if (bl) {
            return c - 65 + 10;
        }
        boolean bl2 = 'a' <= c ? c < 'g' : false;
        if (bl2) {
            return c - 97 + 10;
        }
        boolean bl3 = '0' <= c ? c < ':' : false;
        if (bl3) {
            return c - 48;
        }
        throw ExceptionsKt.notInHexadecimal();
    }

    static {
        String string = "0123456789ABCDEF";
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        HEX_ARRAY = byArray;
    }
}

